/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.util.proto.ProtoOutputStream;
import com.android.internal.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Queue;

class WindowTraceBuffer {
    private static final long MAGIC_NUMBER_VALUE = 4990904633914181975L;
    private final Object mBufferLock = new Object();
    private final Queue<ProtoOutputStream> mBuffer = new ArrayDeque<ProtoOutputStream>();
    private int mBufferUsedSize;
    private int mBufferCapacity;

    WindowTraceBuffer(int bufferCapacity) {
        this.mBufferCapacity = bufferCapacity;
        this.resetBuffer();
    }

    int getAvailableSpace() {
        return this.mBufferCapacity - this.mBufferUsedSize;
    }

    int size() {
        return this.mBuffer.size();
    }

    void setCapacity(int capacity) {
        this.mBufferCapacity = capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(ProtoOutputStream proto) {
        int protoLength = proto.getRawSize();
        if (protoLength > this.mBufferCapacity) {
            throw new IllegalStateException("Trace object too large for the buffer. Buffer size:" + this.mBufferCapacity + " Object size: " + protoLength);
        }
        Object object = this.mBufferLock;
        synchronized (object) {
            this.discardOldest(protoLength);
            this.mBuffer.add(proto);
            this.mBufferUsedSize += protoLength;
            this.mBufferLock.notify();
        }
    }

    boolean contains(byte[] other) {
        return this.mBuffer.stream().anyMatch(p -> Arrays.equals(p.getBytes(), other));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeTraceToFile(File traceFile) throws IOException {
        Object object = this.mBufferLock;
        synchronized (object) {
            traceFile.delete();
            try (FileOutputStream os = new FileOutputStream(traceFile);){
                traceFile.setReadable(true, false);
                ProtoOutputStream proto = new ProtoOutputStream();
                proto.write(0x10600000001L, 4990904633914181975L);
                ((OutputStream)os).write(proto.getBytes());
                Iterator iterator = this.mBuffer.iterator();
                while (iterator.hasNext()) {
                    ProtoOutputStream protoOutputStream;
                    proto = protoOutputStream = (ProtoOutputStream)iterator.next();
                    byte[] protoBytes = proto.getBytes();
                    ((OutputStream)os).write(protoBytes);
                }
                os.flush();
            }
        }
    }

    private void discardOldest(int protoLength) {
        long availableSpace = this.getAvailableSpace();
        while (availableSpace < (long)protoLength) {
            ProtoOutputStream item = this.mBuffer.poll();
            if (item == null) {
                throw new IllegalStateException("No element to discard from buffer");
            }
            this.mBufferUsedSize -= item.getRawSize();
            availableSpace = this.getAvailableSpace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetBuffer() {
        Object object = this.mBufferLock;
        synchronized (object) {
            this.mBuffer.clear();
            this.mBufferUsedSize = 0;
        }
    }

    @VisibleForTesting
    int getBufferSize() {
        return this.mBufferUsedSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getStatus() {
        Object object = this.mBufferLock;
        synchronized (object) {
            return "Buffer size: " + this.mBufferCapacity + " bytes\nBuffer usage: " + this.mBufferUsedSize + " bytes\nElements in the buffer: " + this.mBuffer.size();
        }
    }
}

