/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm;

import android.os.Build;
import android.os.ShellCommand;
import android.os.SystemClock;
import android.os.Trace;
import android.util.Log;
import android.util.proto.ProtoOutputStream;
import android.view.Choreographer;
import com.android.server.wm.WindowManagerGlobalLock;
import com.android.server.wm.WindowManagerService;
import com.android.server.wm.WindowTraceBuffer;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;

class WindowTracing {
    private static final int BUFFER_CAPACITY_CRITICAL = 524288;
    private static final int BUFFER_CAPACITY_TRIM = 0x200000;
    private static final int BUFFER_CAPACITY_ALL = 0x400000;
    private static final String TRACE_FILENAME = "/data/misc/wmtrace/wm_trace.pb";
    private static final String TAG = "WindowTracing";
    private final WindowManagerService mService;
    private final Choreographer mChoreographer;
    private final WindowManagerGlobalLock mGlobalLock;
    private final Object mEnabledLock = new Object();
    private final File mTraceFile;
    private final WindowTraceBuffer mBuffer;
    private final Choreographer.FrameCallback mFrameCallback = frameTimeNanos -> this.log("onFrame");
    private int mLogLevel = 1;
    private boolean mLogOnFrame = false;
    private boolean mEnabled;
    private volatile boolean mEnabledLockFree;
    private boolean mScheduled;

    static WindowTracing createDefaultAndStartLooper(WindowManagerService service, Choreographer choreographer) {
        File file = new File(TRACE_FILENAME);
        return new WindowTracing(file, service, choreographer, 0x200000);
    }

    private WindowTracing(File file, WindowManagerService service, Choreographer choreographer, int bufferCapacity) {
        this(file, service, choreographer, service.mGlobalLock, bufferCapacity);
    }

    WindowTracing(File file, WindowManagerService service, Choreographer choreographer, WindowManagerGlobalLock globalLock, int bufferCapacity) {
        this.mChoreographer = choreographer;
        this.mService = service;
        this.mGlobalLock = globalLock;
        this.mTraceFile = file;
        this.mBuffer = new WindowTraceBuffer(bufferCapacity);
        this.setLogLevel(1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startTrace(PrintWriter pw) {
        if (Build.IS_USER) {
            this.logAndPrintln(pw, "Error: Tracing is not supported on user builds.");
            return;
        }
        Object object = this.mEnabledLock;
        synchronized (object) {
            this.logAndPrintln(pw, "Start tracing to " + this.mTraceFile + ".");
            this.mBuffer.resetBuffer();
            this.mEnabledLockFree = true;
            this.mEnabled = true;
        }
        this.log("trace.enable");
    }

    void stopTrace(PrintWriter pw) {
        this.stopTrace(pw, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopTrace(PrintWriter pw, boolean writeToFile) {
        if (Build.IS_USER) {
            this.logAndPrintln(pw, "Error: Tracing is not supported on user builds.");
            return;
        }
        Object object = this.mEnabledLock;
        synchronized (object) {
            this.logAndPrintln(pw, "Stop tracing to " + this.mTraceFile + ". Waiting for traces to flush.");
            this.mEnabledLockFree = false;
            this.mEnabled = false;
            if (this.mEnabled) {
                this.logAndPrintln(pw, "ERROR: tracing was re-enabled while waiting for flush.");
                throw new IllegalStateException("tracing enabled while waiting for flush.");
            }
            if (writeToFile) {
                this.writeTraceToFileLocked();
                this.logAndPrintln(pw, "Trace written to " + this.mTraceFile + ".");
            }
        }
    }

    private void setLogLevel(int logLevel, PrintWriter pw) {
        this.logAndPrintln(pw, "Setting window tracing log level to " + logLevel);
        this.mLogLevel = logLevel;
        switch (logLevel) {
            case 0: {
                this.setBufferCapacity(0x400000, pw);
                break;
            }
            case 1: {
                this.setBufferCapacity(0x200000, pw);
                break;
            }
            case 2: {
                this.setBufferCapacity(524288, pw);
            }
        }
    }

    private void setLogFrequency(boolean onFrame, PrintWriter pw) {
        this.logAndPrintln(pw, "Setting window tracing log frequency to " + (onFrame ? "frame" : "transaction"));
        this.mLogOnFrame = onFrame;
    }

    private void setBufferCapacity(int capacity, PrintWriter pw) {
        this.logAndPrintln(pw, "Setting window tracing buffer capacity to " + capacity + "bytes");
        this.mBuffer.setCapacity(capacity);
    }

    boolean isEnabled() {
        return this.mEnabledLockFree;
    }

    int onShellCommand(ShellCommand shell) {
        String cmd;
        PrintWriter pw = shell.getOutPrintWriter();
        switch (cmd = shell.getNextArgRequired()) {
            case "start": {
                this.startTrace(pw);
                return 0;
            }
            case "stop": {
                this.stopTrace(pw);
                return 0;
            }
            case "status": {
                this.logAndPrintln(pw, this.getStatus());
                return 0;
            }
            case "frame": {
                this.setLogFrequency(true, pw);
                this.mBuffer.resetBuffer();
                return 0;
            }
            case "transaction": {
                this.setLogFrequency(false, pw);
                this.mBuffer.resetBuffer();
                return 0;
            }
            case "level": {
                String logLevelStr;
                switch (logLevelStr = shell.getNextArgRequired().toLowerCase()) {
                    case "all": {
                        this.setLogLevel(0, pw);
                        break;
                    }
                    case "trim": {
                        this.setLogLevel(1, pw);
                        break;
                    }
                    case "critical": {
                        this.setLogLevel(2, pw);
                        break;
                    }
                    default: {
                        this.setLogLevel(1, pw);
                    }
                }
                this.mBuffer.resetBuffer();
                return 0;
            }
            case "size": {
                this.setBufferCapacity(Integer.parseInt(shell.getNextArgRequired()) * 1024, pw);
                this.mBuffer.resetBuffer();
                return 0;
            }
        }
        pw.println("Unknown command: " + cmd);
        pw.println("Window manager trace options:");
        pw.println("  start: Start logging");
        pw.println("  stop: Stop logging");
        pw.println("  frame: Log trace once per frame");
        pw.println("  transaction: Log each transaction");
        pw.println("  size: Set the maximum log size (in KB)");
        pw.println("  status: Print trace status");
        pw.println("  level [lvl]: Set the log level between");
        pw.println("    lvl may be one of:");
        pw.println("      critical: Only visible windows with reduced information");
        pw.println("      trim: All windows with reduced");
        pw.println("      all: All window and information");
        return -1;
    }

    String getStatus() {
        return "Status: " + (this.isEnabled() ? "Enabled" : "Disabled") + "\nLog level: " + this.mLogLevel + "\n" + this.mBuffer.getStatus();
    }

    void logState(String where) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.mLogOnFrame) {
            this.schedule();
        } else {
            this.log(where);
        }
    }

    private void schedule() {
        if (this.mScheduled) {
            return;
        }
        this.mScheduled = true;
        this.mChoreographer.postFrameCallback(this.mFrameCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void log(String where) {
        Trace.traceBegin(32L, "traceStateLocked");
        try {
            ProtoOutputStream os = new ProtoOutputStream();
            long tokenOuter = os.start(0x20B00000002L);
            os.write(0x10600000001L, SystemClock.elapsedRealtimeNanos());
            os.write(1138166333442L, where);
            long tokenInner = os.start(1146756268035L);
            WindowManagerGlobalLock windowManagerGlobalLock = this.mGlobalLock;
            synchronized (windowManagerGlobalLock) {
                try {
                    WindowManagerService.boostPriorityForLockedSection();
                    Trace.traceBegin(32L, "writeToProtoLocked");
                    try {
                        this.mService.writeToProtoLocked(os, this.mLogLevel);
                    }
                    finally {
                        Trace.traceEnd(32L);
                    }
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[0, 4, 6] lbl22 : MonitorExitStatement: MONITOREXIT : var7_6
                    WindowManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            WindowManagerService.resetPriorityAfterLockedSection();
            os.end(tokenInner);
            os.end(tokenOuter);
            this.mBuffer.add(os);
            this.mScheduled = false;
        }
        catch (Exception e) {
            Log.wtf(TAG, "Exception while tracing state", e);
        }
        finally {
            Trace.traceEnd(32L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeTraceToFile() {
        Object object = this.mEnabledLock;
        synchronized (object) {
            this.writeTraceToFileLocked();
        }
    }

    private void logAndPrintln(PrintWriter pw, String msg) {
        Log.i(TAG, msg);
        if (pw != null) {
            pw.println(msg);
            pw.flush();
        }
    }

    private void writeTraceToFileLocked() {
        try {
            Trace.traceBegin(32L, "writeTraceToFileLocked");
            this.mBuffer.writeTraceToFile(this.mTraceFile);
        }
        catch (IOException e) {
            Log.e(TAG, "Unable to write buffer to file", e);
        }
        finally {
            Trace.traceEnd(32L);
        }
    }
}

