/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.wm.utils;

import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.wm.utils.CoordinateTransforms;

public class DisplayRotationUtil {
    private final Matrix mTmpMatrix = new Matrix();

    private static int getRotationToBoundsOffset(int rotation) {
        switch (rotation) {
            case 0: {
                return 0;
            }
            case 1: {
                return -1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 1;
            }
        }
        return 0;
    }

    @VisibleForTesting
    static int getBoundIndexFromRotation(int i, int rotation) {
        return Math.floorMod(i + DisplayRotationUtil.getRotationToBoundsOffset(rotation), 4);
    }

    public Rect[] getRotatedBounds(Rect[] bounds, int rotation, int initialDisplayWidth, int initialDisplayHeight) {
        if (bounds.length != 4) {
            throw new IllegalArgumentException("bounds must have exactly 4 elements: bounds=" + bounds);
        }
        if (rotation == 0) {
            return bounds;
        }
        CoordinateTransforms.transformPhysicalToLogicalCoordinates(rotation, initialDisplayWidth, initialDisplayHeight, this.mTmpMatrix);
        Rect[] newBounds = new Rect[4];
        for (int i = 0; i < bounds.length; ++i) {
            Rect rect = bounds[i];
            if (!rect.isEmpty()) {
                RectF rectF = new RectF(rect);
                this.mTmpMatrix.mapRect(rectF);
                rectF.round(rect);
            }
            newBounds[DisplayRotationUtil.getBoundIndexFromRotation((int)i, (int)rotation)] = rect;
        }
        return newBounds;
    }
}

