/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.startop.iorap;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.startop.iorap.ActivityInfo;
import com.google.android.startop.iorap.CheckHelpers;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class ActivityHintEvent
implements Parcelable {
    public static final int TYPE_STARTED = 0;
    public static final int TYPE_CANCELLED = 1;
    public static final int TYPE_COMPLETED = 2;
    public static final int TYPE_POST_COMPLETED = 3;
    private static final int TYPE_MAX = 3;
    public final int type;
    public final ActivityInfo activityInfo;
    public static final Parcelable.Creator<ActivityHintEvent> CREATOR = new Parcelable.Creator<ActivityHintEvent>(){

        @Override
        public ActivityHintEvent createFromParcel(Parcel in) {
            return new ActivityHintEvent(in);
        }

        public ActivityHintEvent[] newArray(int size) {
            return new ActivityHintEvent[size];
        }
    };

    public ActivityHintEvent(int type, ActivityInfo activityInfo) {
        this.type = type;
        this.activityInfo = activityInfo;
        this.checkConstructorArguments();
    }

    private void checkConstructorArguments() {
        CheckHelpers.checkTypeInRange(this.type, 3);
        Objects.requireNonNull(this.activityInfo, "activityInfo");
    }

    public String toString() {
        return String.format("{type: %d, activityInfo: %s}", this.type, this.activityInfo);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ActivityHintEvent) {
            return this.equals((ActivityHintEvent)other);
        }
        return false;
    }

    private boolean equals(ActivityHintEvent other) {
        return this.type == other.type && Objects.equals(this.activityInfo, other.activityInfo);
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.type);
        this.activityInfo.writeToParcel(out, flags);
    }

    private ActivityHintEvent(Parcel in) {
        this.type = in.readInt();
        this.activityInfo = ActivityInfo.CREATOR.createFromParcel(in);
        this.checkConstructorArguments();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Type {
    }
}

