/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.startop.iorap;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.proto.ProtoOutputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.InvocationTargetException;
import java.util.Objects;

public abstract class AppLaunchEvent
implements Parcelable {
    public final long sequenceId;
    public static Parcelable.Creator<AppLaunchEvent> CREATOR = new Parcelable.Creator<AppLaunchEvent>(){

        @Override
        public AppLaunchEvent createFromParcel(Parcel source) {
            int typeIndex = source.readInt();
            Class kls = AppLaunchEvent.getClassFromTypeIndex(typeIndex);
            if (kls == null) {
                throw new IllegalArgumentException("Invalid type index: " + typeIndex);
            }
            try {
                return (AppLaunchEvent)kls.getConstructor(Parcel.class).newInstance(source);
            }
            catch (InstantiationException e) {
                throw new AssertionError((Object)e);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            catch (InvocationTargetException e) {
                throw new AssertionError((Object)e);
            }
            catch (NoSuchMethodException e) {
                throw new AssertionError((Object)e);
            }
        }

        public AppLaunchEvent[] newArray(int size) {
            return new AppLaunchEvent[0];
        }
    };
    private static Class<?>[] sTypes = new Class[]{IntentStarted.class, IntentFailed.class, ActivityLaunched.class, ActivityLaunchFinished.class, ActivityLaunchCancelled.class};

    protected AppLaunchEvent(long sequenceId) {
        this.sequenceId = sequenceId;
    }

    public boolean equals(Object other) {
        if (other instanceof AppLaunchEvent) {
            return this.equals((AppLaunchEvent)other);
        }
        return false;
    }

    protected boolean equals(AppLaunchEvent other) {
        return this.sequenceId == other.sequenceId;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{sequenceId=" + Long.toString(this.sequenceId) + this.toStringBody() + "}";
    }

    protected String toStringBody() {
        return "";
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel p, int flags) {
        p.writeInt(this.getTypeIndex());
        this.writeToParcelImpl(p, flags);
    }

    protected void writeToParcelImpl(Parcel p, int flags) {
        p.writeLong(this.sequenceId);
    }

    protected AppLaunchEvent(Parcel p) {
        this.sequenceId = p.readLong();
    }

    private int getTypeIndex() {
        for (int i = 0; i < sTypes.length; ++i) {
            if (!sTypes[i].equals(this.getClass())) continue;
            return i;
        }
        throw new AssertionError((Object)("sTypes did not include this type: " + this.getClass()));
    }

    private static Class<?> getClassFromTypeIndex(int typeIndex) {
        if (typeIndex >= 0 && typeIndex < sTypes.length) {
            return sTypes[typeIndex];
        }
        return null;
    }

    public static class IntentProtoParcelable {
        private static final int INTENT_PROTO_CHUNK_SIZE = 1024;

        public static void write(Parcel p, Intent intent, int flags) {
            ProtoOutputStream protoOutputStream = new ProtoOutputStream(1024);
            intent.writeToProto(protoOutputStream);
            byte[] bytes = protoOutputStream.getBytes();
            p.writeByteArray(bytes);
        }

        public static Intent create(Parcel p) {
            byte[] data = p.createByteArray();
            return new Intent("<cannot deserialize IntentProto>");
        }
    }

    public static class ActivityRecordProtoParcelable {
        public static void write(Parcel p, byte[] activityRecordSnapshot, int flags) {
            p.writeByteArray(activityRecordSnapshot);
        }

        public static byte[] create(Parcel p) {
            byte[] data = p.createByteArray();
            return data;
        }
    }

    public static class ActivityLaunchCancelled
    extends AppLaunchEvent {
        public final byte[] activityRecordSnapshot;

        public ActivityLaunchCancelled(long sequenceId, byte[] snapshot) {
            super(sequenceId);
            this.activityRecordSnapshot = snapshot;
        }

        @Override
        public boolean equals(Object other) {
            if (other instanceof ActivityLaunchCancelled) {
                return Objects.equals(this.activityRecordSnapshot, ((ActivityLaunchCancelled)other).activityRecordSnapshot) && super.equals(other);
            }
            return false;
        }

        @Override
        protected String toStringBody() {
            return ", " + this.activityRecordSnapshot.toString();
        }

        @Override
        protected void writeToParcelImpl(Parcel p, int flags) {
            super.writeToParcelImpl(p, flags);
            if (this.activityRecordSnapshot != null) {
                p.writeBoolean(true);
                ActivityRecordProtoParcelable.write(p, this.activityRecordSnapshot, flags);
            } else {
                p.writeBoolean(false);
            }
        }

        ActivityLaunchCancelled(Parcel p) {
            super(p);
            this.activityRecordSnapshot = (byte[])(p.readBoolean() ? ActivityRecordProtoParcelable.create(p) : null);
        }
    }

    public static final class ActivityLaunchFinished
    extends BaseWithActivityRecordData {
        public ActivityLaunchFinished(long sequenceId, byte[] snapshot) {
            super(sequenceId, snapshot);
        }

        @Override
        public boolean equals(Object other) {
            if (other instanceof ActivityLaunched) {
                return super.equals(other);
            }
            return false;
        }
    }

    public static final class ActivityLaunched
    extends BaseWithActivityRecordData {
        public final int temperature;

        public ActivityLaunched(long sequenceId, byte[] snapshot, int temperature) {
            super(sequenceId, snapshot);
            this.temperature = temperature;
        }

        @Override
        public boolean equals(Object other) {
            if (other instanceof ActivityLaunched) {
                return this.temperature == ((ActivityLaunched)other).temperature && super.equals(other);
            }
            return false;
        }

        @Override
        protected String toStringBody() {
            return ", temperature=" + Integer.toString(this.temperature);
        }

        @Override
        protected void writeToParcelImpl(Parcel p, int flags) {
            super.writeToParcelImpl(p, flags);
            p.writeInt(this.temperature);
        }

        ActivityLaunched(Parcel p) {
            super(p);
            this.temperature = p.readInt();
        }
    }

    public static abstract class BaseWithActivityRecordData
    extends AppLaunchEvent {
        public final byte[] activityRecordSnapshot;

        protected BaseWithActivityRecordData(long sequenceId, byte[] snapshot) {
            super(sequenceId);
            this.activityRecordSnapshot = snapshot;
            Objects.requireNonNull(snapshot, "snapshot");
        }

        @Override
        public boolean equals(Object other) {
            if (other instanceof BaseWithActivityRecordData) {
                return this.activityRecordSnapshot.equals(((BaseWithActivityRecordData)other).activityRecordSnapshot) && super.equals(other);
            }
            return false;
        }

        @Override
        protected String toStringBody() {
            return ", " + this.activityRecordSnapshot.toString();
        }

        @Override
        protected void writeToParcelImpl(Parcel p, int flags) {
            super.writeToParcelImpl(p, flags);
            ActivityRecordProtoParcelable.write(p, this.activityRecordSnapshot, flags);
        }

        BaseWithActivityRecordData(Parcel p) {
            super(p);
            this.activityRecordSnapshot = ActivityRecordProtoParcelable.create(p);
        }
    }

    public static final class IntentFailed
    extends AppLaunchEvent {
        public IntentFailed(long sequenceId) {
            super(sequenceId);
        }

        @Override
        public boolean equals(Object other) {
            if (other instanceof IntentFailed) {
                return super.equals(other);
            }
            return false;
        }

        IntentFailed(Parcel p) {
            super(p);
        }
    }

    public static final class IntentStarted
    extends AppLaunchEvent {
        public final Intent intent;

        public IntentStarted(long sequenceId, Intent intent) {
            super(sequenceId);
            this.intent = intent;
            Objects.requireNonNull(intent, "intent");
        }

        @Override
        public boolean equals(Object other) {
            if (other instanceof IntentStarted) {
                return this.intent.equals(((IntentStarted)other).intent) && super.equals(other);
            }
            return false;
        }

        @Override
        protected String toStringBody() {
            return ", intent=" + this.intent.toString();
        }

        @Override
        protected void writeToParcelImpl(Parcel p, int flags) {
            super.writeToParcelImpl(p, flags);
            IntentProtoParcelable.write(p, this.intent, flags);
        }

        IntentStarted(Parcel p) {
            super(p);
            this.intent = IntentProtoParcelable.create(p);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SequenceId {
    }
}

