/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.startop.iorap;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import com.android.server.IoThread;
import com.android.server.LocalServices;
import com.android.server.SystemService;
import com.android.server.wm.ActivityMetricsLaunchObserver;
import com.android.server.wm.ActivityMetricsLaunchObserverRegistry;
import com.android.server.wm.ActivityTaskManagerInternal;
import com.google.android.startop.iorap.AppLaunchEvent;
import com.google.android.startop.iorap.IIorap;
import com.google.android.startop.iorap.ITaskListener;
import com.google.android.startop.iorap.RequestId;
import com.google.android.startop.iorap.TaskResult;

public class IorapForwardingService
extends SystemService {
    public static final String TAG = "IorapForwardingService";
    public static final boolean DEBUG = Log.isLoggable("IorapForwardingService", 3);
    private static boolean IS_ENABLED = SystemProperties.getBoolean("ro.iorapd.enable", true);
    private static boolean WTF_CRASH = SystemProperties.getBoolean("iorapd.forwarding_service.wtf_crash", false);
    private IIorap mIorapRemote;
    private final Object mLock = new Object();
    private final Handler mHandler = new BinderConnectionHandler(IoThread.getHandler().getLooper());
    private final AppLaunchObserver mAppLaunchObserver = new AppLaunchObserver();
    private boolean mRegisteredListeners = false;

    public IorapForwardingService(Context context) {
        super(context);
    }

    @VisibleForTesting
    protected ActivityMetricsLaunchObserverRegistry provideLaunchObserverRegistry() {
        ActivityTaskManagerInternal amtInternal = LocalServices.getService(ActivityTaskManagerInternal.class);
        ActivityMetricsLaunchObserverRegistry launchObserverRegistry = amtInternal.getLaunchObserverRegistry();
        return launchObserverRegistry;
    }

    @VisibleForTesting
    protected IIorap provideIorapRemote() {
        IIorap iorap;
        try {
            iorap = IIorap.Stub.asInterface(ServiceManager.getServiceOrThrow("iorapd"));
        }
        catch (ServiceManager.ServiceNotFoundException e) {
            IorapForwardingService.handleRemoteError(e);
            return null;
        }
        try {
            iorap.asBinder().linkToDeath(this.provideDeathRecipient(), 0);
        }
        catch (RemoteException e) {
            IorapForwardingService.handleRemoteError(e);
            return null;
        }
        return iorap;
    }

    @VisibleForTesting
    protected IBinder.DeathRecipient provideDeathRecipient() {
        return new IBinder.DeathRecipient(){

            @Override
            public void binderDied() {
                Log.w(IorapForwardingService.TAG, "iorapd has died");
                IorapForwardingService.this.retryConnectToRemoteAndConfigure(0);
            }
        };
    }

    @VisibleForTesting
    protected boolean isIorapEnabled() {
        return IS_ENABLED;
    }

    @Override
    public void onStart() {
        if (DEBUG) {
            Log.v(TAG, "onStart");
        }
        this.retryConnectToRemoteAndConfigure(0);
    }

    private boolean retryConnectToRemoteAndConfigure(int attempts) {
        int sleepTime = 1000;
        if (DEBUG) {
            Log.v(TAG, "retryConnectToRemoteAndConfigure - attempt #" + attempts);
        }
        if (this.connectToRemoteAndConfigure()) {
            return true;
        }
        Log.w(TAG, "Failed to connect to iorapd, is it down? Delay for 1000");
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(0), 1000L);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean connectToRemoteAndConfigure() {
        Object object = this.mLock;
        synchronized (object) {
            return this.connectToRemoteAndConfigureLocked();
        }
    }

    private boolean connectToRemoteAndConfigureLocked() {
        if (!this.isIorapEnabled()) {
            if (DEBUG) {
                Log.v(TAG, "connectToRemoteAndConfigure - iorapd is disabled, skip rest of work");
            }
            return true;
        }
        this.mIorapRemote = this.provideIorapRemote();
        if (this.mIorapRemote == null) {
            Log.e(TAG, "connectToRemoteAndConfigure - null iorap remote. check for Log.wtf?");
            return false;
        }
        IorapForwardingService.invokeRemote(() -> this.mIorapRemote.setTaskListener(new RemoteTaskListener()));
        this.registerInProcessListenersLocked();
        return true;
    }

    private void registerInProcessListenersLocked() {
        if (this.mRegisteredListeners) {
            return;
        }
        ActivityMetricsLaunchObserverRegistry launchObserverRegistry = this.provideLaunchObserverRegistry();
        launchObserverRegistry.registerLaunchObserver(this.mAppLaunchObserver);
        this.mRegisteredListeners = true;
    }

    private static void invokeRemote(RemoteRunnable r) {
        try {
            r.run();
        }
        catch (RemoteException e) {
            IorapForwardingService.handleRemoteError(e);
        }
    }

    private static void handleRemoteError(Throwable t) {
        if (WTF_CRASH) {
            throw new AssertionError("unexpected remote error", t);
        }
        Log.wtf(TAG, t);
    }

    private static interface RemoteRunnable {
        public void run() throws RemoteException;
    }

    private class RemoteTaskListener
    extends ITaskListener.Stub {
        private RemoteTaskListener() {
        }

        @Override
        public void onProgress(RequestId requestId, TaskResult result) throws RemoteException {
            if (DEBUG) {
                Log.v(IorapForwardingService.TAG, String.format("RemoteTaskListener#onProgress(%s, %s)", requestId, result));
            }
        }

        @Override
        public void onComplete(RequestId requestId, TaskResult result) throws RemoteException {
            if (DEBUG) {
                Log.v(IorapForwardingService.TAG, String.format("RemoteTaskListener#onComplete(%s, %s)", requestId, result));
            }
        }
    }

    private class AppLaunchObserver
    implements ActivityMetricsLaunchObserver {
        private long mSequenceId = -1L;

        private AppLaunchObserver() {
        }

        @Override
        public void onIntentStarted(Intent intent) {
            ++this.mSequenceId;
            if (DEBUG) {
                Log.v(IorapForwardingService.TAG, String.format("AppLaunchObserver#onIntentStarted(%d, %s)", this.mSequenceId, intent));
            }
            IorapForwardingService.invokeRemote(() -> IorapForwardingService.this.mIorapRemote.onAppLaunchEvent(RequestId.nextValueForSequence(), new AppLaunchEvent.IntentStarted(this.mSequenceId, intent)));
        }

        @Override
        public void onIntentFailed() {
            if (DEBUG) {
                Log.v(IorapForwardingService.TAG, String.format("AppLaunchObserver#onIntentFailed(%d)", this.mSequenceId));
            }
            IorapForwardingService.invokeRemote(() -> IorapForwardingService.this.mIorapRemote.onAppLaunchEvent(RequestId.nextValueForSequence(), new AppLaunchEvent.IntentFailed(this.mSequenceId)));
        }

        @Override
        public void onActivityLaunched(byte[] activity, int temperature) {
            if (DEBUG) {
                Log.v(IorapForwardingService.TAG, String.format("AppLaunchObserver#onActivityLaunched(%d, %s, %d)", this.mSequenceId, activity, temperature));
            }
            IorapForwardingService.invokeRemote(() -> IorapForwardingService.this.mIorapRemote.onAppLaunchEvent(RequestId.nextValueForSequence(), new AppLaunchEvent.ActivityLaunched(this.mSequenceId, activity, temperature)));
        }

        @Override
        public void onActivityLaunchCancelled(byte[] activity) {
            if (DEBUG) {
                Log.v(IorapForwardingService.TAG, String.format("AppLaunchObserver#onActivityLaunchCancelled(%d, %s)", this.mSequenceId, activity));
            }
            IorapForwardingService.invokeRemote(() -> IorapForwardingService.this.mIorapRemote.onAppLaunchEvent(RequestId.nextValueForSequence(), new AppLaunchEvent.ActivityLaunchCancelled(this.mSequenceId, activity)));
        }

        @Override
        public void onActivityLaunchFinished(byte[] activity) {
            if (DEBUG) {
                Log.v(IorapForwardingService.TAG, String.format("AppLaunchObserver#onActivityLaunchFinished(%d, %s)", this.mSequenceId, activity));
            }
            IorapForwardingService.invokeRemote(() -> IorapForwardingService.this.mIorapRemote.onAppLaunchEvent(RequestId.nextValueForSequence(), new AppLaunchEvent.ActivityLaunchFinished(this.mSequenceId, activity)));
        }
    }

    private class BinderConnectionHandler
    extends Handler {
        public static final int MESSAGE_BINDER_CONNECT = 0;
        private int mAttempts;

        public BinderConnectionHandler(Looper looper) {
            super(looper);
            this.mAttempts = 0;
        }

        @Override
        public void handleMessage(Message message) {
            switch (message.what) {
                case 0: {
                    if (!IorapForwardingService.this.retryConnectToRemoteAndConfigure(this.mAttempts)) {
                        ++this.mAttempts;
                        break;
                    }
                    this.mAttempts = 0;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown message: " + message.toString()));
                }
            }
        }
    }
}

