/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.startop.iorap;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.startop.iorap.CheckHelpers;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public class PackageEvent
implements Parcelable {
    public static final int TYPE_REPLACED = 0;
    private static final int TYPE_MAX = 0;
    public final int type;
    public final Uri packageUri;
    public final String packageName;
    public static final Parcelable.Creator<PackageEvent> CREATOR = new Parcelable.Creator<PackageEvent>(){

        @Override
        public PackageEvent createFromParcel(Parcel in) {
            return new PackageEvent(in);
        }

        public PackageEvent[] newArray(int size) {
            return new PackageEvent[size];
        }
    };

    public static PackageEvent createReplaced(Uri packageUri, String packageName) {
        return new PackageEvent(0, packageUri, packageName);
    }

    private PackageEvent(int type, Uri packageUri, String packageName) {
        this.type = type;
        this.packageUri = packageUri;
        this.packageName = packageName;
        this.checkConstructorArguments();
    }

    private void checkConstructorArguments() {
        CheckHelpers.checkTypeInRange(this.type, 0);
        Objects.requireNonNull(this.packageUri, "packageUri");
        Objects.requireNonNull(this.packageName, "packageName");
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof PackageEvent) {
            return this.equals((PackageEvent)other);
        }
        return false;
    }

    private boolean equals(PackageEvent other) {
        return this.type == other.type && Objects.equals(this.packageUri, other.packageUri) && Objects.equals(this.packageName, other.packageName);
    }

    public String toString() {
        return String.format("{packageUri: %s, packageName: %s}", this.packageUri, this.packageName);
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.type);
        this.packageUri.writeToParcel(out, flags);
        out.writeString(this.packageName);
    }

    private PackageEvent(Parcel in) {
        this.type = in.readInt();
        this.packageUri = Uri.CREATOR.createFromParcel(in);
        this.packageName = in.readString();
        this.checkConstructorArguments();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Type {
    }
}

