/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.startop.iorap;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.startop.iorap.CheckHelpers;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class SystemServiceUserEvent
implements Parcelable {
    public static final int TYPE_START_USER = 0;
    public static final int TYPE_UNLOCK_USER = 1;
    public static final int TYPE_SWITCH_USER = 2;
    public static final int TYPE_STOP_USER = 3;
    public static final int TYPE_CLEANUP_USER = 4;
    private static final int TYPE_MAX = 4;
    public final int type;
    public final int userHandle;
    public static final Parcelable.Creator<SystemServiceUserEvent> CREATOR = new Parcelable.Creator<SystemServiceUserEvent>(){

        @Override
        public SystemServiceUserEvent createFromParcel(Parcel in) {
            return new SystemServiceUserEvent(in);
        }

        public SystemServiceUserEvent[] newArray(int size) {
            return new SystemServiceUserEvent[size];
        }
    };

    public SystemServiceUserEvent(int type, int userHandle) {
        this.type = type;
        this.userHandle = userHandle;
        this.checkConstructorArguments();
    }

    private void checkConstructorArguments() {
        CheckHelpers.checkTypeInRange(this.type, 4);
        if (this.userHandle < 0) {
            throw new IllegalArgumentException("userHandle must be non-negative");
        }
    }

    public String toString() {
        return String.format("{type: %d, userHandle: %d}", this.type, this.userHandle);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof SystemServiceUserEvent) {
            return this.equals((SystemServiceUserEvent)other);
        }
        return false;
    }

    private boolean equals(SystemServiceUserEvent other) {
        return this.type == other.type && this.userHandle == other.userHandle;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.type);
        out.writeInt(this.userHandle);
    }

    private SystemServiceUserEvent(Parcel in) {
        this.type = in.readInt();
        this.userHandle = in.readInt();
        this.checkConstructorArguments();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Type {
    }
}

