/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.startop.iorap;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.startop.iorap.CheckHelpers;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class TaskResult
implements Parcelable {
    public static final int STATE_BEGAN = 0;
    public static final int STATE_ONGOING = 1;
    public static final int STATE_COMPLETED = 2;
    public static final int STATE_ERROR = 3;
    private static final int STATE_MAX = 3;
    public final int state;
    public static final Parcelable.Creator<TaskResult> CREATOR = new Parcelable.Creator<TaskResult>(){

        @Override
        public TaskResult createFromParcel(Parcel in) {
            return new TaskResult(in);
        }

        public TaskResult[] newArray(int size) {
            return new TaskResult[size];
        }
    };

    public String toString() {
        return String.format("{state: %d}", this.state);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof TaskResult) {
            return this.equals((TaskResult)other);
        }
        return false;
    }

    private boolean equals(TaskResult other) {
        return this.state == other.state;
    }

    public TaskResult(int state) {
        this.state = state;
        this.checkConstructorArguments();
    }

    private void checkConstructorArguments() {
        CheckHelpers.checkStateInRange(this.state, 3);
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.state);
    }

    private TaskResult(Parcel in) {
        this.state = in.readInt();
        this.checkConstructorArguments();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface State {
    }
}

