/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.textclassifier;

import com.google.android.textclassifier.AnnotatorModel;
import com.google.android.textclassifier.NamedVariant;
import com.google.android.textclassifier.RemoteActionTemplate;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ActionsSuggestionsModel
implements AutoCloseable {
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private long actionsModelPtr;

    public ActionsSuggestionsModel(int fileDescriptor, byte[] serializedPreconditions) {
        this.actionsModelPtr = ActionsSuggestionsModel.nativeNewActionsModel(fileDescriptor, serializedPreconditions);
        if (this.actionsModelPtr == 0L) {
            throw new IllegalArgumentException("Couldn't initialize actions model from file descriptor.");
        }
    }

    public ActionsSuggestionsModel(int fileDescriptor) {
        this(fileDescriptor, null);
    }

    public ActionsSuggestionsModel(String path, byte[] serializedPreconditions) {
        this.actionsModelPtr = ActionsSuggestionsModel.nativeNewActionsModelFromPath(path, serializedPreconditions);
        if (this.actionsModelPtr == 0L) {
            throw new IllegalArgumentException("Couldn't initialize actions model from given file.");
        }
    }

    public ActionsSuggestionsModel(String path) {
        this(path, null);
    }

    public ActionSuggestion[] suggestActions(Conversation conversation, ActionSuggestionOptions options, AnnotatorModel annotator) {
        return this.nativeSuggestActions(this.actionsModelPtr, conversation, options, annotator != null ? annotator.getNativeAnnotator() : 0L, null, null, false);
    }

    public ActionSuggestion[] suggestActionsWithIntents(Conversation conversation, ActionSuggestionOptions options, Object appContext, String deviceLocales, AnnotatorModel annotator) {
        return this.nativeSuggestActions(this.actionsModelPtr, conversation, options, annotator != null ? annotator.getNativeAnnotator() : 0L, appContext, deviceLocales, true);
    }

    @Override
    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            this.nativeCloseActionsModel(this.actionsModelPtr);
            this.actionsModelPtr = 0L;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public static String getLocales(int fd) {
        return ActionsSuggestionsModel.nativeGetLocales(fd);
    }

    public static int getVersion(int fd) {
        return ActionsSuggestionsModel.nativeGetVersion(fd);
    }

    public static String getName(int fd) {
        return ActionsSuggestionsModel.nativeGetName(fd);
    }

    private static native long nativeNewActionsModel(int var0, byte[] var1);

    private static native long nativeNewActionsModelFromPath(String var0, byte[] var1);

    private static native String nativeGetLocales(int var0);

    private static native int nativeGetVersion(int var0);

    private static native String nativeGetName(int var0);

    private native ActionSuggestion[] nativeSuggestActions(long var1, Conversation var3, ActionSuggestionOptions var4, long var5, Object var7, String var8, boolean var9);

    private native void nativeCloseActionsModel(long var1);

    static {
        System.loadLibrary("textclassifier");
    }

    public static final class ActionSuggestionOptions {
    }

    public static final class Conversation {
        public final ConversationMessage[] conversationMessages;

        public Conversation(ConversationMessage[] conversationMessages) {
            this.conversationMessages = conversationMessages;
        }

        public ConversationMessage[] getConversationMessages() {
            return this.conversationMessages;
        }
    }

    public static final class ConversationMessage {
        private final int userId;
        private final String text;
        private final long referenceTimeMsUtc;
        private final String referenceTimezone;
        private final String detectedTextLanguageTags;

        public ConversationMessage(int userId, String text, long referenceTimeMsUtc, String referenceTimezone, String detectedTextLanguageTags) {
            this.userId = userId;
            this.text = text;
            this.referenceTimeMsUtc = referenceTimeMsUtc;
            this.referenceTimezone = referenceTimezone;
            this.detectedTextLanguageTags = detectedTextLanguageTags;
        }

        public int getUserId() {
            return this.userId;
        }

        public String getText() {
            return this.text;
        }

        public long getReferenceTimeMsUtc() {
            return this.referenceTimeMsUtc;
        }

        public String getReferenceTimezone() {
            return this.referenceTimezone;
        }

        public String getDetectedTextLanguageTags() {
            return this.detectedTextLanguageTags;
        }
    }

    public static final class ActionSuggestion {
        private final String responseText;
        private final String actionType;
        private final float score;
        private final NamedVariant[] entityData;
        private final byte[] serializedEntityData;
        private final RemoteActionTemplate[] remoteActionTemplates;

        public ActionSuggestion(String responseText, String actionType, float score, NamedVariant[] entityData, byte[] serializedEntityData, RemoteActionTemplate[] remoteActionTemplates) {
            this.responseText = responseText;
            this.actionType = actionType;
            this.score = score;
            this.entityData = entityData;
            this.serializedEntityData = serializedEntityData;
            this.remoteActionTemplates = remoteActionTemplates;
        }

        public String getResponseText() {
            return this.responseText;
        }

        public String getActionType() {
            return this.actionType;
        }

        public float getScore() {
            return this.score;
        }

        public NamedVariant[] getEntityData() {
            return this.entityData;
        }

        public byte[] getSerializedEntityData() {
            return this.serializedEntityData;
        }

        public RemoteActionTemplate[] getRemoteActionTemplates() {
            return this.remoteActionTemplates;
        }
    }
}

