/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.textclassifier;

import java.util.concurrent.atomic.AtomicBoolean;

public final class LangIdModel
implements AutoCloseable {
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private long modelPtr;

    public LangIdModel(int fd) {
        this.modelPtr = LangIdModel.nativeNew(fd);
        if (this.modelPtr == 0L) {
            throw new IllegalArgumentException("Couldn't initialize LangId from given file descriptor.");
        }
    }

    public LangIdModel(String modelPath) {
        this.modelPtr = LangIdModel.nativeNewFromPath(modelPath);
        if (this.modelPtr == 0L) {
            throw new IllegalArgumentException("Couldn't initialize LangId from given file.");
        }
    }

    public LanguageResult[] detectLanguages(String text) {
        return this.nativeDetectLanguages(this.modelPtr, text);
    }

    @Override
    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            this.nativeClose(this.modelPtr);
            this.modelPtr = 0L;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public int getVersion() {
        return this.nativeGetVersion(this.modelPtr);
    }

    public float getLangIdThreshold() {
        return this.nativeGetLangIdThreshold(this.modelPtr);
    }

    public static int getVersion(int fd) {
        return LangIdModel.nativeGetVersionFromFd(fd);
    }

    private static native long nativeNew(int var0);

    private static native long nativeNewFromPath(String var0);

    private native LanguageResult[] nativeDetectLanguages(long var1, String var3);

    private native void nativeClose(long var1);

    private native int nativeGetVersion(long var1);

    private static native int nativeGetVersionFromFd(int var0);

    private native float nativeGetLangIdThreshold(long var1);

    static {
        System.loadLibrary("textclassifier");
    }

    public static final class LanguageResult {
        final String mLanguage;
        final float mScore;

        LanguageResult(String language, float score) {
            this.mLanguage = language;
            this.mScore = score;
        }

        public final String getLanguage() {
            return this.mLanguage;
        }

        public final float getScore() {
            return this.mScore;
        }
    }
}

