/*
 * Decompiled with CFR 0.152.
 */
package dalvik.system;

import android.system.ErrnoException;
import dalvik.annotation.compat.UnsupportedAppUsage;
import dalvik.annotation.optimization.ReachabilitySensitive;
import dalvik.system.DexPathList;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import libcore.io.Libcore;

@Deprecated
public final class DexFile {
    @ReachabilitySensitive
    @UnsupportedAppUsage
    private Object mCookie;
    @UnsupportedAppUsage
    private Object mInternalCookie;
    @UnsupportedAppUsage
    private final String mFileName;
    public static final int NO_DEXOPT_NEEDED = 0;
    public static final int DEX2OAT_FROM_SCRATCH = 1;
    public static final int DEX2OAT_FOR_BOOT_IMAGE = 2;
    public static final int DEX2OAT_FOR_FILTER = 3;

    @Deprecated
    public DexFile(File file) throws IOException {
        this(file.getPath());
    }

    DexFile(File file, ClassLoader loader, DexPathList.Element[] elements) throws IOException {
        this(file.getPath(), loader, elements);
    }

    @Deprecated
    public DexFile(String fileName) throws IOException {
        this(fileName, null, null);
    }

    DexFile(String fileName, ClassLoader loader, DexPathList.Element[] elements) throws IOException {
        this.mInternalCookie = this.mCookie = DexFile.openDexFile(fileName, null, 0, loader, elements);
        this.mFileName = fileName;
    }

    DexFile(ByteBuffer[] bufs, ClassLoader loader, DexPathList.Element[] elements) throws IOException {
        this.mInternalCookie = this.mCookie = DexFile.openInMemoryDexFiles(bufs, loader, elements);
        this.mFileName = null;
    }

    private DexFile(String sourceName, String outputName, int flags, ClassLoader loader, DexPathList.Element[] elements) throws IOException {
        if (outputName != null) {
            try {
                String parent = new File(outputName).getParent();
                if (Libcore.os.getuid() != Libcore.os.stat((String)parent).st_uid) {
                    throw new IllegalArgumentException("Optimized data directory " + parent + " is not owned by the current user. Shared storage cannot protect your application from code injection attacks.");
                }
            }
            catch (ErrnoException errnoException) {
                // empty catch block
            }
        }
        this.mInternalCookie = this.mCookie = DexFile.openDexFile(sourceName, outputName, flags, loader, elements);
        this.mFileName = sourceName;
    }

    @Deprecated
    public static DexFile loadDex(String sourcePathName, String outputPathName, int flags) throws IOException {
        return DexFile.loadDex(sourcePathName, outputPathName, flags, null, null);
    }

    @UnsupportedAppUsage
    static DexFile loadDex(String sourcePathName, String outputPathName, int flags, ClassLoader loader, DexPathList.Element[] elements) throws IOException {
        return new DexFile(sourcePathName, outputPathName, flags, loader, elements);
    }

    public String getName() {
        return this.mFileName;
    }

    public String toString() {
        if (this.mFileName != null) {
            return this.getName();
        }
        return "InMemoryDexFile[cookie=" + Arrays.toString((long[])this.mCookie) + "]";
    }

    public void close() throws IOException {
        if (this.mInternalCookie != null) {
            if (DexFile.closeDexFile(this.mInternalCookie)) {
                this.mInternalCookie = null;
            }
            this.mCookie = null;
        }
    }

    public Class loadClass(String name, ClassLoader loader) {
        String slashName = name.replace('.', '/');
        return this.loadClassBinaryName(slashName, loader, null);
    }

    @UnsupportedAppUsage
    public Class loadClassBinaryName(String name, ClassLoader loader, List<Throwable> suppressed) {
        return DexFile.defineClass(name, loader, this.mCookie, this, suppressed);
    }

    private static Class defineClass(String name, ClassLoader loader, Object cookie, DexFile dexFile, List<Throwable> suppressed) {
        Class result;
        block4: {
            result = null;
            try {
                result = DexFile.defineClassNative(name, loader, cookie, dexFile);
            }
            catch (NoClassDefFoundError e) {
                if (suppressed != null) {
                    suppressed.add(e);
                }
            }
            catch (ClassNotFoundException e) {
                if (suppressed == null) break block4;
                suppressed.add(e);
            }
        }
        return result;
    }

    public Enumeration<String> entries() {
        return new DFEnum(this);
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mInternalCookie != null && !DexFile.closeDexFile(this.mInternalCookie)) {
                throw new AssertionError((Object)"Failed to close dex file in finalizer.");
            }
            this.mInternalCookie = null;
            this.mCookie = null;
        }
        finally {
            super.finalize();
        }
    }

    @UnsupportedAppUsage
    private static Object openDexFile(String sourceName, String outputName, int flags, ClassLoader loader, DexPathList.Element[] elements) throws IOException {
        return DexFile.openDexFileNative(new File(sourceName).getAbsolutePath(), outputName == null ? null : new File(outputName).getAbsolutePath(), flags, loader, elements);
    }

    private static Object openInMemoryDexFiles(ByteBuffer[] bufs, ClassLoader loader, DexPathList.Element[] elements) throws IOException {
        byte[][] arrays = new byte[bufs.length][];
        int[] starts = new int[bufs.length];
        int[] ends = new int[bufs.length];
        for (int i = 0; i < bufs.length; ++i) {
            arrays[i] = bufs[i].isDirect() ? null : bufs[i].array();
            starts[i] = bufs[i].position();
            ends[i] = bufs[i].limit();
        }
        return DexFile.openInMemoryDexFilesNative(bufs, arrays, starts, ends, loader, elements);
    }

    private static native Object openInMemoryDexFilesNative(ByteBuffer[] var0, byte[][] var1, int[] var2, int[] var3, ClassLoader var4, DexPathList.Element[] var5);

    void verifyInBackground(ClassLoader classLoader, String classLoaderContext) {
        DexFile.verifyInBackgroundNative(this.mCookie, classLoader, classLoaderContext);
    }

    private static native void verifyInBackgroundNative(Object var0, ClassLoader var1, String var2);

    static native String getClassLoaderContext(ClassLoader var0, DexPathList.Element[] var1);

    @UnsupportedAppUsage
    boolean isBackedByOatFile() {
        return DexFile.isBackedByOatFile(this.mCookie);
    }

    void setTrusted() {
        DexFile.setTrusted(this.mCookie);
    }

    private static native boolean closeDexFile(Object var0);

    private static native Class defineClassNative(String var0, ClassLoader var1, Object var2, DexFile var3) throws ClassNotFoundException, NoClassDefFoundError;

    @UnsupportedAppUsage
    private static native String[] getClassNameList(Object var0);

    private static native boolean isBackedByOatFile(Object var0);

    private static native void setTrusted(Object var0);

    @UnsupportedAppUsage
    private static native Object openDexFileNative(String var0, String var1, int var2, ClassLoader var3, DexPathList.Element[] var4);

    public static native boolean isDexOptNeeded(String var0) throws FileNotFoundException, IOException;

    public static int getDexOptNeeded(String fileName, String instructionSet, String compilerFilter, boolean newProfile, boolean downgrade) throws FileNotFoundException, IOException {
        return DexFile.getDexOptNeeded(fileName, instructionSet, compilerFilter, null, newProfile, downgrade);
    }

    public static native int getDexOptNeeded(String var0, String var1, String var2, String var3, boolean var4, boolean var5) throws FileNotFoundException, IOException;

    public static native String getDexFileStatus(String var0, String var1) throws FileNotFoundException;

    public static OptimizationInfo getDexFileOptimizationInfo(String fileName, String instructionSet) throws FileNotFoundException {
        String[] status = DexFile.getDexFileOptimizationStatus(fileName, instructionSet);
        return new OptimizationInfo(status[0], status[1]);
    }

    private static native String[] getDexFileOptimizationStatus(String var0, String var1) throws FileNotFoundException;

    public static native String[] getDexFileOutputPaths(String var0, String var1) throws FileNotFoundException;

    public static native boolean isValidCompilerFilter(String var0);

    public static native boolean isProfileGuidedCompilerFilter(String var0);

    public static native String getNonProfileGuidedCompilerFilter(String var0);

    public static native String getSafeModeCompilerFilter(String var0);

    public long getStaticSizeOfDexFile() {
        return DexFile.getStaticSizeOfDexFile(this.mCookie);
    }

    private static native long getStaticSizeOfDexFile(Object var0);

    public static final class OptimizationInfo {
        private final String status;
        private final String reason;

        private OptimizationInfo(String status, String reason) {
            this.status = status;
            this.reason = reason;
        }

        public String getStatus() {
            return this.status;
        }

        public String getReason() {
            return this.reason;
        }
    }

    private static class DFEnum
    implements Enumeration<String> {
        private int mIndex = 0;
        @UnsupportedAppUsage
        private String[] mNameList;

        DFEnum(DexFile df) {
            this.mNameList = DexFile.getClassNameList(df.mCookie);
        }

        @Override
        public boolean hasMoreElements() {
            return this.mIndex < this.mNameList.length;
        }

        @Override
        public String nextElement() {
            return this.mNameList[this.mIndex++];
        }
    }
}

