/*
 * Decompiled with CFR 0.152.
 */
package dalvik.system;

import dalvik.annotation.compat.UnsupportedAppUsage;
import dalvik.annotation.optimization.FastNative;
import java.lang.ref.FinalizerReference;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

public final class VMRuntime {
    private static final VMRuntime THE_ONE = new VMRuntime();
    private static final Map<String, String> ABI_TO_INSTRUCTION_SET_MAP = new HashMap<String, String>(16);
    static HiddenApiUsageLogger hiddenApiUsageLogger;
    public static final int SDK_VERSION_CUR_DEVELOPMENT = 10000;
    private static Consumer<String> nonSdkApiUsageConsumer;
    private int targetSdkVersion = 10000;
    private int notifyNativeInterval;
    private final AtomicInteger allocationCount = new AtomicInteger(0);

    public static void setHiddenApiUsageLogger(HiddenApiUsageLogger hiddenApiUsageLogger) {
        VMRuntime.hiddenApiUsageLogger = hiddenApiUsageLogger;
    }

    private static void hiddenApiUsed(int sampledValue, String appPackageName, String signature, int accessType, boolean accessDenied) {
        if (hiddenApiUsageLogger != null) {
            hiddenApiUsageLogger.hiddenApiUsed(sampledValue, appPackageName, signature, accessType, accessDenied);
        }
    }

    private VMRuntime() {
    }

    @UnsupportedAppUsage
    public static VMRuntime getRuntime() {
        return THE_ONE;
    }

    public native String[] properties();

    public native String bootClassPath();

    public native String classPath();

    public native String vmVersion();

    @UnsupportedAppUsage
    public native String vmLibrary();

    @UnsupportedAppUsage
    public native String vmInstructionSet();

    @UnsupportedAppUsage
    @FastNative
    public native boolean is64Bit();

    @FastNative
    public native boolean isCheckJniEnabled();

    public native float getTargetHeapUtilization();

    public native long getFinalizerTimeoutMs();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public float setTargetHeapUtilization(float newTarget) {
        if (newTarget <= 0.0f || newTarget >= 1.0f) {
            throw new IllegalArgumentException(newTarget + " out of range (0,1)");
        }
        if (newTarget < 0.1f) {
            newTarget = 0.1f;
        }
        VMRuntime vMRuntime = this;
        synchronized (vMRuntime) {
            float oldTarget = this.getTargetHeapUtilization();
            this.nativeSetTargetHeapUtilization(newTarget);
            return oldTarget;
        }
    }

    public synchronized void setTargetSdkVersion(int targetSdkVersion) {
        this.targetSdkVersion = targetSdkVersion;
        this.setTargetSdkVersionNative(this.targetSdkVersion);
    }

    public synchronized int getTargetSdkVersion() {
        return this.targetSdkVersion;
    }

    private native void setTargetSdkVersionNative(int var1);

    @Deprecated
    @UnsupportedAppUsage
    public long getMinimumHeapSize() {
        return 0L;
    }

    @Deprecated
    @UnsupportedAppUsage
    public long setMinimumHeapSize(long size) {
        return 0L;
    }

    @Deprecated
    @UnsupportedAppUsage
    public void gcSoftReferences() {
    }

    @Deprecated
    @UnsupportedAppUsage
    public void runFinalizationSync() {
        System.runFinalization();
    }

    private native void nativeSetTargetHeapUtilization(float var1);

    @Deprecated
    @UnsupportedAppUsage
    public boolean trackExternalAllocation(long size) {
        return true;
    }

    @Deprecated
    @UnsupportedAppUsage
    public void trackExternalFree(long size) {
    }

    @Deprecated
    @UnsupportedAppUsage
    public long getExternalBytesAllocated() {
        return 0L;
    }

    public native void startJitCompilation();

    public native void disableJitCompilation();

    public native void setHiddenApiExemptions(String[] var1);

    public native void setHiddenApiAccessLogSamplingRate(int var1);

    @UnsupportedAppUsage
    @FastNative
    public native Object newNonMovableArray(Class<?> var1, int var2);

    @FastNative
    public native Object newUnpaddedArray(Class<?> var1, int var2);

    @UnsupportedAppUsage
    @FastNative
    public native long addressOf(Object var1);

    @UnsupportedAppUsage
    public native void clearGrowthLimit();

    public native void clampGrowthLimit();

    @FastNative
    public native boolean isDebuggerActive();

    @FastNative
    public native boolean isNativeDebuggable();

    public native boolean isJavaDebuggable();

    @UnsupportedAppUsage
    public native void registerNativeAllocation(long var1);

    @Deprecated
    @UnsupportedAppUsage
    public void registerNativeAllocation(int bytes) {
        this.registerNativeAllocation((long)bytes);
    }

    @UnsupportedAppUsage
    public native void registerNativeFree(long var1);

    @Deprecated
    @UnsupportedAppUsage
    public void registerNativeFree(int bytes) {
        this.registerNativeFree((long)bytes);
    }

    private static native int getNotifyNativeInterval();

    public void notifyNativeAllocation() {
        int myNotifyNativeInterval = this.notifyNativeInterval;
        if (myNotifyNativeInterval == 0) {
            myNotifyNativeInterval = this.notifyNativeInterval = VMRuntime.getNotifyNativeInterval();
        }
        if (this.allocationCount.addAndGet(1) % myNotifyNativeInterval == 0) {
            this.notifyNativeAllocationsInternal();
        }
    }

    public native void notifyNativeAllocationsInternal();

    @UnsupportedAppUsage
    public static void runFinalization(long timeout) {
        try {
            FinalizerReference.finalizeAllEnqueued(timeout);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public native void requestConcurrentGC();

    public native void concurrentGC();

    public native void requestHeapTrim();

    public native void trimHeap();

    public native void startHeapTaskProcessor();

    public native void stopHeapTaskProcessor();

    public native void runHeapTasks();

    public native void updateProcessState(int var1);

    public native void notifyStartupCompleted();

    public native void preloadDexCaches();

    public static native void registerAppInfo(String var0, String[] var1);

    @UnsupportedAppUsage
    public static String getInstructionSet(String abi) {
        String instructionSet = ABI_TO_INSTRUCTION_SET_MAP.get(abi);
        if (instructionSet == null) {
            throw new IllegalArgumentException("Unsupported ABI: " + abi);
        }
        return instructionSet;
    }

    public static boolean is64BitInstructionSet(String instructionSet) {
        return "arm64".equals(instructionSet) || "x86_64".equals(instructionSet) || "mips64".equals(instructionSet);
    }

    @UnsupportedAppUsage
    public static boolean is64BitAbi(String abi) {
        return VMRuntime.is64BitInstructionSet(VMRuntime.getInstructionSet(abi));
    }

    public static native boolean isBootClassPathOnDisk(String var0);

    @FastNative
    public static native boolean hasBootImageSpaces();

    @UnsupportedAppUsage
    public static native String getCurrentInstructionSet();

    public static native boolean didPruneDalvikCache();

    public static native void registerSensitiveThread();

    public static native void setSystemDaemonThreadPriority();

    public static void setNonSdkApiUsageConsumer(Consumer<String> consumer) {
        nonSdkApiUsageConsumer = consumer;
    }

    public static native void setDedupeHiddenApiWarnings(boolean var0);

    public static native void setProcessPackageName(String var0);

    public static native void setProcessDataDirectory(String var0);

    static {
        ABI_TO_INSTRUCTION_SET_MAP.put("armeabi", "arm");
        ABI_TO_INSTRUCTION_SET_MAP.put("armeabi-v7a", "arm");
        ABI_TO_INSTRUCTION_SET_MAP.put("mips", "mips");
        ABI_TO_INSTRUCTION_SET_MAP.put("mips64", "mips64");
        ABI_TO_INSTRUCTION_SET_MAP.put("x86", "x86");
        ABI_TO_INSTRUCTION_SET_MAP.put("x86_64", "x86_64");
        ABI_TO_INSTRUCTION_SET_MAP.put("arm64-v8a", "arm64");
        nonSdkApiUsageConsumer = null;
    }

    public static interface HiddenApiUsageLogger {
        public static final int ACCESS_METHOD_NONE = 0;
        public static final int ACCESS_METHOD_REFLECTION = 1;
        public static final int ACCESS_METHOD_JNI = 2;
        public static final int ACCESS_METHOD_LINKING = 3;

        public void hiddenApiUsed(int var1, String var2, String var3, int var4, boolean var5);
    }
}

