/*
 * Decompiled with CFR 0.152.
 */
package dalvik.system;

import android.icu.impl.CacheValue;
import android.icu.text.DecimalFormatSymbols;
import android.icu.util.ULocale;
import dalvik.system.VMRuntime;
import java.io.File;

public final class ZygoteHooks {
    private static long token;

    private ZygoteHooks() {
    }

    public static native void startZygoteNoThreadCreation();

    public static void onBeginPreload() {
        ULocale[] localesToPin;
        CacheValue.setStrength(CacheValue.Strength.STRONG);
        for (ULocale uLocale : localesToPin = new ULocale[]{ULocale.ROOT, ULocale.US, ULocale.getDefault()}) {
            new DecimalFormatSymbols(uLocale);
        }
    }

    public static void onEndPreload() {
        CacheValue.setStrength(CacheValue.Strength.SOFT);
    }

    public static void gcAndFinalize() {
        VMRuntime runtime = VMRuntime.getRuntime();
        System.gc();
        runtime.runFinalizationSync();
        System.gc();
    }

    public static native void stopZygoteNoThreadCreation();

    public static void preFork() {
        Daemons.stop();
        token = ZygoteHooks.nativePreFork();
        ZygoteHooks.waitUntilAllThreadsStopped();
    }

    public static void postForkSystemServer() {
        ZygoteHooks.nativePostForkSystemServer();
    }

    public static void postForkChild(int runtimeFlags, boolean isSystemServer, boolean isZygote, String instructionSet) {
        ZygoteHooks.nativePostForkChild(token, runtimeFlags, isSystemServer, isZygote, instructionSet);
        Math.setRandomSeedInternal((long)System.currentTimeMillis());
    }

    public static void postForkCommon() {
        Daemons.startPostZygoteFork();
        ZygoteHooks.nativePostZygoteFork();
    }

    private static native void nativePostForkSystemServer();

    private static native long nativePreFork();

    private static native void nativePostZygoteFork();

    private static native void nativePostForkChild(long var0, int var2, boolean var3, boolean var4, String var5);

    private static void waitUntilAllThreadsStopped() {
        File tasks = new File("/proc/self/task");
        while (tasks.list().length > 1) {
            Thread.yield();
        }
    }
}

