/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.core;

import gov.nist.core.Debug;
import gov.nist.core.GenericObjectList;
import gov.nist.core.InternalErrorHandler;
import gov.nist.core.Match;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public abstract class GenericObject
implements Serializable,
Cloneable {
    protected static final String SEMICOLON = ";";
    protected static final String COLON = ":";
    protected static final String COMMA = ",";
    protected static final String SLASH = "/";
    protected static final String SP = " ";
    protected static final String EQUALS = "=";
    protected static final String STAR = "*";
    protected static final String NEWLINE = "\r\n";
    protected static final String RETURN = "\n";
    protected static final String LESS_THAN = "<";
    protected static final String GREATER_THAN = ">";
    protected static final String AT = "@";
    protected static final String DOT = ".";
    protected static final String QUESTION = "?";
    protected static final String POUND = "#";
    protected static final String AND = "&";
    protected static final String LPAREN = "(";
    protected static final String RPAREN = ")";
    protected static final String DOUBLE_QUOTE = "\"";
    protected static final String QUOTE = "'";
    protected static final String HT = "\t";
    protected static final String PERCENT = "%";
    protected static final Set<Class<?>> immutableClasses = new HashSet(10);
    static final String[] immutableClassNames = new String[]{"String", "Character", "Boolean", "Byte", "Short", "Integer", "Long", "Float", "Double"};
    protected int indentation = 0;
    protected String stringRepresentation = "";
    protected Match matchExpression;

    public void setMatcher(Match matchExpression) {
        if (matchExpression == null) {
            throw new IllegalArgumentException("null arg!");
        }
        this.matchExpression = matchExpression;
    }

    public Match getMatcher() {
        return this.matchExpression;
    }

    public static Class<?> getClassFromName(String className) {
        try {
            return Class.forName(className);
        }
        catch (Exception ex) {
            InternalErrorHandler.handleException(ex);
            return null;
        }
    }

    public static boolean isMySubclass(Class<?> other) {
        return GenericObject.class.isAssignableFrom(other);
    }

    public static Object makeClone(Object obj) {
        if (obj == null) {
            throw new NullPointerException("null obj!");
        }
        Class<?> c = obj.getClass();
        Object clone_obj = obj;
        if (immutableClasses.contains(c)) {
            return obj;
        }
        if (c.isArray()) {
            Class<?> ec = c.getComponentType();
            if (!ec.isPrimitive()) {
                clone_obj = ((Object[])obj).clone();
            } else {
                if (ec == Character.TYPE) {
                    clone_obj = ((char[])obj).clone();
                } else if (ec == Boolean.TYPE) {
                    clone_obj = ((boolean[])obj).clone();
                }
                if (ec == Byte.TYPE) {
                    clone_obj = ((byte[])obj).clone();
                } else if (ec == Short.TYPE) {
                    clone_obj = ((short[])obj).clone();
                } else if (ec == Integer.TYPE) {
                    clone_obj = ((int[])obj).clone();
                } else if (ec == Long.TYPE) {
                    clone_obj = ((long[])obj).clone();
                } else if (ec == Float.TYPE) {
                    clone_obj = ((float[])obj).clone();
                } else if (ec == Double.TYPE) {
                    clone_obj = ((double[])obj).clone();
                }
            }
        } else if (GenericObject.class.isAssignableFrom(c)) {
            clone_obj = ((GenericObject)obj).clone();
        } else if (GenericObjectList.class.isAssignableFrom(c)) {
            clone_obj = ((GenericObjectList)obj).clone();
        } else if (Cloneable.class.isAssignableFrom(c)) {
            try {
                Method meth = c.getMethod("clone", null);
                clone_obj = meth.invoke(obj, (Object[])null);
            }
            catch (SecurityException meth) {
            }
            catch (IllegalArgumentException ex) {
                InternalErrorHandler.handleException(ex);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return clone_obj;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Internal error");
        }
    }

    public void merge(Object mergeObject) {
        if (mergeObject == null) {
            return;
        }
        if (!mergeObject.getClass().equals(this.getClass())) {
            throw new IllegalArgumentException("Bad override object");
        }
        Class<?> myclass = this.getClass();
        do {
            Field[] fields = myclass.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field f = fields[i];
                int modifier = f.getModifiers();
                if (Modifier.isPrivate(modifier) || Modifier.isStatic(modifier) || Modifier.isInterface(modifier)) continue;
                Class<?> fieldType = f.getType();
                String fname = fieldType.toString();
                try {
                    if (fieldType.isPrimitive()) {
                        if (fname.compareTo("int") == 0) {
                            int intfield = f.getInt(mergeObject);
                            f.setInt(this, intfield);
                            continue;
                        }
                        if (fname.compareTo("short") == 0) {
                            short shortField = f.getShort(mergeObject);
                            f.setShort(this, shortField);
                            continue;
                        }
                        if (fname.compareTo("char") == 0) {
                            char charField = f.getChar(mergeObject);
                            f.setChar(this, charField);
                            continue;
                        }
                        if (fname.compareTo("long") == 0) {
                            long longField = f.getLong(mergeObject);
                            f.setLong(this, longField);
                            continue;
                        }
                        if (fname.compareTo("boolean") == 0) {
                            boolean booleanField = f.getBoolean(mergeObject);
                            f.setBoolean(this, booleanField);
                            continue;
                        }
                        if (fname.compareTo("double") == 0) {
                            double doubleField = f.getDouble(mergeObject);
                            f.setDouble(this, doubleField);
                            continue;
                        }
                        if (fname.compareTo("float") != 0) continue;
                        float floatField = f.getFloat(mergeObject);
                        f.setFloat(this, floatField);
                        continue;
                    }
                    Object obj = f.get(this);
                    Object mobj = f.get(mergeObject);
                    if (mobj == null) continue;
                    if (obj == null) {
                        f.set(this, mobj);
                        continue;
                    }
                    if (obj instanceof GenericObject) {
                        GenericObject gobj = (GenericObject)obj;
                        gobj.merge(mobj);
                        continue;
                    }
                    f.set(this, mobj);
                    continue;
                }
                catch (IllegalAccessException ex1) {
                    ex1.printStackTrace();
                }
            }
        } while (!(myclass = myclass.getSuperclass()).equals(GenericObject.class));
    }

    protected GenericObject() {
    }

    protected String getIndentation() {
        char[] chars = new char[this.indentation];
        Arrays.fill(chars, ' ');
        return new String(chars);
    }

    protected void sprint(String a) {
        if (a == null) {
            this.stringRepresentation = this.stringRepresentation + this.getIndentation();
            this.stringRepresentation = this.stringRepresentation + "<null>\n";
            return;
        }
        if (a.compareTo("}") == 0 || a.compareTo("]") == 0) {
            --this.indentation;
        }
        this.stringRepresentation = this.stringRepresentation + this.getIndentation();
        this.stringRepresentation = this.stringRepresentation + a;
        this.stringRepresentation = this.stringRepresentation + RETURN;
        if (a.compareTo("{") == 0 || a.compareTo("[") == 0) {
            ++this.indentation;
        }
    }

    protected void sprint(Object o) {
        this.sprint(o.toString());
    }

    protected void sprint(int intField) {
        this.sprint(String.valueOf(intField));
    }

    protected void sprint(short shortField) {
        this.sprint(String.valueOf(shortField));
    }

    protected void sprint(char charField) {
        this.sprint(String.valueOf(charField));
    }

    protected void sprint(long longField) {
        this.sprint(String.valueOf(longField));
    }

    protected void sprint(boolean booleanField) {
        this.sprint(String.valueOf(booleanField));
    }

    protected void sprint(double doubleField) {
        this.sprint(String.valueOf(doubleField));
    }

    protected void sprint(float floatField) {
        this.sprint(String.valueOf(floatField));
    }

    protected void dbgPrint() {
        Debug.println(this.debugDump());
    }

    protected void dbgPrint(String s) {
        Debug.println(s);
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (!this.getClass().equals(that.getClass())) {
            return false;
        }
        Class<?> myclass = this.getClass();
        Class<?> hisclass = that.getClass();
        while (true) {
            Field[] fields = myclass.getDeclaredFields();
            Field[] hisfields = hisclass.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field f = fields[i];
                Field g = hisfields[i];
                int modifier = f.getModifiers();
                if ((modifier & 2) == 2) continue;
                Class<?> fieldType = f.getType();
                String fieldName = f.getName();
                if (fieldName.compareTo("stringRepresentation") == 0 || fieldName.compareTo("indentation") == 0) continue;
                try {
                    if (fieldType.isPrimitive()) {
                        String fname = fieldType.toString();
                        if (!(fname.compareTo("int") == 0 ? f.getInt(this) != g.getInt(that) : (fname.compareTo("short") == 0 ? f.getShort(this) != g.getShort(that) : (fname.compareTo("char") == 0 ? f.getChar(this) != g.getChar(that) : (fname.compareTo("long") == 0 ? f.getLong(this) != g.getLong(that) : (fname.compareTo("boolean") == 0 ? f.getBoolean(this) != g.getBoolean(that) : (fname.compareTo("double") == 0 ? f.getDouble(this) != g.getDouble(that) : fname.compareTo("float") == 0 && f.getFloat(this) != g.getFloat(that)))))))) continue;
                        return false;
                    }
                    if (g.get(that) == f.get(this)) {
                        return true;
                    }
                    if (f.get(this) == null) {
                        return false;
                    }
                    if (g.get(that) == null) {
                        return false;
                    }
                    if (g.get(that) == null && f.get(this) != null) {
                        return false;
                    }
                    if (f.get(this).equals(g.get(that))) continue;
                    return false;
                }
                catch (IllegalAccessException ex1) {
                    InternalErrorHandler.handleException(ex1);
                }
            }
            if (myclass.equals(GenericObject.class)) break;
            myclass = myclass.getSuperclass();
            hisclass = hisclass.getSuperclass();
        }
        return true;
    }

    public boolean match(Object other) {
        if (other == null) {
            return true;
        }
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        GenericObject that = (GenericObject)other;
        Class<?> myclass = this.getClass();
        Field[] fields = myclass.getDeclaredFields();
        Class<?> hisclass = other.getClass();
        Field[] hisfields = hisclass.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            Field g = hisfields[i];
            int modifier = f.getModifiers();
            if ((modifier & 2) == 2) continue;
            Class<?> fieldType = f.getType();
            String fieldName = f.getName();
            if (fieldName.compareTo("stringRepresentation") == 0 || fieldName.compareTo("indentation") == 0) continue;
            try {
                if (fieldType.isPrimitive()) {
                    String fname = fieldType.toString();
                    if (!(fname.compareTo("int") == 0 ? f.getInt(this) != g.getInt(that) : (fname.compareTo("short") == 0 ? f.getShort(this) != g.getShort(that) : (fname.compareTo("char") == 0 ? f.getChar(this) != g.getChar(that) : (fname.compareTo("long") == 0 ? f.getLong(this) != g.getLong(that) : (fname.compareTo("boolean") == 0 ? f.getBoolean(this) != g.getBoolean(that) : (fname.compareTo("double") == 0 ? f.getDouble(this) != g.getDouble(that) : fname.compareTo("float") == 0 && f.getFloat(this) != g.getFloat(that)))))))) continue;
                    return false;
                }
                Object myObj = f.get(this);
                Object hisObj = g.get(that);
                if (hisObj != null && myObj == null) {
                    return false;
                }
                if (hisObj == null && myObj != null || hisObj == null && myObj == null) continue;
                if (hisObj instanceof String && myObj instanceof String) {
                    if (((String)hisObj).trim().equals("") || ((String)myObj).compareToIgnoreCase((String)hisObj) == 0) continue;
                    return false;
                }
                if (GenericObject.isMySubclass(myObj.getClass()) && !((GenericObject)myObj).match(hisObj)) {
                    return false;
                }
                if (!GenericObjectList.isMySubclass(myObj.getClass()) || ((GenericObjectList)myObj).match(hisObj)) continue;
                return false;
            }
            catch (IllegalAccessException ex1) {
                InternalErrorHandler.handleException(ex1);
            }
        }
        return true;
    }

    public String debugDump() {
        this.stringRepresentation = "";
        Class<?> myclass = this.getClass();
        this.sprint(myclass.getName());
        this.sprint("{");
        Field[] fields = myclass.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            int modifier = f.getModifiers();
            if ((modifier & 2) == 2) continue;
            Class<?> fieldType = f.getType();
            String fieldName = f.getName();
            if (fieldName.compareTo("stringRepresentation") == 0 || fieldName.compareTo("indentation") == 0) continue;
            this.sprint(fieldName + COLON);
            try {
                if (fieldType.isPrimitive()) {
                    String fname = fieldType.toString();
                    this.sprint(fname + COLON);
                    if (fname.compareTo("int") == 0) {
                        int intfield = f.getInt(this);
                        this.sprint(intfield);
                        continue;
                    }
                    if (fname.compareTo("short") == 0) {
                        short shortField = f.getShort(this);
                        this.sprint(shortField);
                        continue;
                    }
                    if (fname.compareTo("char") == 0) {
                        char charField = f.getChar(this);
                        this.sprint(charField);
                        continue;
                    }
                    if (fname.compareTo("long") == 0) {
                        long longField = f.getLong(this);
                        this.sprint(longField);
                        continue;
                    }
                    if (fname.compareTo("boolean") == 0) {
                        boolean booleanField = f.getBoolean(this);
                        this.sprint(booleanField);
                        continue;
                    }
                    if (fname.compareTo("double") == 0) {
                        double doubleField = f.getDouble(this);
                        this.sprint(doubleField);
                        continue;
                    }
                    if (fname.compareTo("float") != 0) continue;
                    float floatField = f.getFloat(this);
                    this.sprint(floatField);
                    continue;
                }
                if (GenericObject.class.isAssignableFrom(fieldType)) {
                    if (f.get(this) != null) {
                        this.sprint(((GenericObject)f.get(this)).debugDump(this.indentation + 1));
                        continue;
                    }
                    this.sprint("<null>");
                    continue;
                }
                if (GenericObjectList.class.isAssignableFrom(fieldType)) {
                    if (f.get(this) != null) {
                        this.sprint(((GenericObjectList)f.get(this)).debugDump(this.indentation + 1));
                        continue;
                    }
                    this.sprint("<null>");
                    continue;
                }
                if (f.get(this) != null) {
                    this.sprint(f.get(this).getClass().getName() + COLON);
                } else {
                    this.sprint(fieldType.getName() + COLON);
                }
                this.sprint("{");
                if (f.get(this) != null) {
                    this.sprint(f.get(this).toString());
                } else {
                    this.sprint("<null>");
                }
                this.sprint("}");
                continue;
            }
            catch (IllegalAccessException ex1) {
                continue;
            }
            catch (Exception ex) {
                InternalErrorHandler.handleException(ex);
            }
        }
        this.sprint("}");
        return this.stringRepresentation;
    }

    public String debugDump(int indent) {
        this.indentation = indent;
        String retval = this.debugDump();
        this.indentation = 0;
        return retval;
    }

    public abstract String encode();

    public StringBuffer encode(StringBuffer buffer) {
        return buffer.append(this.encode());
    }

    static {
        try {
            for (int i = 0; i < immutableClassNames.length; ++i) {
                immutableClasses.add(Class.forName("java.lang." + immutableClassNames[i]));
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Internal error", e);
        }
    }
}

