/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.header;

import gov.nist.javax.sip.header.ParametersHeader;
import java.text.ParseException;
import javax.sip.InvalidArgumentException;
import javax.sip.header.AcceptEncodingHeader;

public final class AcceptEncoding
extends ParametersHeader
implements AcceptEncodingHeader {
    private static final long serialVersionUID = -1476807565552873525L;
    protected String contentCoding;

    public AcceptEncoding() {
        super("Accept-Encoding");
    }

    @Override
    protected String encodeBody() {
        return this.encode(new StringBuffer()).toString();
    }

    @Override
    protected StringBuffer encodeBody(StringBuffer buffer) {
        if (this.contentCoding != null) {
            buffer.append(this.contentCoding);
        }
        if (this.parameters != null && !this.parameters.isEmpty()) {
            buffer.append(";").append(this.parameters.encode());
        }
        return buffer;
    }

    @Override
    public float getQValue() {
        return this.getParameterAsFloat("q");
    }

    @Override
    public String getEncoding() {
        return this.contentCoding;
    }

    @Override
    public void setQValue(float q) throws InvalidArgumentException {
        if ((double)q < 0.0 || (double)q > 1.0) {
            throw new InvalidArgumentException("qvalue out of range!");
        }
        super.setParameter("q", q);
    }

    @Override
    public void setEncoding(String encoding) throws ParseException {
        if (encoding == null) {
            throw new NullPointerException(" encoding parameter is null");
        }
        this.contentCoding = encoding;
    }
}

