/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import dalvik.annotation.optimization.FastNative;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import libcore.util.CharsetUtils;
import libcore.util.EmptyArray;

public final class StringFactory {
    private static final char REPLACEMENT_CHAR = '\ufffd';
    private static final int[] TABLE_UTF8_NEEDED = new int[]{0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    public static String newEmptyString() {
        return StringFactory.newStringFromChars(EmptyArray.CHAR, 0, 0);
    }

    public static String newStringFromBytes(byte[] data) {
        return StringFactory.newStringFromBytes(data, 0, data.length);
    }

    public static String newStringFromBytes(byte[] data, int high) {
        return StringFactory.newStringFromBytes(data, high, 0, data.length);
    }

    public static String newStringFromBytes(byte[] data, int offset, int byteCount) {
        return StringFactory.newStringFromBytes(data, offset, byteCount, Charset.defaultCharset());
    }

    @FastNative
    public static native String newStringFromBytes(byte[] var0, int var1, int var2, int var3);

    public static String newStringFromBytes(byte[] data, int offset, int byteCount, String charsetName) throws UnsupportedEncodingException {
        return StringFactory.newStringFromBytes(data, offset, byteCount, Charset.forNameUEE((String)charsetName));
    }

    public static String newStringFromBytes(byte[] data, String charsetName) throws UnsupportedEncodingException {
        return StringFactory.newStringFromBytes(data, 0, data.length, Charset.forNameUEE((String)charsetName));
    }

    public static String newStringFromBytes(byte[] data, int offset, int byteCount, Charset charset) {
        int length;
        char[] value;
        if ((offset | byteCount) < 0 || byteCount > data.length - offset) {
            throw new StringIndexOutOfBoundsException(data.length, offset, byteCount);
        }
        String canonicalCharsetName = charset.name();
        if (canonicalCharsetName.equals("UTF-8")) {
            byte[] d = data;
            char[] v = new char[byteCount];
            int idx = offset;
            int last = offset + byteCount;
            int s = 0;
            int codePoint = 0;
            int utf8BytesSeen = 0;
            int utf8BytesNeeded = 0;
            int lowerBound = 128;
            int upperBound = 191;
            while (idx < last) {
                int b = d[idx++] & 0xFF;
                if (utf8BytesNeeded == 0) {
                    if ((b & 0x80) == 0) {
                        v[s++] = (char)b;
                        continue;
                    }
                    if ((b & 0x40) == 0) {
                        v[s++] = 65533;
                        continue;
                    }
                    int tableLookupIndex = b & 0x3F;
                    utf8BytesNeeded = TABLE_UTF8_NEEDED[tableLookupIndex];
                    if (utf8BytesNeeded == 0) {
                        v[s++] = 65533;
                        continue;
                    }
                    codePoint = b & 63 >> utf8BytesNeeded;
                    if (b == 224) {
                        lowerBound = 160;
                        continue;
                    }
                    if (b == 237) {
                        upperBound = 159;
                        continue;
                    }
                    if (b == 240) {
                        lowerBound = 144;
                        continue;
                    }
                    if (b != 244) continue;
                    upperBound = 143;
                    continue;
                }
                if (b < lowerBound || b > upperBound) {
                    v[s++] = 65533;
                    codePoint = 0;
                    utf8BytesNeeded = 0;
                    utf8BytesSeen = 0;
                    lowerBound = 128;
                    upperBound = 191;
                    --idx;
                    continue;
                }
                lowerBound = 128;
                upperBound = 191;
                codePoint = codePoint << 6 | b & 0x3F;
                if (utf8BytesNeeded != ++utf8BytesSeen) continue;
                if (codePoint < 65536) {
                    v[s++] = (char)codePoint;
                } else {
                    v[s++] = (char)((codePoint >> 10) + 55232);
                    v[s++] = (char)((codePoint & 0x3FF) + 56320);
                }
                utf8BytesSeen = 0;
                utf8BytesNeeded = 0;
                codePoint = 0;
            }
            if (utf8BytesNeeded != 0) {
                v[s++] = 65533;
            }
            if (s == byteCount) {
                value = v;
                length = s;
            } else {
                value = new char[s];
                length = s;
                System.arraycopy(v, 0, value, 0, s);
            }
        } else if (canonicalCharsetName.equals("ISO-8859-1")) {
            value = new char[byteCount];
            length = byteCount;
            CharsetUtils.isoLatin1BytesToChars(data, offset, byteCount, value);
        } else if (canonicalCharsetName.equals("US-ASCII")) {
            value = new char[byteCount];
            length = byteCount;
            CharsetUtils.asciiBytesToChars(data, offset, byteCount, value);
        } else {
            CharBuffer cb = charset.decode(ByteBuffer.wrap(data, offset, byteCount));
            length = cb.length();
            value = cb.array();
        }
        return StringFactory.newStringFromChars(value, 0, length);
    }

    public static String newStringFromBytes(byte[] data, Charset charset) {
        return StringFactory.newStringFromBytes(data, 0, data.length, charset);
    }

    public static String newStringFromChars(char[] data) {
        return StringFactory.newStringFromChars(data, 0, data.length);
    }

    public static String newStringFromChars(char[] data, int offset, int charCount) {
        if ((offset | charCount) < 0 || charCount > data.length - offset) {
            throw new StringIndexOutOfBoundsException(data.length, offset, charCount);
        }
        return StringFactory.newStringFromChars(offset, charCount, data);
    }

    @FastNative
    static native String newStringFromChars(int var0, int var1, char[] var2);

    @FastNative
    public static native String newStringFromString(String var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String newStringFromStringBuffer(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            return StringFactory.newStringFromChars(stringBuffer.getValue(), 0, stringBuffer.length());
        }
    }

    public static String newStringFromCodePoints(int[] codePoints, int offset, int count) {
        if (codePoints == null) {
            throw new NullPointerException("codePoints == null");
        }
        if ((offset | count) < 0 || count > codePoints.length - offset) {
            throw new StringIndexOutOfBoundsException(codePoints.length, offset, count);
        }
        char[] value = new char[count * 2];
        int end = offset + count;
        int length = 0;
        for (int i = offset; i < end; ++i) {
            length += Character.toChars(codePoints[i], value, length);
        }
        return StringFactory.newStringFromChars(value, 0, length);
    }

    public static String newStringFromStringBuilder(StringBuilder stringBuilder) {
        return StringFactory.newStringFromChars(stringBuilder.getValue(), 0, stringBuilder.length());
    }
}

