/*
 * Decompiled with CFR 0.152.
 */
package java.lang.ref;

import dalvik.annotation.compat.UnsupportedAppUsage;
import dalvik.annotation.optimization.FastNative;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;

public final class FinalizerReference<T>
extends Reference<T> {
    @UnsupportedAppUsage
    public static final ReferenceQueue<Object> queue = new ReferenceQueue();
    private static final Object LIST_LOCK = new Object();
    @UnsupportedAppUsage
    private static FinalizerReference<?> head = null;
    private FinalizerReference<?> prev;
    @UnsupportedAppUsage
    private FinalizerReference<?> next;
    private T zombie;

    public FinalizerReference(T r, ReferenceQueue<? super T> q) {
        super(r, q);
    }

    @Override
    public T get() {
        return this.zombie;
    }

    @Override
    public void clear() {
        this.zombie = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public static void add(Object referent) {
        FinalizerReference<Object> reference = new FinalizerReference<Object>(referent, queue);
        Object object = LIST_LOCK;
        synchronized (object) {
            reference.prev = null;
            reference.next = head;
            if (head != null) {
                FinalizerReference.head.prev = reference;
            }
            head = reference;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public static void remove(FinalizerReference<?> reference) {
        Object object = LIST_LOCK;
        synchronized (object) {
            FinalizerReference<?> next = reference.next;
            FinalizerReference<?> prev = reference.prev;
            reference.next = null;
            reference.prev = null;
            if (prev != null) {
                prev.next = next;
            } else {
                head = next;
            }
            if (next != null) {
                next.prev = prev;
            }
        }
    }

    public static void finalizeAllEnqueued(long timeout) throws InterruptedException {
        Sentinel sentinel;
        while (!FinalizerReference.enqueueSentinelReference(sentinel = new Sentinel())) {
        }
        sentinel.awaitFinalization(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean enqueueSentinelReference(Sentinel sentinel) {
        Object object = LIST_LOCK;
        synchronized (object) {
            FinalizerReference<?> r = head;
            while (r != null) {
                if (super.getReferent() == sentinel) {
                    FinalizerReference<?> sentinelReference = r;
                    sentinelReference.clearReferent();
                    sentinelReference.zombie = sentinel;
                    if (!super.makeCircularListIfUnenqueued()) {
                        return false;
                    }
                    ReferenceQueue.add(sentinelReference);
                    return true;
                }
                r = r.next;
            }
        }
        throw new AssertionError((Object)"newly-created live Sentinel not on list!");
    }

    @FastNative
    private final native T getReferent();

    @FastNative
    private native boolean makeCircularListIfUnenqueued();

    private static class Sentinel {
        boolean finalized = false;

        private Sentinel() {
        }

        protected synchronized void finalize() throws Throwable {
            if (this.finalized) {
                throw new AssertionError();
            }
            this.finalized = true;
            this.notifyAll();
        }

        synchronized void awaitFinalization(long timeout) throws InterruptedException {
            long startTime = System.nanoTime();
            long endTime = startTime + timeout;
            while (!this.finalized) {
                if (timeout != 0L) {
                    long currentTime = System.nanoTime();
                    if (currentTime >= endTime) break;
                    long deltaTime = endTime - currentTime;
                    this.wait(deltaTime / 1000000L, (int)(deltaTime % 1000000L));
                    continue;
                }
                this.wait();
            }
        }
    }
}

