/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInt;
import java.math.BitLevel;
import java.math.Conversion;
import java.math.Logical;
import java.math.Primality;
import java.util.Random;

public class BigInteger
extends Number
implements Comparable<BigInteger>,
Serializable {
    private static final long serialVersionUID = -8287574255936472291L;
    private transient BigInt bigInt;
    private transient boolean nativeIsValid = false;
    private transient boolean javaIsValid = false;
    transient int[] digits;
    transient int numberLength;
    transient int sign;
    public static final BigInteger ZERO = new BigInteger(0, 0L);
    public static final BigInteger ONE = new BigInteger(1, 1L);
    public static final BigInteger TEN = new BigInteger(1, 10L);
    static final BigInteger MINUS_ONE = new BigInteger(-1, 1L);
    static final BigInteger[] SMALL_VALUES = new BigInteger[]{ZERO, ONE, new BigInteger(1, 2L), new BigInteger(1, 3L), new BigInteger(1, 4L), new BigInteger(1, 5L), new BigInteger(1, 6L), new BigInteger(1, 7L), new BigInteger(1, 8L), new BigInteger(1, 9L), TEN};
    private transient int firstNonzeroDigit = -2;
    private int signum;
    private byte[] magnitude;
    private transient int hashCode = 0;

    BigInteger(BigInt bigInt) {
        if (bigInt == null || !bigInt.hasNativeBignum()) {
            throw new AssertionError();
        }
        this.setBigInt(bigInt);
    }

    BigInteger(int sign, long value) {
        BigInt bigInt = new BigInt();
        bigInt.putULongInt(value, sign < 0);
        this.setBigInt(bigInt);
    }

    BigInteger(int sign, int numberLength, int[] digits) {
        this.setJavaRepresentation(sign, numberLength, digits);
    }

    public BigInteger(int numBits, Random random) {
        if (numBits < 0) {
            throw new IllegalArgumentException("numBits < 0: " + numBits);
        }
        if (numBits == 0) {
            this.setJavaRepresentation(0, 1, new int[]{0});
        } else {
            int sign = 1;
            int numberLength = numBits + 31 >> 5;
            int[] digits = new int[numberLength];
            for (int i = 0; i < numberLength; ++i) {
                digits[i] = random.nextInt();
            }
            int n = numberLength - 1;
            digits[n] = digits[n] >>> (-numBits & 0x1F);
            this.setJavaRepresentation(sign, numberLength, digits);
        }
        this.javaIsValid = true;
    }

    public BigInteger(int bitLength, int certainty, Random random) {
        if (bitLength < 2) {
            throw new ArithmeticException("bitLength < 2: " + bitLength);
        }
        if (bitLength < 16) {
            int candidate;
            do {
                candidate = random.nextInt() & (1 << bitLength) - 1;
                candidate |= 1 << bitLength - 1;
                if (bitLength <= 2) continue;
                candidate |= 1;
            } while (!BigInteger.isSmallPrime(candidate));
            BigInt prime = new BigInt();
            prime.putULongInt(candidate, false);
            this.setBigInt(prime);
        } else {
            do {
                this.setBigInt(BigInt.generatePrimeDefault(bitLength));
            } while (this.bitLength() != bitLength);
        }
    }

    private static boolean isSmallPrime(int x) {
        if (x == 2) {
            return true;
        }
        if (x % 2 == 0) {
            return false;
        }
        int max = (int)Math.sqrt(x);
        for (int i = 3; i <= max; i += 2) {
            if (x % i != 0) continue;
            return false;
        }
        return true;
    }

    public BigInteger(String value) {
        BigInt bigInt = new BigInt();
        bigInt.putDecString(value);
        this.setBigInt(bigInt);
    }

    public BigInteger(String value, int radix) {
        if (value == null) {
            throw new NullPointerException("value == null");
        }
        if (radix == 10) {
            BigInt bigInt = new BigInt();
            bigInt.putDecString(value);
            this.setBigInt(bigInt);
        } else if (radix == 16) {
            BigInt bigInt = new BigInt();
            bigInt.putHexString(value);
            this.setBigInt(bigInt);
        } else {
            if (radix < 2 || radix > 36) {
                throw new NumberFormatException("Invalid radix: " + radix);
            }
            if (value.isEmpty()) {
                throw new NumberFormatException("value.isEmpty()");
            }
            BigInteger.parseFromString(this, value, radix);
        }
    }

    public BigInteger(int signum, byte[] magnitude) {
        if (magnitude == null) {
            throw new NullPointerException("magnitude == null");
        }
        if (signum < -1 || signum > 1) {
            throw new NumberFormatException("Invalid signum: " + signum);
        }
        if (signum == 0) {
            for (byte element : magnitude) {
                if (element == 0) continue;
                throw new NumberFormatException("signum-magnitude mismatch");
            }
        }
        BigInt bigInt = new BigInt();
        bigInt.putBigEndian(magnitude, signum < 0);
        this.setBigInt(bigInt);
    }

    public BigInteger(byte[] value) {
        if (value.length == 0) {
            throw new NumberFormatException("value.length == 0");
        }
        BigInt bigInt = new BigInt();
        bigInt.putBigEndianTwosComplement(value);
        this.setBigInt(bigInt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BigInt getBigInt() {
        if (this.nativeIsValid) {
            return this.bigInt;
        }
        BigInteger bigInteger = this;
        synchronized (bigInteger) {
            if (this.nativeIsValid) {
                return this.bigInt;
            }
            BigInt bigInt = new BigInt();
            bigInt.putLittleEndianInts(this.digits, this.sign < 0);
            this.setBigInt(bigInt);
            return bigInt;
        }
    }

    private void setBigInt(BigInt bigInt) {
        this.bigInt = bigInt;
        this.nativeIsValid = true;
    }

    private void setJavaRepresentation(int sign, int numberLength, int[] digits) {
        while (numberLength > 0 && digits[--numberLength] == 0) {
        }
        if (digits[numberLength++] == 0) {
            sign = 0;
        }
        this.sign = sign;
        this.digits = digits;
        this.numberLength = numberLength;
        this.javaIsValid = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void prepareJavaRepresentation() {
        if (this.javaIsValid) {
            return;
        }
        BigInteger bigInteger = this;
        synchronized (bigInteger) {
            int[] nArray;
            if (this.javaIsValid) {
                return;
            }
            int sign = this.bigInt.sign();
            if (sign != 0) {
                nArray = this.bigInt.littleEndianIntsMagnitude();
            } else {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 0;
            }
            int[] digits = nArray;
            this.setJavaRepresentation(sign, digits.length, digits);
        }
    }

    public static BigInteger valueOf(long value) {
        if (value < 0L) {
            if (value != -1L) {
                return new BigInteger(-1, -value);
            }
            return MINUS_ONE;
        }
        if (value < (long)SMALL_VALUES.length) {
            return SMALL_VALUES[(int)value];
        }
        return new BigInteger(1, value);
    }

    public byte[] toByteArray() {
        return this.twosComplement();
    }

    public BigInteger abs() {
        BigInt bigInt = this.getBigInt();
        if (bigInt.sign() >= 0) {
            return this;
        }
        BigInt a = bigInt.copy();
        a.setSign(1);
        return new BigInteger(a);
    }

    public BigInteger negate() {
        BigInt bigInt = this.getBigInt();
        int sign = bigInt.sign();
        if (sign == 0) {
            return this;
        }
        BigInt a = bigInt.copy();
        a.setSign(-sign);
        return new BigInteger(a);
    }

    public BigInteger add(BigInteger value) {
        BigInt lhs = this.getBigInt();
        BigInt rhs = value.getBigInt();
        if (rhs.sign() == 0) {
            return this;
        }
        if (lhs.sign() == 0) {
            return value;
        }
        return new BigInteger(BigInt.addition(lhs, rhs));
    }

    public BigInteger subtract(BigInteger value) {
        BigInt lhs = this.getBigInt();
        BigInt rhs = value.getBigInt();
        if (rhs.sign() == 0) {
            return this;
        }
        return new BigInteger(BigInt.subtraction(lhs, rhs));
    }

    public int signum() {
        if (this.javaIsValid) {
            return this.sign;
        }
        return this.getBigInt().sign();
    }

    public BigInteger shiftRight(int n) {
        return this.shiftLeft(-n);
    }

    public BigInteger shiftLeft(int n) {
        if (n == 0) {
            return this;
        }
        int sign = this.signum();
        if (sign == 0) {
            return this;
        }
        if (sign > 0 || n >= 0) {
            return new BigInteger(BigInt.shift(this.getBigInt(), n));
        }
        return BitLevel.shiftRight(this, -n);
    }

    BigInteger shiftLeftOneBit() {
        return this.signum() == 0 ? this : BitLevel.shiftLeftOneBit(this);
    }

    public int bitLength() {
        if (!this.nativeIsValid && this.javaIsValid) {
            return BitLevel.bitLength(this);
        }
        return this.getBigInt().bitLength();
    }

    public boolean testBit(int n) {
        if (n < 0) {
            throw new ArithmeticException("n < 0: " + n);
        }
        int sign = this.signum();
        if (sign > 0 && this.nativeIsValid && !this.javaIsValid) {
            return this.getBigInt().isBitSet(n);
        }
        this.prepareJavaRepresentation();
        if (n == 0) {
            return (this.digits[0] & 1) != 0;
        }
        int intCount = n >> 5;
        if (intCount >= this.numberLength) {
            return sign < 0;
        }
        int digit = this.digits[intCount];
        n = 1 << (n & 0x1F);
        if (sign < 0) {
            int firstNonZeroDigit = this.getFirstNonzeroDigit();
            if (intCount < firstNonZeroDigit) {
                return false;
            }
            digit = firstNonZeroDigit == intCount ? -digit : (digit ^= 0xFFFFFFFF);
        }
        return (digit & n) != 0;
    }

    public BigInteger setBit(int n) {
        this.prepareJavaRepresentation();
        if (!this.testBit(n)) {
            return BitLevel.flipBit(this, n);
        }
        return this;
    }

    public BigInteger clearBit(int n) {
        this.prepareJavaRepresentation();
        if (this.testBit(n)) {
            return BitLevel.flipBit(this, n);
        }
        return this;
    }

    public BigInteger flipBit(int n) {
        this.prepareJavaRepresentation();
        if (n < 0) {
            throw new ArithmeticException("n < 0: " + n);
        }
        return BitLevel.flipBit(this, n);
    }

    public int getLowestSetBit() {
        this.prepareJavaRepresentation();
        if (this.sign == 0) {
            return -1;
        }
        int i = this.getFirstNonzeroDigit();
        return (i << 5) + Integer.numberOfTrailingZeros(this.digits[i]);
    }

    public int bitCount() {
        this.prepareJavaRepresentation();
        return BitLevel.bitCount(this);
    }

    public BigInteger not() {
        this.prepareJavaRepresentation();
        return Logical.not(this);
    }

    public BigInteger and(BigInteger value) {
        this.prepareJavaRepresentation();
        value.prepareJavaRepresentation();
        return Logical.and(this, value);
    }

    public BigInteger or(BigInteger value) {
        this.prepareJavaRepresentation();
        value.prepareJavaRepresentation();
        return Logical.or(this, value);
    }

    public BigInteger xor(BigInteger value) {
        this.prepareJavaRepresentation();
        value.prepareJavaRepresentation();
        return Logical.xor(this, value);
    }

    public BigInteger andNot(BigInteger value) {
        this.prepareJavaRepresentation();
        value.prepareJavaRepresentation();
        return Logical.andNot(this, value);
    }

    @Override
    public int intValue() {
        if (this.nativeIsValid && this.bigInt.twosCompFitsIntoBytes(4)) {
            return (int)this.bigInt.longInt();
        }
        this.prepareJavaRepresentation();
        return this.sign * this.digits[0];
    }

    @Override
    public long longValue() {
        if (this.nativeIsValid && this.bigInt.twosCompFitsIntoBytes(8)) {
            return this.bigInt.longInt();
        }
        this.prepareJavaRepresentation();
        long value = this.numberLength > 1 ? (long)this.digits[1] << 32 | (long)this.digits[0] & 0xFFFFFFFFL : (long)this.digits[0] & 0xFFFFFFFFL;
        return (long)this.sign * value;
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    @Override
    public double doubleValue() {
        return Conversion.bigInteger2Double(this);
    }

    @Override
    public int compareTo(BigInteger value) {
        return BigInt.cmp(this.getBigInt(), value.getBigInt());
    }

    public BigInteger min(BigInteger value) {
        return this.compareTo(value) == -1 ? this : value;
    }

    public BigInteger max(BigInteger value) {
        return this.compareTo(value) == 1 ? this : value;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.prepareJavaRepresentation();
            int hash = 0;
            for (int i = 0; i < this.numberLength; ++i) {
                hash = hash * 33 + this.digits[i];
            }
            this.hashCode = hash * this.sign;
        }
        return this.hashCode;
    }

    public boolean equals(Object x) {
        if (this == x) {
            return true;
        }
        if (x instanceof BigInteger) {
            return this.compareTo((BigInteger)x) == 0;
        }
        return false;
    }

    public String toString() {
        return this.getBigInt().decString();
    }

    public String toString(int radix) {
        if (radix == 10) {
            return this.getBigInt().decString();
        }
        this.prepareJavaRepresentation();
        return Conversion.bigInteger2String(this, radix);
    }

    public BigInteger gcd(BigInteger value) {
        return new BigInteger(BigInt.gcd(this.getBigInt(), value.getBigInt()));
    }

    public BigInteger multiply(BigInteger value) {
        return new BigInteger(BigInt.product(this.getBigInt(), value.getBigInt()));
    }

    public BigInteger pow(int exp) {
        if (exp < 0) {
            throw new ArithmeticException("exp < 0: " + exp);
        }
        return new BigInteger(BigInt.exp(this.getBigInt(), exp));
    }

    public BigInteger[] divideAndRemainder(BigInteger divisor) {
        BigInt divisorBigInt = divisor.getBigInt();
        BigInt quotient = new BigInt();
        BigInt remainder = new BigInt();
        BigInt.division(this.getBigInt(), divisorBigInt, quotient, remainder);
        return new BigInteger[]{new BigInteger(quotient), new BigInteger(remainder)};
    }

    public BigInteger divide(BigInteger divisor) {
        BigInt quotient = new BigInt();
        BigInt.division(this.getBigInt(), divisor.getBigInt(), quotient, null);
        return new BigInteger(quotient);
    }

    public BigInteger remainder(BigInteger divisor) {
        BigInt remainder = new BigInt();
        BigInt.division(this.getBigInt(), divisor.getBigInt(), null, remainder);
        return new BigInteger(remainder);
    }

    public BigInteger modInverse(BigInteger m) {
        if (m.signum() <= 0) {
            throw new ArithmeticException("modulus not positive");
        }
        return new BigInteger(BigInt.modInverse(this.getBigInt(), m.getBigInt()));
    }

    public BigInteger modPow(BigInteger exponent, BigInteger modulus) {
        if (modulus.signum() <= 0) {
            throw new ArithmeticException("modulus.signum() <= 0");
        }
        int exponentSignum = exponent.signum();
        if (exponentSignum == 0) {
            return ONE.mod(modulus);
        }
        BigInteger base = exponentSignum < 0 ? this.modInverse(modulus) : this;
        return new BigInteger(BigInt.modExp(base.getBigInt(), exponent.getBigInt(), modulus.getBigInt()));
    }

    public BigInteger mod(BigInteger m) {
        if (m.signum() <= 0) {
            throw new ArithmeticException("m.signum() <= 0");
        }
        return new BigInteger(BigInt.modulus(this.getBigInt(), m.getBigInt()));
    }

    public boolean isProbablePrime(int certainty) {
        if (certainty <= 0) {
            return true;
        }
        return this.getBigInt().isPrime(certainty);
    }

    public BigInteger nextProbablePrime() {
        if (this.sign < 0) {
            throw new ArithmeticException("sign < 0");
        }
        return Primality.nextProbablePrime(this);
    }

    public static BigInteger probablePrime(int bitLength, Random random) {
        return new BigInteger(bitLength, 100, random);
    }

    private byte[] twosComplement() {
        int highBytes;
        this.prepareJavaRepresentation();
        if (this.sign == 0) {
            return new byte[]{0};
        }
        BigInteger temp = this;
        int bitLen = this.bitLength();
        int iThis = this.getFirstNonzeroDigit();
        int bytesLen = (bitLen >> 3) + 1;
        byte[] bytes = new byte[bytesLen];
        int firstByteNumber = 0;
        int bytesInInteger = 4;
        if (bytesLen - (this.numberLength << 2) == 1) {
            bytes[0] = (byte)(this.sign < 0 ? -1 : 0);
            highBytes = 4;
            ++firstByteNumber;
        } else {
            int hB = bytesLen & 3;
            highBytes = hB == 0 ? 4 : hB;
        }
        int digitIndex = iThis;
        bytesLen -= iThis << 2;
        if (this.sign < 0) {
            int digit = -temp.digits[digitIndex];
            if (++digitIndex == this.numberLength) {
                bytesInInteger = highBytes;
            }
            int i = 0;
            while (i < bytesInInteger) {
                bytes[--bytesLen] = (byte)digit;
                ++i;
                digit >>= 8;
            }
            while (bytesLen > firstByteNumber) {
                digit = ~temp.digits[digitIndex];
                if (++digitIndex == this.numberLength) {
                    bytesInInteger = highBytes;
                }
                i = 0;
                while (i < bytesInInteger) {
                    bytes[--bytesLen] = (byte)digit;
                    ++i;
                    digit >>= 8;
                }
            }
        } else {
            while (bytesLen > firstByteNumber) {
                int digit = temp.digits[digitIndex];
                if (++digitIndex == this.numberLength) {
                    bytesInInteger = highBytes;
                }
                int i = 0;
                while (i < bytesInInteger) {
                    bytes[--bytesLen] = (byte)digit;
                    ++i;
                    digit >>= 8;
                }
            }
        }
        return bytes;
    }

    static int multiplyByInt(int[] res, int[] a, int aSize, int factor) {
        long carry = 0L;
        for (int i = 0; i < aSize; ++i) {
            res[i] = (int)(carry += ((long)a[i] & 0xFFFFFFFFL) * ((long)factor & 0xFFFFFFFFL));
            carry >>>= 32;
        }
        return (int)carry;
    }

    static int inplaceAdd(int[] a, int aSize, int addend) {
        long carry = (long)addend & 0xFFFFFFFFL;
        for (int i = 0; carry != 0L && i < aSize; carry >>= 32, ++i) {
            a[i] = (int)(carry += (long)a[i] & 0xFFFFFFFFL);
        }
        return (int)carry;
    }

    private static void parseFromString(BigInteger bi, String value, int radix) {
        int startChar;
        int sign;
        int stringLength = value.length();
        int endChar = stringLength--;
        if (value.charAt(0) == '-') {
            sign = -1;
            startChar = 1;
        } else {
            sign = 1;
            startChar = 0;
        }
        int charsPerInt = Conversion.digitFitInInt[radix];
        int bigRadixDigitsLength = stringLength / charsPerInt;
        int topChars = stringLength % charsPerInt;
        if (topChars != 0) {
            ++bigRadixDigitsLength;
        }
        int[] digits = new int[bigRadixDigitsLength];
        int bigRadix = Conversion.bigRadices[radix - 2];
        int digitIndex = 0;
        int substrEnd = startChar + (topChars == 0 ? charsPerInt : topChars);
        int substrStart = startChar;
        while (substrStart < endChar) {
            int bigRadixDigit = Integer.parseInt(value.substring(substrStart, substrEnd), radix);
            int newDigit = BigInteger.multiplyByInt(digits, digits, digitIndex, bigRadix);
            digits[digitIndex++] = newDigit += BigInteger.inplaceAdd(digits, digitIndex, bigRadixDigit);
            substrStart = substrEnd;
            substrEnd = substrStart + charsPerInt;
        }
        int numberLength = digitIndex;
        bi.setJavaRepresentation(sign, numberLength, digits);
    }

    int getFirstNonzeroDigit() {
        if (this.firstNonzeroDigit == -2) {
            int i;
            if (this.sign == 0) {
                i = -1;
            } else {
                i = 0;
                while (this.digits[i] == 0) {
                    ++i;
                }
            }
            this.firstNonzeroDigit = i;
        }
        return this.firstNonzeroDigit;
    }

    BigInteger copy() {
        this.prepareJavaRepresentation();
        int[] copyDigits = new int[this.numberLength];
        System.arraycopy(this.digits, 0, copyDigits, 0, this.numberLength);
        return new BigInteger(this.sign, this.numberLength, copyDigits);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        BigInt bigInt = new BigInt();
        bigInt.putBigEndian(this.magnitude, this.signum < 0);
        this.setBigInt(bigInt);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        BigInt bigInt = this.getBigInt();
        this.signum = bigInt.sign();
        this.magnitude = bigInt.bigEndianMagnitude();
        out.defaultWriteObject();
    }
}

