/*
 * Decompiled with CFR 0.152.
 */
package java.nio.charset;

import java.io.UTFDataFormatException;

public class ModifiedUtf8 {
    public static long countBytes(String s, boolean shortLength) throws UTFDataFormatException {
        long counter = 0L;
        int strLen = s.length();
        for (int i = 0; i < strLen; ++i) {
            char c = s.charAt(i);
            if (c < '\u0080') {
                ++counter;
                if (c != '\u0000') continue;
                ++counter;
                continue;
            }
            if (c < '\u0800') {
                counter += 2L;
                continue;
            }
            counter += 3L;
        }
        if (shortLength && counter > 65535L) {
            throw new UTFDataFormatException("Size of the encoded string doesn't fit in two bytes");
        }
        return counter;
    }

    public static void encode(byte[] dst, int offset, String s) {
        int strLen = s.length();
        for (int i = 0; i < strLen; ++i) {
            char c = s.charAt(i);
            if (c < '\u0080') {
                if (c == '\u0000') {
                    dst[offset++] = -64;
                    dst[offset++] = -128;
                    continue;
                }
                dst[offset++] = (byte)c;
                continue;
            }
            if (c < '\u0800') {
                dst[offset++] = (byte)(c >>> 6 | 0xC0);
                dst[offset++] = (byte)(c & 0x3F | 0x80);
                continue;
            }
            dst[offset++] = (byte)(c >>> 12 | 0xE0);
            dst[offset++] = (byte)(c >>> 6 & 0x3F | 0x80);
            dst[offset++] = (byte)(c & 0x3F | 0x80);
        }
    }

    public static byte[] encode(String s) throws UTFDataFormatException {
        long size = ModifiedUtf8.countBytes(s, true);
        byte[] output = new byte[(int)size + 2];
        ModifiedUtf8.encode(output, 2, s);
        output[0] = (byte)(size >>> 8);
        output[1] = (byte)size;
        return output;
    }

    public static String decode(byte[] in, char[] out, int offset, int length) throws UTFDataFormatException {
        if (offset < 0 || length < 0) {
            throw new IllegalArgumentException("Illegal arguments: offset " + offset + ". Length: " + length);
        }
        int outputIndex = 0;
        int limitIndex = offset + length;
        while (offset < limitIndex) {
            int i = in[offset] & 0xFF;
            ++offset;
            if (i < 128) {
                out[outputIndex] = (char)i;
                ++outputIndex;
                continue;
            }
            if (192 <= i && i < 224) {
                i = (i & 0x1F) << 6;
                if (offset == limitIndex) {
                    throw new UTFDataFormatException("unexpected end of input");
                }
                if ((in[offset] & 0xC0) != 128) {
                    throw new UTFDataFormatException("bad second byte at " + offset);
                }
                out[outputIndex] = (char)(i | in[offset] & 0x3F);
                ++offset;
                ++outputIndex;
                continue;
            }
            if (i < 240) {
                i = (i & 0x1F) << 12;
                if (offset + 1 >= limitIndex) {
                    throw new UTFDataFormatException("unexpected end of input");
                }
                if ((in[offset] & 0xC0) != 128) {
                    throw new UTFDataFormatException("bad second byte at " + offset);
                }
                i |= (in[offset] & 0x3F) << 6;
                if ((in[++offset] & 0xC0) != 128) {
                    throw new UTFDataFormatException("bad third byte at " + offset);
                }
                out[outputIndex] = (char)(i | in[offset] & 0x3F);
                ++offset;
                ++outputIndex;
                continue;
            }
            throw new UTFDataFormatException("Invalid UTF8 byte " + i + " at position " + (offset - 1));
        }
        return String.valueOf(out, 0, outputIndex);
    }
}

