/*
 * Decompiled with CFR 0.152.
 */
package libcore.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class Java9LanguageFeatures {
    @SafeVarargs
    public static <T> String toListString(T ... values) {
        return Java9LanguageFeatures.toString(values).toString();
    }

    @SafeVarargs
    private static <T> List<String> toString(T ... values) {
        ArrayList<String> result = new ArrayList<String>();
        for (T value : values) {
            result.add(value.toString());
        }
        return result;
    }

    public <T> AtomicReference<T> createReference(T content) {
        return new AtomicReference<T>(content){};
    }

    public static byte[] copy(byte[] bytes) throws IOException {
        ByteArrayInputStream inputStream;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (ByteArrayInputStream byteArrayInputStream = inputStream = new ByteArrayInputStream(bytes);){
            int value;
            while ((value = ((InputStream)inputStream).read()) != -1) {
                byteArrayOutputStream.write(value);
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static interface Person {
        public String name();

        default public boolean isPalindrome() {
            return this.name().equals(this.reverse(this.name()));
        }

        default public boolean isPalindromeIgnoreCase() {
            return this.name().equalsIgnoreCase(this.reverse(this.name()));
        }

        private String reverse(String s) {
            return new StringBuilder(s).reverse().toString();
        }
    }
}

