/*
 * Decompiled with CFR 0.152.
 */
package libcore.io;

import android.system.ErrnoException;
import android.system.OsConstants;
import android.system.StructStat;
import dalvik.annotation.compat.UnsupportedAppUsage;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.RandomAccessFile;
import java.net.DatagramSocketImpl;
import java.net.Socket;
import java.net.SocketImpl;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import libcore.io.IoBridge;
import libcore.io.Libcore;

public final class IoUtils {
    private IoUtils() {
    }

    public static int acquireRawFd(FileDescriptor fd) {
        Objects.requireNonNull(fd);
        FileDescriptor copy = fd.release$();
        int rawFd = copy.getInt$();
        long previousOwnerId = copy.getOwnerId$();
        if (rawFd != -1 && previousOwnerId != 0L) {
            Libcore.os.android_fdsan_exchange_owner_tag(copy, previousOwnerId, 0L);
        }
        return rawFd;
    }

    private static boolean isParcelFileDescriptor(Object object) {
        try {
            Class<?> pfdClass = Class.forName("android.os.ParcelFileDescriptor");
            return pfdClass.isInstance(object);
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    private static long generateFdOwnerId(Object owner) {
        if (owner == null) {
            return 0L;
        }
        long tagType = owner instanceof FileInputStream ? 5L : (owner instanceof FileOutputStream ? 6L : (owner instanceof RandomAccessFile ? 7L : (owner instanceof DatagramSocketImpl ? 10L : (owner instanceof SocketImpl ? 11L : (IoUtils.isParcelFileDescriptor(owner) ? 8L : 255L)))));
        long tagValue = System.identityHashCode(owner);
        return tagType << 56 | tagValue;
    }

    public static void setFdOwner(FileDescriptor fd, Object owner) {
        Objects.requireNonNull(fd);
        Objects.requireNonNull(owner);
        long previousOwnerId = fd.getOwnerId$();
        if (previousOwnerId != 0L) {
            throw new IllegalStateException("Attempted to take ownership of already-owned FileDescriptor");
        }
        long ownerId = IoUtils.generateFdOwnerId(owner);
        fd.setOwnerId$(ownerId);
        Libcore.os.android_fdsan_exchange_owner_tag(fd, previousOwnerId, ownerId);
    }

    public static void close(FileDescriptor fd) throws IOException {
        IoBridge.closeAndSignalBlockedThreads(fd);
    }

    @UnsupportedAppUsage
    public static void closeQuietly(AutoCloseable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (RuntimeException rethrown) {
                throw rethrown;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @UnsupportedAppUsage
    public static void closeQuietly(FileDescriptor fd) {
        try {
            IoUtils.close(fd);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @UnsupportedAppUsage
    public static void closeQuietly(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @UnsupportedAppUsage
    public static void setBlocking(FileDescriptor fd, boolean blocking) throws IOException {
        try {
            int flags = Libcore.os.fcntlVoid(fd, OsConstants.F_GETFL);
            flags = !blocking ? (flags |= OsConstants.O_NONBLOCK) : (flags &= ~OsConstants.O_NONBLOCK);
            Libcore.os.fcntlInt(fd, OsConstants.F_SETFL, flags);
        }
        catch (ErrnoException errnoException) {
            throw errnoException.rethrowAsIOException();
        }
    }

    @UnsupportedAppUsage
    public static byte[] readFileAsByteArray(String absolutePath) throws IOException {
        return new FileReader(absolutePath).readFully().toByteArray();
    }

    @UnsupportedAppUsage
    public static String readFileAsString(String absolutePath) throws IOException {
        return new FileReader(absolutePath).readFully().toString(StandardCharsets.UTF_8);
    }

    @Deprecated
    public static void deleteContents(File dir) throws IOException {
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    IoUtils.deleteContents(file);
                }
                file.delete();
            }
        }
    }

    @Deprecated
    public static File createTemporaryDirectory(String prefix) {
        String candidateName;
        File result;
        do {
            candidateName = prefix + Math.randomIntInternal();
        } while (!(result = new File(System.getProperty("java.io.tmpdir"), candidateName)).mkdir());
        return result;
    }

    public static boolean canOpenReadOnly(String path) {
        try {
            FileDescriptor fd = Libcore.os.open(path, OsConstants.O_RDONLY, 0);
            Libcore.os.close(fd);
            return true;
        }
        catch (ErrnoException errnoException) {
            return false;
        }
    }

    public static void throwInterruptedIoException() throws InterruptedIOException {
        Thread.currentThread().interrupt();
        throw new InterruptedIOException();
    }

    private static class FileReader {
        private FileDescriptor fd;
        private boolean unknownLength;
        private byte[] bytes;
        private int count;

        public FileReader(String absolutePath) throws IOException {
            int capacity;
            this.fd = IoBridge.open(absolutePath, OsConstants.O_RDONLY);
            try {
                StructStat stat = Libcore.os.fstat(this.fd);
                capacity = (int)stat.st_size;
                if (capacity == 0) {
                    this.unknownLength = true;
                    capacity = 8192;
                }
            }
            catch (ErrnoException exception) {
                IoUtils.closeQuietly(this.fd);
                throw exception.rethrowAsIOException();
            }
            this.bytes = new byte[capacity];
        }

        public FileReader readFully() throws IOException {
            int capacity = this.bytes.length;
            try {
                int read;
                while ((read = Libcore.os.read(this.fd, this.bytes, this.count, capacity - this.count)) != 0) {
                    this.count += read;
                    if (this.count != capacity) continue;
                    if (!this.unknownLength) break;
                    int newCapacity = capacity * 2;
                    byte[] newBytes = new byte[newCapacity];
                    System.arraycopy((byte[])this.bytes, (int)0, (byte[])newBytes, (int)0, (int)capacity);
                    this.bytes = newBytes;
                    capacity = newCapacity;
                }
                FileReader newCapacity = this;
                return newCapacity;
            }
            catch (ErrnoException e) {
                throw e.rethrowAsIOException();
            }
            finally {
                IoUtils.closeQuietly(this.fd);
            }
        }

        @FindBugsSuppressWarnings(value={"EI_EXPOSE_REP"})
        public byte[] toByteArray() {
            if (this.count == this.bytes.length) {
                return this.bytes;
            }
            byte[] result = new byte[this.count];
            System.arraycopy((byte[])this.bytes, (int)0, (byte[])result, (int)0, (int)this.count);
            return result;
        }

        public String toString(Charset cs) {
            return new String(this.bytes, 0, this.count, cs);
        }
    }
}

