/*
 * Decompiled with CFR 0.152.
 */
package libcore.io;

import dalvik.annotation.compat.UnsupportedAppUsage;
import dalvik.annotation.optimization.FastNative;
import java.nio.ByteOrder;

public final class Memory {
    private Memory() {
    }

    public static native void unsafeBulkGet(Object var0, int var1, int var2, byte[] var3, int var4, int var5, boolean var6);

    public static native void unsafeBulkPut(byte[] var0, int var1, int var2, Object var3, int var4, int var5, boolean var6);

    public static int peekInt(byte[] src, int offset, ByteOrder order) {
        if (order == ByteOrder.BIG_ENDIAN) {
            return (src[offset++] & 0xFF) << 24 | (src[offset++] & 0xFF) << 16 | (src[offset++] & 0xFF) << 8 | (src[offset] & 0xFF) << 0;
        }
        return (src[offset++] & 0xFF) << 0 | (src[offset++] & 0xFF) << 8 | (src[offset++] & 0xFF) << 16 | (src[offset] & 0xFF) << 24;
    }

    public static long peekLong(byte[] src, int offset, ByteOrder order) {
        if (order == ByteOrder.BIG_ENDIAN) {
            int h = (src[offset++] & 0xFF) << 24 | (src[offset++] & 0xFF) << 16 | (src[offset++] & 0xFF) << 8 | (src[offset++] & 0xFF) << 0;
            int l = (src[offset++] & 0xFF) << 24 | (src[offset++] & 0xFF) << 16 | (src[offset++] & 0xFF) << 8 | (src[offset] & 0xFF) << 0;
            return (long)h << 32 | (long)l & 0xFFFFFFFFL;
        }
        int l = (src[offset++] & 0xFF) << 0 | (src[offset++] & 0xFF) << 8 | (src[offset++] & 0xFF) << 16 | (src[offset++] & 0xFF) << 24;
        int h = (src[offset++] & 0xFF) << 0 | (src[offset++] & 0xFF) << 8 | (src[offset++] & 0xFF) << 16 | (src[offset] & 0xFF) << 24;
        return (long)h << 32 | (long)l & 0xFFFFFFFFL;
    }

    public static short peekShort(byte[] src, int offset, ByteOrder order) {
        if (order == ByteOrder.BIG_ENDIAN) {
            return (short)(src[offset] << 8 | src[offset + 1] & 0xFF);
        }
        return (short)(src[offset + 1] << 8 | src[offset] & 0xFF);
    }

    public static void pokeInt(byte[] dst, int offset, int value, ByteOrder order) {
        if (order == ByteOrder.BIG_ENDIAN) {
            dst[offset++] = (byte)(value >> 24 & 0xFF);
            dst[offset++] = (byte)(value >> 16 & 0xFF);
            dst[offset++] = (byte)(value >> 8 & 0xFF);
            dst[offset] = (byte)(value >> 0 & 0xFF);
        } else {
            dst[offset++] = (byte)(value >> 0 & 0xFF);
            dst[offset++] = (byte)(value >> 8 & 0xFF);
            dst[offset++] = (byte)(value >> 16 & 0xFF);
            dst[offset] = (byte)(value >> 24 & 0xFF);
        }
    }

    public static void pokeLong(byte[] dst, int offset, long value, ByteOrder order) {
        if (order == ByteOrder.BIG_ENDIAN) {
            int i = (int)(value >> 32);
            dst[offset++] = (byte)(i >> 24 & 0xFF);
            dst[offset++] = (byte)(i >> 16 & 0xFF);
            dst[offset++] = (byte)(i >> 8 & 0xFF);
            dst[offset++] = (byte)(i >> 0 & 0xFF);
            i = (int)value;
            dst[offset++] = (byte)(i >> 24 & 0xFF);
            dst[offset++] = (byte)(i >> 16 & 0xFF);
            dst[offset++] = (byte)(i >> 8 & 0xFF);
            dst[offset] = (byte)(i >> 0 & 0xFF);
        } else {
            int i = (int)value;
            dst[offset++] = (byte)(i >> 0 & 0xFF);
            dst[offset++] = (byte)(i >> 8 & 0xFF);
            dst[offset++] = (byte)(i >> 16 & 0xFF);
            dst[offset++] = (byte)(i >> 24 & 0xFF);
            i = (int)(value >> 32);
            dst[offset++] = (byte)(i >> 0 & 0xFF);
            dst[offset++] = (byte)(i >> 8 & 0xFF);
            dst[offset++] = (byte)(i >> 16 & 0xFF);
            dst[offset] = (byte)(i >> 24 & 0xFF);
        }
    }

    public static void pokeShort(byte[] dst, int offset, short value, ByteOrder order) {
        if (order == ByteOrder.BIG_ENDIAN) {
            dst[offset++] = (byte)(value >> 8 & 0xFF);
            dst[offset] = (byte)(value >> 0 & 0xFF);
        } else {
            dst[offset++] = (byte)(value >> 0 & 0xFF);
            dst[offset] = (byte)(value >> 8 & 0xFF);
        }
    }

    public static native void memmove(Object var0, int var1, Object var2, int var3, long var4);

    @UnsupportedAppUsage
    @FastNative
    public static native byte peekByte(long var0);

    @UnsupportedAppUsage
    public static int peekInt(long address, boolean swap) {
        int result = Memory.peekIntNative(address);
        if (swap) {
            result = Integer.reverseBytes(result);
        }
        return result;
    }

    @FastNative
    private static native int peekIntNative(long var0);

    @UnsupportedAppUsage
    public static long peekLong(long address, boolean swap) {
        long result = Memory.peekLongNative(address);
        if (swap) {
            result = Long.reverseBytes(result);
        }
        return result;
    }

    @FastNative
    private static native long peekLongNative(long var0);

    public static short peekShort(long address, boolean swap) {
        short result = Memory.peekShortNative(address);
        if (swap) {
            result = Short.reverseBytes(result);
        }
        return result;
    }

    @FastNative
    private static native short peekShortNative(long var0);

    @UnsupportedAppUsage
    public static native void peekByteArray(long var0, byte[] var2, int var3, int var4);

    public static native void peekCharArray(long var0, char[] var2, int var3, int var4, boolean var5);

    public static native void peekDoubleArray(long var0, double[] var2, int var3, int var4, boolean var5);

    public static native void peekFloatArray(long var0, float[] var2, int var3, int var4, boolean var5);

    public static native void peekIntArray(long var0, int[] var2, int var3, int var4, boolean var5);

    public static native void peekLongArray(long var0, long[] var2, int var3, int var4, boolean var5);

    public static native void peekShortArray(long var0, short[] var2, int var3, int var4, boolean var5);

    @UnsupportedAppUsage
    @FastNative
    public static native void pokeByte(long var0, byte var2);

    @UnsupportedAppUsage
    public static void pokeInt(long address, int value, boolean swap) {
        if (swap) {
            value = Integer.reverseBytes(value);
        }
        Memory.pokeIntNative(address, value);
    }

    @FastNative
    private static native void pokeIntNative(long var0, int var2);

    @UnsupportedAppUsage
    public static void pokeLong(long address, long value, boolean swap) {
        if (swap) {
            value = Long.reverseBytes(value);
        }
        Memory.pokeLongNative(address, value);
    }

    @FastNative
    private static native void pokeLongNative(long var0, long var2);

    public static void pokeShort(long address, short value, boolean swap) {
        if (swap) {
            value = Short.reverseBytes(value);
        }
        Memory.pokeShortNative(address, value);
    }

    @FastNative
    private static native void pokeShortNative(long var0, short var2);

    @UnsupportedAppUsage
    public static native void pokeByteArray(long var0, byte[] var2, int var3, int var4);

    public static native void pokeCharArray(long var0, char[] var2, int var3, int var4, boolean var5);

    public static native void pokeDoubleArray(long var0, double[] var2, int var3, int var4, boolean var5);

    public static native void pokeFloatArray(long var0, float[] var2, int var3, int var4, boolean var5);

    public static native void pokeIntArray(long var0, int[] var2, int var3, int var4, boolean var5);

    public static native void pokeLongArray(long var0, long[] var2, int var3, int var4, boolean var5);

    public static native void pokeShortArray(long var0, short[] var2, int var3, int var4, boolean var5);
}

