/*
 * Decompiled with CFR 0.152.
 */
package libcore.io;

import android.system.ErrnoException;
import android.system.OsConstants;
import dalvik.annotation.compat.UnsupportedAppUsage;
import java.io.FileDescriptor;
import java.nio.ByteOrder;
import libcore.io.BufferIterator;
import libcore.io.Libcore;
import libcore.io.NioBufferIterator;

public final class MemoryMappedFile
implements AutoCloseable {
    private boolean closed;
    private final long address;
    private final int size;

    public MemoryMappedFile(long address, long size) {
        this.address = address;
        if (size < 0L || size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Unsupported file size=" + size);
        }
        this.size = (int)size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UnsupportedAppUsage
    public static MemoryMappedFile mmapRO(String path) throws ErrnoException {
        FileDescriptor fd = Libcore.os.open(path, OsConstants.O_RDONLY, 0);
        try {
            long size = Libcore.os.fstat((FileDescriptor)fd).st_size;
            long address = Libcore.os.mmap(0L, size, OsConstants.PROT_READ, OsConstants.MAP_SHARED, fd, 0L);
            MemoryMappedFile memoryMappedFile = new MemoryMappedFile(address, size);
            return memoryMappedFile;
        }
        finally {
            Libcore.os.close(fd);
        }
    }

    @Override
    public void close() throws ErrnoException {
        if (!this.closed) {
            this.closed = true;
            Libcore.os.munmap(this.address, this.size);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    @UnsupportedAppUsage
    public BufferIterator bigEndianIterator() {
        return new NioBufferIterator(this, this.address, this.size, ByteOrder.nativeOrder() != ByteOrder.BIG_ENDIAN);
    }

    public BufferIterator littleEndianIterator() {
        return new NioBufferIterator(this, this.address, this.size, ByteOrder.nativeOrder() != ByteOrder.LITTLE_ENDIAN);
    }

    void checkNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("MemoryMappedFile is closed");
        }
    }

    public int size() {
        this.checkNotClosed();
        return this.size;
    }
}

