/*
 * Decompiled with CFR 0.152.
 */
package libcore.net;

import dalvik.annotation.compat.UnsupportedAppUsage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;

public final class MimeUtils {
    private static final Pattern splitPattern = Pattern.compile("\\s+");
    private static final Map<String, String> mimeTypeToExtensionMap = new HashMap<String, String>();
    private static final Map<String, String> extensionToMimeTypeMap = new HashMap<String, String>();

    private static void parseTypes(String resource) {
        try (BufferedReader r = new BufferedReader(new InputStreamReader(MimeUtils.class.getResourceAsStream(resource)));){
            String line;
            while ((line = r.readLine()) != null) {
                int commentPos = line.indexOf(35);
                if (commentPos >= 0) {
                    line = line.substring(0, commentPos);
                }
                if ((line = line.trim()).equals("")) continue;
                String[] split = splitPattern.split(line);
                String mimeType = MimeUtils.canonicalize(split[0]);
                if (!MimeUtils.allowedInMap(mimeType)) {
                    throw new IllegalArgumentException("Invalid mimeType " + mimeType + " in: " + line);
                }
                for (int i = 1; i < split.length; ++i) {
                    String extension = MimeUtils.canonicalize(split[i]);
                    if (!MimeUtils.allowedInMap(extension)) {
                        throw new IllegalArgumentException("Invalid extension " + extension + " in: " + line);
                    }
                    if (extension.endsWith("!")) {
                        extension = extension.substring(0, extension.length() - 1);
                        mimeTypeToExtensionMap.put(mimeType, extension);
                    } else if (!mimeTypeToExtensionMap.containsKey(mimeType)) {
                        mimeTypeToExtensionMap.put(mimeType, extension);
                    }
                    extensionToMimeTypeMap.put(extension, mimeType);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse " + resource, e);
        }
    }

    private MimeUtils() {
    }

    private static String canonicalize(String s) {
        return s.toLowerCase(Locale.ROOT);
    }

    private static boolean allowedInMap(String s) {
        return s != null && !s.isEmpty();
    }

    public static boolean hasMimeType(String mimeType) {
        return MimeUtils.guessExtensionFromMimeType(mimeType) != null;
    }

    @UnsupportedAppUsage
    public static String guessMimeTypeFromExtension(String extension) {
        if (!MimeUtils.allowedInMap(extension)) {
            return null;
        }
        extension = MimeUtils.canonicalize(extension);
        return extensionToMimeTypeMap.get(extension);
    }

    public static boolean hasExtension(String extension) {
        return MimeUtils.guessMimeTypeFromExtension(extension) != null;
    }

    @UnsupportedAppUsage
    public static String guessExtensionFromMimeType(String mimeType) {
        if (!MimeUtils.allowedInMap(mimeType)) {
            return null;
        }
        mimeType = MimeUtils.canonicalize(mimeType);
        return mimeTypeToExtensionMap.get(mimeType);
    }

    static {
        MimeUtils.parseTypes("mime.types");
        MimeUtils.parseTypes("android.mime.types");
    }
}

