/*
 * Decompiled with CFR 0.152.
 */
package libcore.reflect;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;
import libcore.reflect.ListOfTypes;

public final class ParameterizedTypeImpl
implements ParameterizedType {
    private final ListOfTypes args;
    private final ParameterizedTypeImpl ownerType0;
    private Type ownerTypeRes;
    private Class rawType;
    private final String rawTypeName;
    private final ClassLoader loader;

    public ParameterizedTypeImpl(ParameterizedTypeImpl ownerType, String rawTypeName, ListOfTypes args, ClassLoader loader) {
        if (args == null) {
            throw new NullPointerException();
        }
        this.ownerType0 = ownerType;
        this.rawTypeName = rawTypeName;
        this.args = args;
        this.loader = loader;
    }

    @Override
    public Type[] getActualTypeArguments() {
        return (Type[])this.args.getResolvedTypes().clone();
    }

    @Override
    public Type getOwnerType() {
        if (this.ownerTypeRes == null) {
            this.ownerTypeRes = this.ownerType0 != null ? this.ownerType0.getResolvedType() : this.getRawType().getDeclaringClass();
        }
        return this.ownerTypeRes;
    }

    @Override
    public Class getRawType() {
        if (this.rawType == null) {
            try {
                this.rawType = Class.forName(this.rawTypeName, false, this.loader);
            }
            catch (ClassNotFoundException e) {
                throw new TypeNotPresentException(this.rawTypeName, e);
            }
        }
        return this.rawType;
    }

    Type getResolvedType() {
        if (this.args.getResolvedTypes().length == 0) {
            return this.getRawType();
        }
        return this;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType that = (ParameterizedType)o;
        return Objects.equals(this.getRawType(), that.getRawType()) && Objects.equals(this.getOwnerType(), that.getOwnerType()) && Arrays.equals(this.args.getResolvedTypes(), that.getActualTypeArguments());
    }

    public int hashCode() {
        return 31 * (31 * Objects.hashCode(this.getRawType()) + Objects.hashCode(this.getOwnerType())) + Arrays.hashCode(this.args.getResolvedTypes());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.rawTypeName);
        if (this.args.length() > 0) {
            sb.append("<").append(this.args).append(">");
        }
        return sb.toString();
    }
}

