/*
 * Decompiled with CFR 0.152.
 */
package libcore.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import libcore.reflect.ListOfTypes;

public final class TypeVariableImpl<D extends GenericDeclaration>
implements TypeVariable<D> {
    private TypeVariableImpl<D> formalVar;
    private final GenericDeclaration declOfVarUser;
    private final String name;
    private D genericDeclaration;
    private ListOfTypes bounds;

    public boolean equals(Object o) {
        if (!(o instanceof TypeVariable)) {
            return false;
        }
        TypeVariable that = (TypeVariable)o;
        return this.getName().equals(that.getName()) && this.getGenericDeclaration().equals(that.getGenericDeclaration());
    }

    public int hashCode() {
        return 31 * this.getName().hashCode() + this.getGenericDeclaration().hashCode();
    }

    TypeVariableImpl(D genericDecl, String name, ListOfTypes bounds) {
        this.genericDeclaration = genericDecl;
        this.name = name;
        this.bounds = bounds;
        this.formalVar = this;
        this.declOfVarUser = null;
    }

    TypeVariableImpl(D genericDecl, String name) {
        this.name = name;
        this.declOfVarUser = genericDecl;
    }

    static TypeVariable findFormalVar(GenericDeclaration layer, String name) {
        TypeVariable<?>[] formalVars;
        for (TypeVariable<?> var : formalVars = layer.getTypeParameters()) {
            if (!name.equals(var.getName())) continue;
            return var;
        }
        return null;
    }

    private static GenericDeclaration nextLayer(GenericDeclaration decl) {
        if (decl instanceof Class) {
            Class cl = (Class)decl;
            Method m = cl.getEnclosingMethod();
            GenericDeclaration genericDeclaration = decl = m != null ? m : cl.getEnclosingConstructor();
            if (decl != null) {
                return decl;
            }
            return cl.getEnclosingClass();
        }
        if (decl instanceof Method) {
            return ((Method)decl).getDeclaringClass();
        }
        if (decl instanceof Constructor) {
            return ((Constructor)decl).getDeclaringClass();
        }
        throw new AssertionError();
    }

    void resolve() {
        TypeVariable var;
        if (this.formalVar != null) {
            return;
        }
        GenericDeclaration curLayer = this.declOfVarUser;
        while ((var = TypeVariableImpl.findFormalVar(curLayer, this.name)) == null) {
            if ((curLayer = TypeVariableImpl.nextLayer(curLayer)) == null) {
                throw new AssertionError((Object)"illegal type variable reference");
            }
        }
        this.formalVar = (TypeVariableImpl)var;
        this.genericDeclaration = this.formalVar.genericDeclaration;
        this.bounds = this.formalVar.bounds;
    }

    @Override
    public Type[] getBounds() {
        this.resolve();
        return (Type[])this.bounds.getResolvedTypes().clone();
    }

    @Override
    public D getGenericDeclaration() {
        this.resolve();
        return this.genericDeclaration;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }
}

