/*
 * Decompiled with CFR 0.152.
 */
package libcore.reflect;

import java.lang.reflect.MalformedParameterizedTypeException;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import libcore.reflect.ListOfTypes;

public final class WildcardTypeImpl
implements WildcardType {
    private final ListOfTypes extendsBound;
    private final ListOfTypes superBound;

    public WildcardTypeImpl(ListOfTypes extendsBound, ListOfTypes superBound) {
        this.extendsBound = extendsBound;
        this.superBound = superBound;
    }

    @Override
    public Type[] getLowerBounds() throws TypeNotPresentException, MalformedParameterizedTypeException {
        return (Type[])this.superBound.getResolvedTypes().clone();
    }

    @Override
    public Type[] getUpperBounds() throws TypeNotPresentException, MalformedParameterizedTypeException {
        return (Type[])this.extendsBound.getResolvedTypes().clone();
    }

    public boolean equals(Object o) {
        if (!(o instanceof WildcardType)) {
            return false;
        }
        WildcardType that = (WildcardType)o;
        return Arrays.equals(this.getLowerBounds(), that.getLowerBounds()) && Arrays.equals(this.getUpperBounds(), that.getUpperBounds());
    }

    public int hashCode() {
        return 31 * Arrays.hashCode(this.getLowerBounds()) + Arrays.hashCode(this.getUpperBounds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("?");
        if (this.extendsBound.length() == 1 && this.extendsBound.getResolvedTypes()[0] != Object.class || this.extendsBound.length() > 1) {
            sb.append(" extends ").append(this.extendsBound);
        } else if (this.superBound.length() > 0) {
            sb.append(" super ").append(this.superBound);
        }
        return sb.toString();
    }
}

