/*
 * Decompiled with CFR 0.152.
 */
package libcore.timezone;

import android.icu.util.TimeZone;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import libcore.timezone.ZoneInfoDB;

public final class CountryTimeZones {
    private final String countryIso;
    private final String defaultTimeZoneId;
    private final List<TimeZoneMapping> timeZoneMappings;
    private final boolean everUsesUtc;
    private TimeZone icuDefaultTimeZone;
    private List<TimeZone> icuTimeZones;

    private CountryTimeZones(String countryIso, String defaultTimeZoneId, boolean everUsesUtc, List<TimeZoneMapping> timeZoneMappings) {
        this.countryIso = Objects.requireNonNull(countryIso);
        this.defaultTimeZoneId = defaultTimeZoneId;
        this.everUsesUtc = everUsesUtc;
        this.timeZoneMappings = Collections.unmodifiableList(new ArrayList<TimeZoneMapping>(timeZoneMappings));
    }

    public static CountryTimeZones createValidated(String countryIso, String defaultTimeZoneId, boolean everUsesUtc, List<TimeZoneMapping> timeZoneMappings, String debugInfo) {
        String[] validTimeZoneIdsArray = ZoneInfoDB.getInstance().getAvailableIDs();
        HashSet<String> validTimeZoneIdsSet = new HashSet<String>(Arrays.asList(validTimeZoneIdsArray));
        ArrayList<TimeZoneMapping> validCountryTimeZoneMappings = new ArrayList<TimeZoneMapping>();
        for (TimeZoneMapping timeZoneMapping : timeZoneMappings) {
            String timeZoneId = timeZoneMapping.timeZoneId;
            if (!validTimeZoneIdsSet.contains(timeZoneId)) {
                System.logW((String)("Skipping invalid zone: " + timeZoneId + " at " + debugInfo));
                continue;
            }
            validCountryTimeZoneMappings.add(timeZoneMapping);
        }
        if (!validTimeZoneIdsSet.contains(defaultTimeZoneId)) {
            System.logW((String)("Invalid default time zone ID: " + defaultTimeZoneId + " at " + debugInfo));
            defaultTimeZoneId = null;
        }
        String normalizedCountryIso = CountryTimeZones.normalizeCountryIso(countryIso);
        return new CountryTimeZones(normalizedCountryIso, defaultTimeZoneId, everUsesUtc, validCountryTimeZoneMappings);
    }

    public String getCountryIso() {
        return this.countryIso;
    }

    public boolean isForCountryCode(String countryIso) {
        return this.countryIso.equals(CountryTimeZones.normalizeCountryIso(countryIso));
    }

    public synchronized TimeZone getDefaultTimeZone() {
        if (this.icuDefaultTimeZone == null) {
            TimeZone defaultTimeZone = this.defaultTimeZoneId == null ? null : CountryTimeZones.getValidFrozenTimeZoneOrNull(this.defaultTimeZoneId);
            this.icuDefaultTimeZone = defaultTimeZone;
        }
        return this.icuDefaultTimeZone;
    }

    public String getDefaultTimeZoneId() {
        return this.defaultTimeZoneId;
    }

    public List<TimeZoneMapping> getTimeZoneMappings() {
        return this.timeZoneMappings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CountryTimeZones that = (CountryTimeZones)o;
        if (this.everUsesUtc != that.everUsesUtc) {
            return false;
        }
        if (!this.countryIso.equals(that.countryIso)) {
            return false;
        }
        if (this.defaultTimeZoneId != null ? !this.defaultTimeZoneId.equals(that.defaultTimeZoneId) : that.defaultTimeZoneId != null) {
            return false;
        }
        return this.timeZoneMappings.equals(that.timeZoneMappings);
    }

    public int hashCode() {
        int result = this.countryIso.hashCode();
        result = 31 * result + (this.defaultTimeZoneId != null ? this.defaultTimeZoneId.hashCode() : 0);
        result = 31 * result + this.timeZoneMappings.hashCode();
        result = 31 * result + (this.everUsesUtc ? 1 : 0);
        return result;
    }

    public synchronized List<TimeZone> getIcuTimeZones() {
        if (this.icuTimeZones == null) {
            ArrayList<TimeZone> mutableList = new ArrayList<TimeZone>(this.timeZoneMappings.size());
            for (TimeZoneMapping timeZoneMapping : this.timeZoneMappings) {
                String timeZoneId = timeZoneMapping.timeZoneId;
                TimeZone timeZone = timeZoneId.equals(this.defaultTimeZoneId) ? this.getDefaultTimeZone() : CountryTimeZones.getValidFrozenTimeZoneOrNull(timeZoneId);
                if (timeZone == null) {
                    System.logW((String)("Skipping invalid zone: " + timeZoneId));
                    continue;
                }
                mutableList.add(timeZone);
            }
            this.icuTimeZones = Collections.unmodifiableList(mutableList);
        }
        return this.icuTimeZones;
    }

    public boolean hasUtcZone(long whenMillis) {
        if (!this.everUsesUtc) {
            return false;
        }
        for (TimeZone zone : this.getIcuTimeZones()) {
            if (zone.getOffset(whenMillis) != 0) continue;
            return true;
        }
        return false;
    }

    public boolean isDefaultOkForCountryTimeZoneDetection(long whenMillis) {
        if (this.timeZoneMappings.isEmpty()) {
            return false;
        }
        if (this.timeZoneMappings.size() == 1) {
            return true;
        }
        TimeZone countryDefault = this.getDefaultTimeZone();
        if (countryDefault == null) {
            return false;
        }
        int countryDefaultOffset = countryDefault.getOffset(whenMillis);
        List<TimeZone> candidates = this.getIcuTimeZones();
        for (TimeZone candidate : candidates) {
            int candidateOffset;
            if (candidate == countryDefault || countryDefaultOffset == (candidateOffset = candidate.getOffset(whenMillis))) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public OffsetResult lookupByOffsetWithBias(int offsetMillis, boolean isDst, long whenMillis, TimeZone bias) {
        if (this.timeZoneMappings == null || this.timeZoneMappings.isEmpty()) {
            return null;
        }
        List<TimeZone> candidates = this.getIcuTimeZones();
        TimeZone firstMatch = null;
        boolean biasMatched = false;
        boolean oneMatch = true;
        for (TimeZone match : candidates) {
            if (!CountryTimeZones.offsetMatchesAtTime(match, offsetMillis, isDst, whenMillis)) continue;
            if (firstMatch == null) {
                firstMatch = match;
            } else {
                oneMatch = false;
            }
            if (bias != null && match.getID().equals(bias.getID())) {
                biasMatched = true;
            }
            if (firstMatch == null || oneMatch || bias != null && !biasMatched) continue;
            break;
        }
        if (firstMatch == null) {
            return null;
        }
        TimeZone toReturn = biasMatched ? bias : firstMatch;
        return new OffsetResult(toReturn, oneMatch);
    }

    private static boolean offsetMatchesAtTime(TimeZone timeZone, int offsetMillis, boolean isDst, long whenMillis) {
        boolean zoneIsDst;
        int[] offsets = new int[2];
        timeZone.getOffset(whenMillis, false, offsets);
        boolean bl = zoneIsDst = offsets[1] != 0;
        if (isDst != zoneIsDst) {
            return false;
        }
        return offsetMillis == offsets[0] + offsets[1];
    }

    public OffsetResult lookupByOffsetWithBias(int offsetMillis, Integer dstOffsetMillis, long whenMillis, TimeZone bias) {
        if (this.timeZoneMappings == null || this.timeZoneMappings.isEmpty()) {
            return null;
        }
        List<TimeZone> candidates = this.getIcuTimeZones();
        TimeZone firstMatch = null;
        boolean biasMatched = false;
        boolean oneMatch = true;
        for (TimeZone match : candidates) {
            if (!CountryTimeZones.offsetMatchesAtTime(match, offsetMillis, dstOffsetMillis, whenMillis)) continue;
            if (firstMatch == null) {
                firstMatch = match;
            } else {
                oneMatch = false;
            }
            if (bias != null && match.getID().equals(bias.getID())) {
                biasMatched = true;
            }
            if (firstMatch == null || oneMatch || bias != null && !biasMatched) continue;
            break;
        }
        if (firstMatch == null) {
            return null;
        }
        TimeZone toReturn = biasMatched ? bias : firstMatch;
        return new OffsetResult(toReturn, oneMatch);
    }

    private static boolean offsetMatchesAtTime(TimeZone timeZone, int offsetMillis, Integer dstOffsetMillis, long whenMillis) {
        int[] offsets = new int[2];
        timeZone.getOffset(whenMillis, false, offsets);
        if (dstOffsetMillis != null && dstOffsetMillis != offsets[1]) {
            return false;
        }
        return offsetMillis == offsets[0] + offsets[1];
    }

    private static TimeZone getValidFrozenTimeZoneOrNull(String timeZoneId) {
        TimeZone timeZone = TimeZone.getFrozenTimeZone(timeZoneId);
        if (timeZone.getID().equals("Etc/Unknown")) {
            return null;
        }
        return timeZone;
    }

    private static String normalizeCountryIso(String countryIso) {
        return countryIso.toLowerCase(Locale.US);
    }

    public static final class TimeZoneMapping {
        public final String timeZoneId;
        public final boolean showInPicker;
        public final Long notUsedAfter;

        TimeZoneMapping(String timeZoneId, boolean showInPicker, Long notUsedAfter) {
            this.timeZoneId = timeZoneId;
            this.showInPicker = showInPicker;
            this.notUsedAfter = notUsedAfter;
        }

        public static TimeZoneMapping createForTests(String timeZoneId, boolean showInPicker, Long notUsedAfter) {
            return new TimeZoneMapping(timeZoneId, showInPicker, notUsedAfter);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TimeZoneMapping that = (TimeZoneMapping)o;
            return this.showInPicker == that.showInPicker && Objects.equals(this.timeZoneId, that.timeZoneId) && Objects.equals(this.notUsedAfter, that.notUsedAfter);
        }

        public int hashCode() {
            return Objects.hash(this.timeZoneId, this.showInPicker, this.notUsedAfter);
        }

        public String toString() {
            return "TimeZoneMapping{timeZoneId='" + this.timeZoneId + '\'' + ", showInPicker=" + this.showInPicker + ", notUsedAfter=" + this.notUsedAfter + '}';
        }

        public static boolean containsTimeZoneId(List<TimeZoneMapping> timeZoneMappings, String timeZoneId) {
            for (TimeZoneMapping timeZoneMapping : timeZoneMappings) {
                if (!timeZoneMapping.timeZoneId.equals(timeZoneId)) continue;
                return true;
            }
            return false;
        }
    }

    public static final class OffsetResult {
        public final TimeZone mTimeZone;
        public final boolean mOneMatch;

        public OffsetResult(TimeZone timeZone, boolean oneMatch) {
            this.mTimeZone = Objects.requireNonNull(timeZone);
            this.mOneMatch = oneMatch;
        }

        public String toString() {
            return "Result{mTimeZone='" + this.mTimeZone + '\'' + ", mOneMatch=" + this.mOneMatch + '}';
        }
    }
}

