/*
 * Decompiled with CFR 0.152.
 */
package libcore.timezone;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import libcore.timezone.CountryTimeZones;
import libcore.timezone.TimeZoneFinder;

public final class CountryZonesFinder {
    private final List<CountryTimeZones> countryTimeZonesList;

    CountryZonesFinder(List<CountryTimeZones> countryTimeZonesList) {
        this.countryTimeZonesList = new ArrayList<CountryTimeZones>(countryTimeZonesList);
    }

    public static CountryZonesFinder createForTests(List<CountryTimeZones> countryTimeZonesList) {
        return new CountryZonesFinder(countryTimeZonesList);
    }

    public List<String> lookupAllCountryIsoCodes() {
        ArrayList<String> isoCodes = new ArrayList<String>(this.countryTimeZonesList.size());
        for (CountryTimeZones countryTimeZones : this.countryTimeZonesList) {
            isoCodes.add(countryTimeZones.getCountryIso());
        }
        return Collections.unmodifiableList(isoCodes);
    }

    public List<CountryTimeZones> lookupCountryTimeZonesForZoneId(String zoneId) {
        ArrayList<CountryTimeZones> matches = new ArrayList<CountryTimeZones>(2);
        for (CountryTimeZones countryTimeZones : this.countryTimeZonesList) {
            boolean match = CountryTimeZones.TimeZoneMapping.containsTimeZoneId(countryTimeZones.getTimeZoneMappings(), zoneId);
            if (!match) continue;
            matches.add(countryTimeZones);
        }
        return Collections.unmodifiableList(matches);
    }

    public CountryTimeZones lookupCountryTimeZones(String countryIso) {
        String normalizedCountryIso = TimeZoneFinder.normalizeCountryIso(countryIso);
        for (CountryTimeZones countryTimeZones : this.countryTimeZonesList) {
            if (!countryTimeZones.getCountryIso().equals(normalizedCountryIso)) continue;
            return countryTimeZones;
        }
        return null;
    }
}

