/*
 * Decompiled with CFR 0.152.
 */
package libcore.timezone;

import java.util.ArrayList;

public final class TimeZoneDataFiles {
    private static final String ANDROID_ROOT_ENV = "ANDROID_ROOT";
    private static final String ANDROID_RUNTIME_ROOT_ENV = "ANDROID_RUNTIME_ROOT";
    private static final String ANDROID_TZDATA_ROOT_ENV = "ANDROID_TZDATA_ROOT";
    private static final String ANDROID_DATA_ENV = "ANDROID_DATA";

    private TimeZoneDataFiles() {
    }

    public static String[] getTimeZoneFilePaths(String fileName) {
        return new String[]{TimeZoneDataFiles.getDataTimeZoneFile(fileName), TimeZoneDataFiles.getTimeZoneModuleFile("tz/" + fileName), TimeZoneDataFiles.getRuntimeModuleFile("tz/" + fileName), TimeZoneDataFiles.getSystemTimeZoneFile(fileName)};
    }

    public static String getDataTimeZoneRootDir() {
        return System.getenv(ANDROID_DATA_ENV) + "/misc/zoneinfo/";
    }

    public static String getDataTimeZoneFile(String fileName) {
        return TimeZoneDataFiles.getDataTimeZoneRootDir() + "current/" + fileName;
    }

    public static String getTimeZoneModuleFile(String fileName) {
        return System.getenv(ANDROID_TZDATA_ROOT_ENV) + "/etc/" + fileName;
    }

    public static String getRuntimeModuleTzVersionFile() {
        return TimeZoneDataFiles.getRuntimeModuleFile("tz/tz_version");
    }

    public static String getRuntimeModuleFile(String fileName) {
        return System.getenv(ANDROID_RUNTIME_ROOT_ENV) + "/etc/" + fileName;
    }

    public static String getSystemTimeZoneFile(String fileName) {
        return TimeZoneDataFiles.getEnvironmentPath(ANDROID_ROOT_ENV, "/usr/share/zoneinfo/" + fileName);
    }

    public static String getSystemIcuFile(String fileName) {
        return TimeZoneDataFiles.getEnvironmentPath(ANDROID_ROOT_ENV, "/usr/icu/" + fileName);
    }

    public static String generateIcuDataPath() {
        String runtimeModuleIcuDataPath;
        String timeZoneModuleIcuDataPath;
        ArrayList<String> paths = new ArrayList<String>(3);
        String dataIcuDataPath = TimeZoneDataFiles.getEnvironmentPath(ANDROID_DATA_ENV, "/misc/zoneinfo/current/icu/");
        if (dataIcuDataPath != null) {
            paths.add(dataIcuDataPath);
        }
        if ((timeZoneModuleIcuDataPath = TimeZoneDataFiles.getTimeZoneModuleFile("icu/")) != null) {
            paths.add(timeZoneModuleIcuDataPath);
        }
        if ((runtimeModuleIcuDataPath = TimeZoneDataFiles.getRuntimeModuleFile("icu/")) != null) {
            paths.add(runtimeModuleIcuDataPath);
        }
        return String.join((CharSequence)":", paths);
    }

    private static String getEnvironmentPath(String environmentVariable, String path) {
        String variable = System.getenv(environmentVariable);
        if (variable == null) {
            return null;
        }
        return variable + path;
    }
}

