/*
 * Decompiled with CFR 0.152.
 */
package libcore.timezone;

import android.icu.util.TimeZone;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import libcore.timezone.CountryTimeZones;
import libcore.timezone.CountryZonesFinder;
import libcore.timezone.TimeZoneDataFiles;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public final class TimeZoneFinder {
    private static final String TZLOOKUP_FILE_NAME = "tzlookup.xml";
    private static final String TIMEZONES_ELEMENT = "timezones";
    private static final String IANA_VERSION_ATTRIBUTE = "ianaversion";
    private static final String COUNTRY_ZONES_ELEMENT = "countryzones";
    private static final String COUNTRY_ELEMENT = "country";
    private static final String COUNTRY_CODE_ATTRIBUTE = "code";
    private static final String DEFAULT_TIME_ZONE_ID_ATTRIBUTE = "default";
    private static final String EVER_USES_UTC_ATTRIBUTE = "everutc";
    private static final String ZONE_ID_ELEMENT = "id";
    private static final String ZONE_SHOW_IN_PICKER_ATTRIBUTE = "picker";
    private static final String ZONE_NOT_USED_AFTER_ATTRIBUTE = "notafter";
    private static final String TRUE_ATTRIBUTE_VALUE = "y";
    private static final String FALSE_ATTRIBUTE_VALUE = "n";
    private static TimeZoneFinder instance;
    private final ReaderSupplier xmlSource;
    private CountryTimeZones lastCountryTimeZones;

    private TimeZoneFinder(ReaderSupplier xmlSource) {
        this.xmlSource = xmlSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimeZoneFinder getInstance() {
        Class<TimeZoneFinder> clazz = TimeZoneFinder.class;
        synchronized (TimeZoneFinder.class) {
            if (instance == null) {
                String[] tzLookupFilePaths = TimeZoneDataFiles.getTimeZoneFilePaths(TZLOOKUP_FILE_NAME);
                instance = TimeZoneFinder.createInstanceWithFallback(tzLookupFilePaths);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static TimeZoneFinder createInstanceWithFallback(String ... tzLookupFilePaths) {
        IOException lastException = null;
        for (String tzLookupFilePath : tzLookupFilePaths) {
            try {
                return TimeZoneFinder.createInstance(tzLookupFilePath);
            }
            catch (IOException e) {
                if (lastException != null) {
                    e.addSuppressed(lastException);
                }
                lastException = e;
            }
        }
        System.logE((String)("No valid file found in set: " + Arrays.toString(tzLookupFilePaths) + " Printing exceptions and falling back to empty map."), (Throwable)lastException);
        return TimeZoneFinder.createInstanceForTests("<timezones><countryzones /></timezones>");
    }

    public static TimeZoneFinder createInstance(String path) throws IOException {
        ReaderSupplier xmlSupplier = ReaderSupplier.forFile(path, StandardCharsets.UTF_8);
        return new TimeZoneFinder(xmlSupplier);
    }

    public static TimeZoneFinder createInstanceForTests(String xml2) {
        return new TimeZoneFinder(ReaderSupplier.forString(xml2));
    }

    public void validate() throws IOException {
        try {
            this.processXml(new TimeZonesValidator());
        }
        catch (XmlPullParserException e) {
            throw new IOException("Parsing error", e);
        }
    }

    public String getIanaVersion() {
        IanaVersionExtractor ianaVersionExtractor = new IanaVersionExtractor();
        try {
            this.processXml(ianaVersionExtractor);
            return ianaVersionExtractor.getIanaVersion();
        }
        catch (IOException | XmlPullParserException e) {
            return null;
        }
    }

    public CountryZonesFinder getCountryZonesFinder() {
        CountryZonesLookupExtractor extractor = new CountryZonesLookupExtractor();
        try {
            this.processXml(extractor);
            return extractor.getCountryZonesLookup();
        }
        catch (IOException | XmlPullParserException e) {
            System.logW((String)"Error reading country zones ", (Throwable)e);
            return null;
        }
    }

    public TimeZone lookupTimeZoneByCountryAndOffset(String countryIso, int offsetMillis, boolean isDst, long whenMillis, TimeZone bias) {
        CountryTimeZones countryTimeZones = this.lookupCountryTimeZones(countryIso);
        if (countryTimeZones == null) {
            return null;
        }
        CountryTimeZones.OffsetResult offsetResult = countryTimeZones.lookupByOffsetWithBias(offsetMillis, isDst, whenMillis, bias);
        return offsetResult != null ? offsetResult.mTimeZone : null;
    }

    public String lookupDefaultTimeZoneIdByCountry(String countryIso) {
        CountryTimeZones countryTimeZones = this.lookupCountryTimeZones(countryIso);
        return countryTimeZones == null ? null : countryTimeZones.getDefaultTimeZoneId();
    }

    public List<TimeZone> lookupTimeZonesByCountry(String countryIso) {
        CountryTimeZones countryTimeZones = this.lookupCountryTimeZones(countryIso);
        return countryTimeZones == null ? null : countryTimeZones.getIcuTimeZones();
    }

    public List<String> lookupTimeZoneIdsByCountry(String countryIso) {
        CountryTimeZones countryTimeZones = this.lookupCountryTimeZones(countryIso);
        return countryTimeZones == null ? null : TimeZoneFinder.extractTimeZoneIds(countryTimeZones.getTimeZoneMappings());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CountryTimeZones lookupCountryTimeZones(String countryIso) {
        TimeZoneFinder timeZoneFinder = this;
        synchronized (timeZoneFinder) {
            if (this.lastCountryTimeZones != null && this.lastCountryTimeZones.isForCountryCode(countryIso)) {
                return this.lastCountryTimeZones;
            }
        }
        SelectiveCountryTimeZonesExtractor extractor = new SelectiveCountryTimeZonesExtractor(countryIso);
        try {
            this.processXml(extractor);
            CountryTimeZones countryTimeZones = extractor.getValidatedCountryTimeZones();
            if (countryTimeZones == null) {
                return null;
            }
            TimeZoneFinder timeZoneFinder2 = this;
            synchronized (timeZoneFinder2) {
                this.lastCountryTimeZones = countryTimeZones;
            }
            return countryTimeZones;
        }
        catch (IOException | XmlPullParserException e) {
            System.logW((String)"Error reading country zones ", (Throwable)e);
            return null;
        }
    }

    private void processXml(TimeZonesProcessor processor) throws XmlPullParserException, IOException {
        try (Reader reader = this.xmlSource.get();){
            XmlPullParserFactory xmlPullParserFactory = XmlPullParserFactory.newInstance();
            xmlPullParserFactory.setNamespaceAware(false);
            XmlPullParser parser = xmlPullParserFactory.newPullParser();
            parser.setInput(reader);
            TimeZoneFinder.findRequiredStartTag(parser, TIMEZONES_ELEMENT);
            String ianaVersion = parser.getAttributeValue(null, IANA_VERSION_ATTRIBUTE);
            if (!processor.processHeader(ianaVersion)) {
                return;
            }
            TimeZoneFinder.findRequiredStartTag(parser, COUNTRY_ZONES_ELEMENT);
            if (!TimeZoneFinder.processCountryZones(parser, processor)) {
                return;
            }
            TimeZoneFinder.checkOnEndTag(parser, COUNTRY_ZONES_ELEMENT);
            parser.next();
            TimeZoneFinder.consumeUntilEndTag(parser, TIMEZONES_ELEMENT);
            TimeZoneFinder.checkOnEndTag(parser, TIMEZONES_ELEMENT);
        }
    }

    private static boolean processCountryZones(XmlPullParser parser, TimeZonesProcessor processor) throws IOException, XmlPullParserException {
        while (TimeZoneFinder.findOptionalStartTag(parser, COUNTRY_ELEMENT)) {
            if (processor == null) {
                TimeZoneFinder.consumeUntilEndTag(parser, COUNTRY_ELEMENT);
            } else {
                String code = parser.getAttributeValue(null, COUNTRY_CODE_ATTRIBUTE);
                if (code == null || code.isEmpty()) {
                    throw new XmlPullParserException("Unable to find country code: " + parser.getPositionDescription());
                }
                String defaultTimeZoneId = parser.getAttributeValue(null, DEFAULT_TIME_ZONE_ID_ATTRIBUTE);
                if (defaultTimeZoneId == null || defaultTimeZoneId.isEmpty()) {
                    throw new XmlPullParserException("Unable to find default time zone ID: " + parser.getPositionDescription());
                }
                Boolean everUsesUtc = TimeZoneFinder.parseBooleanAttribute(parser, EVER_USES_UTC_ATTRIBUTE, null);
                if (everUsesUtc == null) {
                    throw new XmlPullParserException("Unable to find UTC hint attribute (everutc): " + parser.getPositionDescription());
                }
                String debugInfo = parser.getPositionDescription();
                List<CountryTimeZones.TimeZoneMapping> timeZoneMappings = TimeZoneFinder.parseTimeZoneMappings(parser);
                boolean result = processor.processCountryZones(code, defaultTimeZoneId, everUsesUtc, timeZoneMappings, debugInfo);
                if (!result) {
                    return false;
                }
            }
            TimeZoneFinder.checkOnEndTag(parser, COUNTRY_ELEMENT);
        }
        return true;
    }

    private static List<CountryTimeZones.TimeZoneMapping> parseTimeZoneMappings(XmlPullParser parser) throws IOException, XmlPullParserException {
        ArrayList<CountryTimeZones.TimeZoneMapping> timeZoneMappings = new ArrayList<CountryTimeZones.TimeZoneMapping>();
        while (TimeZoneFinder.findOptionalStartTag(parser, ZONE_ID_ELEMENT)) {
            boolean showInPicker = TimeZoneFinder.parseBooleanAttribute(parser, ZONE_SHOW_IN_PICKER_ATTRIBUTE, true);
            Long notUsedAfter = TimeZoneFinder.parseLongAttribute(parser, ZONE_NOT_USED_AFTER_ATTRIBUTE, null);
            String zoneIdString = TimeZoneFinder.consumeText(parser);
            TimeZoneFinder.checkOnEndTag(parser, ZONE_ID_ELEMENT);
            if (zoneIdString == null || zoneIdString.length() == 0) {
                throw new XmlPullParserException("Missing text for id): " + parser.getPositionDescription());
            }
            CountryTimeZones.TimeZoneMapping timeZoneMapping = new CountryTimeZones.TimeZoneMapping(zoneIdString, showInPicker, notUsedAfter);
            timeZoneMappings.add(timeZoneMapping);
        }
        return Collections.unmodifiableList(timeZoneMappings);
    }

    private static Long parseLongAttribute(XmlPullParser parser, String attributeName, Long defaultValue) throws XmlPullParserException {
        String attributeValueString = parser.getAttributeValue(null, attributeName);
        if (attributeValueString == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(attributeValueString);
        }
        catch (NumberFormatException e) {
            throw new XmlPullParserException("Attribute \"" + attributeName + "\" is not a long value: " + parser.getPositionDescription());
        }
    }

    private static Boolean parseBooleanAttribute(XmlPullParser parser, String attributeName, Boolean defaultValue) throws XmlPullParserException {
        String attributeValueString = parser.getAttributeValue(null, attributeName);
        if (attributeValueString == null) {
            return defaultValue;
        }
        boolean isTrue = TRUE_ATTRIBUTE_VALUE.equals(attributeValueString);
        if (!isTrue && !FALSE_ATTRIBUTE_VALUE.equals(attributeValueString)) {
            throw new XmlPullParserException("Attribute \"" + attributeName + "\" is not \"y\" or \"n\": " + parser.getPositionDescription());
        }
        return isTrue;
    }

    private static void findRequiredStartTag(XmlPullParser parser, String elementName) throws IOException, XmlPullParserException {
        TimeZoneFinder.findStartTag(parser, elementName, true);
    }

    private static boolean findOptionalStartTag(XmlPullParser parser, String elementName) throws IOException, XmlPullParserException {
        return TimeZoneFinder.findStartTag(parser, elementName, false);
    }

    private static boolean findStartTag(XmlPullParser parser, String elementName, boolean elementRequired) throws IOException, XmlPullParserException {
        int type;
        block4: while ((type = parser.next()) != 1) {
            switch (type) {
                case 2: {
                    String currentElementName = parser.getName();
                    if (elementName.equals(currentElementName)) {
                        return true;
                    }
                    parser.next();
                    TimeZoneFinder.consumeUntilEndTag(parser, currentElementName);
                    continue block4;
                }
                case 3: {
                    if (elementRequired) {
                        throw new XmlPullParserException("No child element found with name " + elementName);
                    }
                    return false;
                }
            }
        }
        throw new XmlPullParserException("Unexpected end of document while looking for " + elementName);
    }

    private static void consumeUntilEndTag(XmlPullParser parser, String elementName) throws IOException, XmlPullParserException {
        if (parser.getEventType() == 3 && elementName.equals(parser.getName())) {
            return;
        }
        int requiredDepth = parser.getDepth();
        if (parser.getEventType() == 2) {
            --requiredDepth;
        }
        while (parser.getEventType() != 1) {
            int type = parser.next();
            int currentDepth = parser.getDepth();
            if (currentDepth < requiredDepth) {
                throw new XmlPullParserException("Unexpected depth while looking for end tag: " + parser.getPositionDescription());
            }
            if (currentDepth != requiredDepth || type != 3) continue;
            if (elementName.equals(parser.getName())) {
                return;
            }
            throw new XmlPullParserException("Unexpected eng tag: " + parser.getPositionDescription());
        }
        throw new XmlPullParserException("Unexpected end of document");
    }

    private static String consumeText(XmlPullParser parser) throws IOException, XmlPullParserException {
        int type = parser.next();
        if (type != 4) {
            throw new XmlPullParserException("Text not found. Found type=" + type + " at " + parser.getPositionDescription());
        }
        String text = parser.getText();
        type = parser.next();
        if (type != 3) {
            throw new XmlPullParserException("Unexpected nested tag or end of document when expecting text: type=" + type + " at " + parser.getPositionDescription());
        }
        return text;
    }

    private static void checkOnEndTag(XmlPullParser parser, String elementName) throws XmlPullParserException {
        if (parser.getEventType() != 3 || !parser.getName().equals(elementName)) {
            throw new XmlPullParserException("Unexpected tag encountered: " + parser.getPositionDescription());
        }
    }

    private static List<String> extractTimeZoneIds(List<CountryTimeZones.TimeZoneMapping> timeZoneMappings) {
        ArrayList<String> zoneIds = new ArrayList<String>(timeZoneMappings.size());
        for (CountryTimeZones.TimeZoneMapping timeZoneMapping : timeZoneMappings) {
            zoneIds.add(timeZoneMapping.timeZoneId);
        }
        return Collections.unmodifiableList(zoneIds);
    }

    static String normalizeCountryIso(String countryIso) {
        return countryIso.toLowerCase(Locale.US);
    }

    private static interface ReaderSupplier {
        public Reader get() throws IOException;

        public static ReaderSupplier forFile(String fileName, Charset charSet) throws IOException {
            Path file = Paths.get(fileName, new String[0]);
            if (!Files.exists(file, new LinkOption[0])) {
                throw new FileNotFoundException(fileName + " does not exist");
            }
            if (!Files.isRegularFile(file, new LinkOption[0]) && Files.isReadable(file)) {
                throw new IOException(fileName + " must be a regular readable file.");
            }
            return () -> Files.newBufferedReader(file, charSet);
        }

        public static ReaderSupplier forString(String xml2) {
            return () -> new StringReader(xml2);
        }
    }

    private static class SelectiveCountryTimeZonesExtractor
    implements TimeZonesProcessor {
        private final String countryCodeToMatch;
        private CountryTimeZones validatedCountryTimeZones;

        private SelectiveCountryTimeZonesExtractor(String countryCodeToMatch) {
            this.countryCodeToMatch = TimeZoneFinder.normalizeCountryIso(countryCodeToMatch);
        }

        @Override
        public boolean processCountryZones(String countryIso, String defaultTimeZoneId, boolean everUsesUtc, List<CountryTimeZones.TimeZoneMapping> timeZoneMappings, String debugInfo) {
            if (!this.countryCodeToMatch.equals(countryIso = TimeZoneFinder.normalizeCountryIso(countryIso))) {
                return true;
            }
            this.validatedCountryTimeZones = CountryTimeZones.createValidated(countryIso, defaultTimeZoneId, everUsesUtc, timeZoneMappings, debugInfo);
            return false;
        }

        CountryTimeZones getValidatedCountryTimeZones() {
            return this.validatedCountryTimeZones;
        }
    }

    private static class CountryZonesLookupExtractor
    implements TimeZonesProcessor {
        private List<CountryTimeZones> countryTimeZonesList = new ArrayList<CountryTimeZones>(250);

        private CountryZonesLookupExtractor() {
        }

        @Override
        public boolean processCountryZones(String countryIso, String defaultTimeZoneId, boolean everUsesUtc, List<CountryTimeZones.TimeZoneMapping> timeZoneMappings, String debugInfo) throws XmlPullParserException {
            CountryTimeZones countryTimeZones = CountryTimeZones.createValidated(countryIso, defaultTimeZoneId, everUsesUtc, timeZoneMappings, debugInfo);
            this.countryTimeZonesList.add(countryTimeZones);
            return true;
        }

        CountryZonesFinder getCountryZonesLookup() {
            return new CountryZonesFinder(this.countryTimeZonesList);
        }
    }

    private static class IanaVersionExtractor
    implements TimeZonesProcessor {
        private String ianaVersion;

        private IanaVersionExtractor() {
        }

        @Override
        public boolean processHeader(String ianaVersion) throws XmlPullParserException {
            this.ianaVersion = ianaVersion;
            return false;
        }

        public String getIanaVersion() {
            return this.ianaVersion;
        }
    }

    private static class TimeZonesValidator
    implements TimeZonesProcessor {
        private final Set<String> knownCountryCodes = new HashSet<String>();

        private TimeZonesValidator() {
        }

        @Override
        public boolean processCountryZones(String countryIso, String defaultTimeZoneId, boolean everUsesUtc, List<CountryTimeZones.TimeZoneMapping> timeZoneMappings, String debugInfo) throws XmlPullParserException {
            if (!TimeZoneFinder.normalizeCountryIso(countryIso).equals(countryIso)) {
                throw new XmlPullParserException("Country code: " + countryIso + " is not normalized at " + debugInfo);
            }
            if (this.knownCountryCodes.contains(countryIso)) {
                throw new XmlPullParserException("Second entry for country code: " + countryIso + " at " + debugInfo);
            }
            if (timeZoneMappings.isEmpty()) {
                throw new XmlPullParserException("No time zone IDs for country code: " + countryIso + " at " + debugInfo);
            }
            if (!CountryTimeZones.TimeZoneMapping.containsTimeZoneId(timeZoneMappings, defaultTimeZoneId)) {
                throw new XmlPullParserException("defaultTimeZoneId for country code: " + countryIso + " is not one of the zones " + timeZoneMappings + " at " + debugInfo);
            }
            this.knownCountryCodes.add(countryIso);
            return true;
        }
    }

    private static interface TimeZonesProcessor {
        public static final boolean CONTINUE = true;
        public static final boolean HALT = false;

        default public boolean processHeader(String ianaVersion) throws XmlPullParserException {
            return true;
        }

        default public boolean processCountryZones(String countryIso, String defaultTimeZoneId, boolean everUsesUtc, List<CountryTimeZones.TimeZoneMapping> timeZoneMappings, String debugInfo) throws XmlPullParserException {
            return true;
        }
    }
}

