/*
 * Decompiled with CFR 0.152.
 */
package libcore.util;

import android.icu.util.TimeZone;
import java.io.File;
import java.io.IOException;
import libcore.icu.ICU;
import libcore.timezone.TimeZoneDataFiles;
import libcore.timezone.TzDataSetVersion;
import libcore.timezone.ZoneInfoDB;
import libcore.util.DebugInfo;

public class CoreLibraryDebug {
    private static final String CORE_LIBRARY_TIMEZONE_DEBUG_PREFIX = "core_library.timezone.";

    private CoreLibraryDebug() {
    }

    public static DebugInfo getDebugInfo() {
        DebugInfo debugInfo = new DebugInfo();
        CoreLibraryDebug.populateTimeZoneFilesInfo(debugInfo);
        CoreLibraryDebug.populateTimeZoneLibraryReportedVersion(debugInfo);
        return debugInfo;
    }

    private static void populateTimeZoneFilesInfo(DebugInfo debugInfo) {
        String debugKeyPrefix = "core_library.timezone.source.";
        String tzDataModulePrefix = debugKeyPrefix + "tzdata_module_";
        String versionFileName = TimeZoneDataFiles.getTimeZoneModuleFile("tz/tz_version");
        CoreLibraryDebug.addTzDataSetVersionDebugInfo(versionFileName, tzDataModulePrefix, debugInfo);
        String runtimeModulePrefix = debugKeyPrefix + "runtime_module_";
        versionFileName = TimeZoneDataFiles.getRuntimeModuleFile("tz/tz_version");
        CoreLibraryDebug.addTzDataSetVersionDebugInfo(versionFileName, runtimeModulePrefix, debugInfo);
        String systemDirPrefix = debugKeyPrefix + "system_";
        versionFileName = TimeZoneDataFiles.getSystemTimeZoneFile("tz_version");
        CoreLibraryDebug.addTzDataSetVersionDebugInfo(versionFileName, systemDirPrefix, debugInfo);
    }

    private static void addTzDataSetVersionDebugInfo(String tzDataSetVersionFileName, String debugKeyPrefix, DebugInfo debugInfo) {
        File file = new File(tzDataSetVersionFileName);
        String statusKey = debugKeyPrefix + "status";
        if (file.exists()) {
            try {
                TzDataSetVersion tzDataSetVersion = TzDataSetVersion.readFromFile(file);
                String formatVersionString = tzDataSetVersion.formatMajorVersion + "." + tzDataSetVersion.formatMinorVersion;
                debugInfo.addStringEntry(statusKey, "OK").addStringEntry(debugKeyPrefix + "formatVersion", formatVersionString).addStringEntry(debugKeyPrefix + "rulesVersion", tzDataSetVersion.rulesVersion).addStringEntry(debugKeyPrefix + "revision", tzDataSetVersion.revision);
            }
            catch (IOException | TzDataSetVersion.TzDataSetException e) {
                debugInfo.addStringEntry(statusKey, "ERROR");
                debugInfo.addStringEntry(debugKeyPrefix + "exception_class", e.getClass().getName());
                debugInfo.addStringEntry(debugKeyPrefix + "exception_msg", e.getMessage());
                System.logE((String)("Error reading " + file), (Throwable)e);
            }
        } else {
            debugInfo.addStringEntry(statusKey, "NOT_FOUND");
        }
    }

    private static void populateTimeZoneLibraryReportedVersion(DebugInfo debugInfo) {
        String debugKeyPrefix = "core_library.timezone.lib.";
        debugInfo.addStringEntry(debugKeyPrefix + "icu4j.tzdb_version", TimeZone.getTZDataVersion());
        debugInfo.addStringEntry(debugKeyPrefix + "libcore.tzdb_version", ZoneInfoDB.getInstance().getVersion());
        debugInfo.addStringEntry(debugKeyPrefix + "icu4c.tzdb_version", ICU.getTZDataVersion());
    }
}

