/*
 * Decompiled with CFR 0.152.
 */
package libcore.util;

import java.util.ArrayList;
import java.util.List;

public class DebugInfo {
    private final List<DebugEntry> entries = new ArrayList<DebugEntry>();

    public DebugInfo addStringEntry(String key, String value) {
        this.entries.add(new DebugEntry(key, value));
        return this;
    }

    public DebugInfo addStringEntry(String key, int value) {
        this.addStringEntry(key, Integer.toString(value));
        return this;
    }

    public List<DebugEntry> getDebugEntries() {
        return this.entries;
    }

    public DebugEntry getDebugEntry(String key) {
        for (DebugEntry entry : this.getDebugEntries()) {
            if (!key.equals(entry.getKey())) continue;
            return entry;
        }
        return null;
    }

    public static class DebugEntry {
        private final String key;
        private final String stringValue;

        public DebugEntry(String key, String stringValue) {
            this.key = key;
            this.stringValue = stringValue;
        }

        public String getKey() {
            return this.key;
        }

        public String getStringValue() {
            return this.stringValue;
        }
    }
}

