/*
 * Decompiled with CFR 0.152.
 */
package libcore.util;

import dalvik.annotation.compat.UnsupportedAppUsage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import libcore.io.BufferIterator;

public final class ZoneInfo
extends TimeZone {
    private static final long MILLISECONDS_PER_DAY = 86400000L;
    private static final long MILLISECONDS_PER_400_YEARS = 12622780800000L;
    private static final long UNIX_OFFSET = 62167219200000L;
    private static final int[] NORMAL = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
    private static final int[] LEAP = new int[]{0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335};
    static final long serialVersionUID = -4598738130123921552L;
    private int mRawOffset;
    private final int mEarliestRawOffset;
    private final boolean mUseDst;
    private int mDstSavings;
    @UnsupportedAppUsage
    private final long[] mTransitions;
    private final byte[] mTypes;
    private final int[] mOffsets;
    private final byte[] mIsDsts;

    public static ZoneInfo readTimeZone(String id2, BufferIterator it, long currentTimeMillis) throws IOException {
        int tzh_magic = it.readInt();
        if (tzh_magic != 1415211366) {
            throw new IOException("Timezone id=" + id2 + " has an invalid header=" + tzh_magic);
        }
        it.skip(28);
        int tzh_timecnt = it.readInt();
        int MAX_TRANSITIONS = 2000;
        if (tzh_timecnt < 0 || tzh_timecnt > 2000) {
            throw new IOException("Timezone id=" + id2 + " has an invalid number of transitions=" + tzh_timecnt);
        }
        int tzh_typecnt = it.readInt();
        int MAX_TYPES = 256;
        if (tzh_typecnt < 1) {
            throw new IOException("ZoneInfo requires at least one type to be provided for each timezone but could not find one for '" + id2 + "'");
        }
        if (tzh_typecnt > 256) {
            throw new IOException("Timezone with id " + id2 + " has too many types=" + tzh_typecnt);
        }
        it.skip(4);
        int[] transitions32 = new int[tzh_timecnt];
        it.readIntArray(transitions32, 0, transitions32.length);
        long[] transitions64 = new long[tzh_timecnt];
        for (int i = 0; i < tzh_timecnt; ++i) {
            transitions64[i] = transitions32[i];
            if (i <= 0 || transitions64[i] > transitions64[i - 1]) continue;
            throw new IOException(id2 + " transition at " + i + " is not sorted correctly, is " + transitions64[i] + ", previous is " + transitions64[i - 1]);
        }
        byte[] type = new byte[tzh_timecnt];
        it.readByteArray(type, 0, type.length);
        for (int i = 0; i < type.length; ++i) {
            int typeIndex = type[i] & 0xFF;
            if (typeIndex < tzh_typecnt) continue;
            throw new IOException(id2 + " type at " + i + " is not < " + tzh_typecnt + ", is " + typeIndex);
        }
        int[] gmtOffsets = new int[tzh_typecnt];
        byte[] isDsts = new byte[tzh_typecnt];
        for (int i = 0; i < tzh_typecnt; ++i) {
            gmtOffsets[i] = it.readInt();
            byte isDst = it.readByte();
            if (isDst != 0 && isDst != 1) {
                throw new IOException(id2 + " dst at " + i + " is not 0 or 1, is " + isDst);
            }
            isDsts[i] = isDst;
            it.skip(1);
        }
        return new ZoneInfo(id2, transitions64, type, gmtOffsets, isDsts, currentTimeMillis);
    }

    private ZoneInfo(String name, long[] transitions, byte[] types, int[] gmtOffsets, byte[] isDsts, long currentTimeMillis) {
        long currentUnixTimeSeconds;
        long lastDSTTransitionTime;
        if (gmtOffsets.length == 0) {
            throw new IllegalArgumentException("ZoneInfo requires at least one offset to be provided for each timezone but could not find one for '" + name + "'");
        }
        this.mTransitions = transitions;
        this.mTypes = types;
        this.mIsDsts = isDsts;
        this.setID(name);
        int lastStdTransitionIndex = -1;
        int lastDstTransitionIndex = -1;
        for (int i = this.mTransitions.length - 1; (lastStdTransitionIndex == -1 || lastDstTransitionIndex == -1) && i >= 0; --i) {
            int typeIndex = this.mTypes[i] & 0xFF;
            if (lastStdTransitionIndex == -1 && this.mIsDsts[typeIndex] == 0) {
                lastStdTransitionIndex = i;
            }
            if (lastDstTransitionIndex != -1 || this.mIsDsts[typeIndex] == 0) continue;
            lastDstTransitionIndex = i;
        }
        if (this.mTransitions.length == 0) {
            this.mRawOffset = gmtOffsets[0];
        } else {
            if (lastStdTransitionIndex == -1) {
                throw new IllegalStateException("ZoneInfo requires at least one non-DST transition to be provided for each timezone that has at least one transition but could not find one for '" + name + "'");
            }
            this.mRawOffset = gmtOffsets[this.mTypes[lastStdTransitionIndex] & 0xFF];
        }
        if (lastDstTransitionIndex != -1 && (lastDSTTransitionTime = this.mTransitions[lastDstTransitionIndex]) < (currentUnixTimeSeconds = ZoneInfo.roundUpMillisToSeconds(currentTimeMillis))) {
            lastDstTransitionIndex = -1;
        }
        if (lastDstTransitionIndex == -1) {
            this.mDstSavings = 0;
            this.mUseDst = false;
        } else {
            int lastGmtOffset = gmtOffsets[this.mTypes[lastStdTransitionIndex] & 0xFF];
            int lastDstOffset = gmtOffsets[this.mTypes[lastDstTransitionIndex] & 0xFF];
            this.mDstSavings = (lastDstOffset - lastGmtOffset) * 1000;
            this.mUseDst = true;
        }
        int firstStdTypeIndex = -1;
        for (int i = 0; i < this.mIsDsts.length; ++i) {
            if (this.mIsDsts[i] != 0) continue;
            firstStdTypeIndex = i;
            break;
        }
        int earliestRawOffset = firstStdTypeIndex != -1 ? gmtOffsets[firstStdTypeIndex] : this.mRawOffset;
        this.mOffsets = gmtOffsets;
        int i = 0;
        while (i < this.mOffsets.length) {
            int n = i++;
            this.mOffsets[n] = this.mOffsets[n] - this.mRawOffset;
        }
        this.mRawOffset *= 1000;
        this.mEarliestRawOffset = earliestRawOffset * 1000;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (!this.mUseDst && this.mDstSavings != 0) {
            this.mDstSavings = 0;
        }
    }

    @Override
    public int getOffset(int era, int year, int month, int day, int dayOfWeek, int millis) {
        long calc = (long)(year / 400) * 12622780800000L;
        calc += (long)(year %= 400) * 31536000000L;
        calc += (long)((year + 3) / 4) * 86400000L;
        if (year > 0) {
            calc -= (long)((year - 1) / 100) * 86400000L;
        }
        boolean isLeap = year == 0 || year % 4 == 0 && year % 100 != 0;
        int[] mlen = isLeap ? LEAP : NORMAL;
        calc += (long)mlen[month] * 86400000L;
        calc += (long)(day - 1) * 86400000L;
        calc += (long)millis;
        calc -= (long)this.mRawOffset;
        return this.getOffset(calc -= 62167219200000L);
    }

    public int findTransitionIndex(long seconds) {
        int transition2 = Arrays.binarySearch(this.mTransitions, seconds);
        if (transition2 < 0 && (transition2 = ~transition2 - 1) < 0) {
            return -1;
        }
        return transition2;
    }

    int findOffsetIndexForTimeInSeconds(long seconds) {
        int transition2 = this.findTransitionIndex(seconds);
        if (transition2 < 0) {
            return -1;
        }
        return this.mTypes[transition2] & 0xFF;
    }

    int findOffsetIndexForTimeInMilliseconds(long millis) {
        return this.findOffsetIndexForTimeInSeconds(ZoneInfo.roundDownMillisToSeconds(millis));
    }

    static long roundDownMillisToSeconds(long millis) {
        if (millis < 0L) {
            return (millis - 999L) / 1000L;
        }
        return millis / 1000L;
    }

    static long roundUpMillisToSeconds(long millis) {
        if (millis > 0L) {
            return (millis + 999L) / 1000L;
        }
        return millis / 1000L;
    }

    public int getOffsetsByUtcTime(long utcTimeInMillis, int[] offsets) {
        int totalOffset;
        int dstOffset;
        int rawOffset;
        int transitionIndex = this.findTransitionIndex(ZoneInfo.roundDownMillisToSeconds(utcTimeInMillis));
        if (transitionIndex == -1) {
            rawOffset = this.mEarliestRawOffset;
            dstOffset = 0;
            totalOffset = rawOffset;
        } else {
            int type = this.mTypes[transitionIndex] & 0xFF;
            totalOffset = this.mRawOffset + this.mOffsets[type] * 1000;
            if (this.mIsDsts[type] == 0) {
                rawOffset = totalOffset;
                dstOffset = 0;
            } else {
                rawOffset = -1;
                --transitionIndex;
                while (transitionIndex >= 0) {
                    type = this.mTypes[transitionIndex] & 0xFF;
                    if (this.mIsDsts[type] == 0) {
                        rawOffset = this.mRawOffset + this.mOffsets[type] * 1000;
                        break;
                    }
                    --transitionIndex;
                }
                if (rawOffset == -1) {
                    rawOffset = this.mEarliestRawOffset;
                }
                dstOffset = totalOffset - rawOffset;
            }
        }
        offsets[0] = rawOffset;
        offsets[1] = dstOffset;
        return totalOffset;
    }

    @Override
    public int getOffset(long when) {
        int offsetIndex = this.findOffsetIndexForTimeInMilliseconds(when);
        if (offsetIndex == -1) {
            return this.mEarliestRawOffset;
        }
        return this.mRawOffset + this.mOffsets[offsetIndex] * 1000;
    }

    @Override
    public boolean inDaylightTime(Date time) {
        long when = time.getTime();
        int offsetIndex = this.findOffsetIndexForTimeInMilliseconds(when);
        if (offsetIndex == -1) {
            return false;
        }
        return this.mIsDsts[offsetIndex] == 1;
    }

    @Override
    public int getRawOffset() {
        return this.mRawOffset;
    }

    @Override
    public void setRawOffset(int off) {
        this.mRawOffset = off;
    }

    @Override
    public int getDSTSavings() {
        return this.mDstSavings;
    }

    @Override
    public boolean useDaylightTime() {
        return this.mUseDst;
    }

    @Override
    public boolean hasSameRules(TimeZone timeZone) {
        if (!(timeZone instanceof ZoneInfo)) {
            return false;
        }
        ZoneInfo other = (ZoneInfo)timeZone;
        if (this.mUseDst != other.mUseDst) {
            return false;
        }
        if (!this.mUseDst) {
            return this.mRawOffset == other.mRawOffset;
        }
        return this.mRawOffset == other.mRawOffset && Arrays.equals(this.mOffsets, other.mOffsets) && Arrays.equals(this.mIsDsts, other.mIsDsts) && Arrays.equals(this.mTypes, other.mTypes) && Arrays.equals(this.mTransitions, other.mTransitions);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ZoneInfo)) {
            return false;
        }
        ZoneInfo other = (ZoneInfo)obj;
        return this.getID().equals(other.getID()) && this.hasSameRules(other);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getID().hashCode();
        result = 31 * result + Arrays.hashCode(this.mOffsets);
        result = 31 * result + Arrays.hashCode(this.mIsDsts);
        result = 31 * result + this.mRawOffset;
        result = 31 * result + Arrays.hashCode(this.mTransitions);
        result = 31 * result + Arrays.hashCode(this.mTypes);
        result = 31 * result + (this.mUseDst ? 1231 : 1237);
        return result;
    }

    public String toString() {
        return this.getClass().getName() + "[id=\"" + this.getID() + "\",mRawOffset=" + this.mRawOffset + ",mEarliestRawOffset=" + this.mEarliestRawOffset + ",mUseDst=" + this.mUseDst + ",mDstSavings=" + this.mDstSavings + ",transitions=" + this.mTransitions.length + "]";
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    private static int checked32BitAdd(long a, int b) throws CheckedArithmeticException {
        long result = a + (long)b;
        if (result != (long)((int)result)) {
            throw new CheckedArithmeticException();
        }
        return (int)result;
    }

    private static int checked32BitSubtract(long a, int b) throws CheckedArithmeticException {
        long result = a - (long)b;
        if (result != (long)((int)result)) {
            throw new CheckedArithmeticException();
        }
        return (int)result;
    }

    private static int saturated32BitAdd(long a, int b) {
        long result = a + (long)b;
        if (result > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (result < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)result;
    }

    private static class CheckedArithmeticException
    extends Exception {
        private CheckedArithmeticException() {
        }
    }

    static class OffsetInterval {
        private final int startWallTimeSeconds;
        private final int endWallTimeSeconds;
        private final int isDst;
        private final int totalOffsetSeconds;

        public static OffsetInterval create(ZoneInfo timeZone, int transitionIndex) {
            if (transitionIndex < -1 || transitionIndex >= timeZone.mTransitions.length) {
                return null;
            }
            if (transitionIndex == -1) {
                int totalOffsetSeconds = timeZone.mEarliestRawOffset / 1000;
                int isDst = 0;
                int startWallTimeSeconds = Integer.MIN_VALUE;
                int endWallTimeSeconds = ZoneInfo.saturated32BitAdd(timeZone.mTransitions[0], totalOffsetSeconds);
                if (startWallTimeSeconds == endWallTimeSeconds) {
                    return null;
                }
                return new OffsetInterval(startWallTimeSeconds, endWallTimeSeconds, isDst, totalOffsetSeconds);
            }
            int rawOffsetSeconds = timeZone.mRawOffset / 1000;
            int type = timeZone.mTypes[transitionIndex] & 0xFF;
            int totalOffsetSeconds = timeZone.mOffsets[type] + rawOffsetSeconds;
            int endWallTimeSeconds = transitionIndex == timeZone.mTransitions.length - 1 ? Integer.MAX_VALUE : ZoneInfo.saturated32BitAdd(timeZone.mTransitions[transitionIndex + 1], totalOffsetSeconds);
            byte isDst = timeZone.mIsDsts[type];
            int startWallTimeSeconds = ZoneInfo.saturated32BitAdd(timeZone.mTransitions[transitionIndex], totalOffsetSeconds);
            if (startWallTimeSeconds == endWallTimeSeconds) {
                return null;
            }
            return new OffsetInterval(startWallTimeSeconds, endWallTimeSeconds, isDst, totalOffsetSeconds);
        }

        private OffsetInterval(int startWallTimeSeconds, int endWallTimeSeconds, int isDst, int totalOffsetSeconds) {
            this.startWallTimeSeconds = startWallTimeSeconds;
            this.endWallTimeSeconds = endWallTimeSeconds;
            this.isDst = isDst;
            this.totalOffsetSeconds = totalOffsetSeconds;
        }

        public boolean containsWallTime(long wallTimeSeconds) {
            return wallTimeSeconds >= (long)this.startWallTimeSeconds && wallTimeSeconds < (long)this.endWallTimeSeconds;
        }

        public int getIsDst() {
            return this.isDst;
        }

        public int getTotalOffsetSeconds() {
            return this.totalOffsetSeconds;
        }

        public long getEndWallTimeSeconds() {
            return this.endWallTimeSeconds;
        }

        public long getStartWallTimeSeconds() {
            return this.startWallTimeSeconds;
        }
    }

    public static class WallTime {
        private final GregorianCalendar calendar = new GregorianCalendar(0, 0, 0, 0, 0, 0);
        private int year;
        private int month;
        private int monthDay;
        private int hour;
        private int minute;
        private int second;
        private int weekDay;
        private int yearDay;
        private int isDst;
        private int gmtOffsetSeconds;

        public WallTime() {
            this.calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        }

        public void localtime(int timeSeconds, ZoneInfo zoneInfo) {
            try {
                int isDst;
                int offsetSeconds = zoneInfo.mRawOffset / 1000;
                if (zoneInfo.mTransitions.length == 0) {
                    isDst = 0;
                } else {
                    int offsetIndex = zoneInfo.findOffsetIndexForTimeInSeconds(timeSeconds);
                    if (offsetIndex == -1) {
                        offsetSeconds = zoneInfo.mEarliestRawOffset / 1000;
                        isDst = 0;
                    } else {
                        offsetSeconds += zoneInfo.mOffsets[offsetIndex];
                        isDst = zoneInfo.mIsDsts[offsetIndex];
                    }
                }
                int wallTimeSeconds = ZoneInfo.checked32BitAdd(timeSeconds, offsetSeconds);
                this.calendar.setTimeInMillis((long)wallTimeSeconds * 1000L);
                this.copyFieldsFromCalendar();
                this.isDst = isDst;
                this.gmtOffsetSeconds = offsetSeconds;
            }
            catch (CheckedArithmeticException checkedArithmeticException) {
                // empty catch block
            }
        }

        public int mktime(ZoneInfo zoneInfo) {
            this.isDst = this.isDst > 0 ? (this.isDst = 1) : (this.isDst < 0 ? (this.isDst = -1) : 0);
            this.copyFieldsToCalendar();
            long longWallTimeSeconds = this.calendar.getTimeInMillis() / 1000L;
            if (Integer.MIN_VALUE > longWallTimeSeconds || longWallTimeSeconds > Integer.MAX_VALUE) {
                return -1;
            }
            try {
                int wallTimeSeconds = (int)longWallTimeSeconds;
                int rawOffsetSeconds = zoneInfo.mRawOffset / 1000;
                int rawTimeSeconds = ZoneInfo.checked32BitSubtract(wallTimeSeconds, rawOffsetSeconds);
                if (zoneInfo.mTransitions.length == 0) {
                    if (this.isDst > 0) {
                        return -1;
                    }
                    this.copyFieldsFromCalendar();
                    this.isDst = 0;
                    this.gmtOffsetSeconds = rawOffsetSeconds;
                    return rawTimeSeconds;
                }
                int initialTransitionIndex = zoneInfo.findTransitionIndex(rawTimeSeconds);
                if (this.isDst < 0) {
                    Integer result = this.doWallTimeSearch(zoneInfo, initialTransitionIndex, wallTimeSeconds, true);
                    return result == null ? -1 : result;
                }
                Integer result = this.doWallTimeSearch(zoneInfo, initialTransitionIndex, wallTimeSeconds, true);
                if (result == null) {
                    result = this.doWallTimeSearch(zoneInfo, initialTransitionIndex, wallTimeSeconds, false);
                }
                if (result == null) {
                    result = -1;
                }
                return result;
            }
            catch (CheckedArithmeticException e) {
                return -1;
            }
        }

        private Integer tryOffsetAdjustments(ZoneInfo zoneInfo, int oldWallTimeSeconds, OffsetInterval targetInterval, int transitionIndex, int isDstToFind) throws CheckedArithmeticException {
            int[] offsetsToTry = WallTime.getOffsetsOfType(zoneInfo, transitionIndex, isDstToFind);
            for (int j = 0; j < offsetsToTry.length; ++j) {
                int rawOffsetSeconds = zoneInfo.mRawOffset / 1000;
                int jOffsetSeconds = rawOffsetSeconds + offsetsToTry[j];
                int targetIntervalOffsetSeconds = targetInterval.getTotalOffsetSeconds();
                int adjustmentSeconds = targetIntervalOffsetSeconds - jOffsetSeconds;
                int adjustedWallTimeSeconds = ZoneInfo.checked32BitAdd(oldWallTimeSeconds, adjustmentSeconds);
                if (!targetInterval.containsWallTime(adjustedWallTimeSeconds)) continue;
                int returnValue = ZoneInfo.checked32BitSubtract(adjustedWallTimeSeconds, targetIntervalOffsetSeconds);
                this.calendar.setTimeInMillis((long)adjustedWallTimeSeconds * 1000L);
                this.copyFieldsFromCalendar();
                this.isDst = targetInterval.getIsDst();
                this.gmtOffsetSeconds = targetIntervalOffsetSeconds;
                return returnValue;
            }
            return null;
        }

        private static int[] getOffsetsOfType(ZoneInfo zoneInfo, int startIndex, int isDst) {
            int[] offsets = new int[zoneInfo.mOffsets.length + 1];
            boolean[] seen = new boolean[zoneInfo.mOffsets.length];
            int numFound = 0;
            int delta = 0;
            boolean clampTop = false;
            boolean clampBottom = false;
            do {
                if ((delta *= -1) >= 0) {
                    ++delta;
                }
                int transitionIndex = startIndex + delta;
                if (delta < 0 && transitionIndex < -1) {
                    clampBottom = true;
                    continue;
                }
                if (delta > 0 && transitionIndex >= zoneInfo.mTypes.length) {
                    clampTop = true;
                    continue;
                }
                if (transitionIndex == -1) {
                    if (isDst != 0) continue;
                    offsets[numFound++] = 0;
                    continue;
                }
                int type = zoneInfo.mTypes[transitionIndex] & 0xFF;
                if (seen[type]) continue;
                if (zoneInfo.mIsDsts[type] == isDst) {
                    offsets[numFound++] = zoneInfo.mOffsets[type];
                }
                seen[type] = true;
            } while (!clampTop || !clampBottom);
            int[] toReturn = new int[numFound];
            System.arraycopy(offsets, 0, toReturn, 0, numFound);
            return toReturn;
        }

        private Integer doWallTimeSearch(ZoneInfo zoneInfo, int initialTransitionIndex, int wallTimeSeconds, boolean mustMatchDst) throws CheckedArithmeticException {
            int MAX_SEARCH_SECONDS = 86400;
            boolean clampTop = false;
            boolean clampBottom = false;
            int loop = 0;
            do {
                boolean endSearch;
                int isDstToFind;
                Integer returnValue;
                int transitionIndexDelta = (loop + 1) / 2;
                if (loop % 2 == 1) {
                    transitionIndexDelta *= -1;
                }
                ++loop;
                if (transitionIndexDelta > 0 && clampTop || transitionIndexDelta < 0 && clampBottom) continue;
                int currentTransitionIndex = initialTransitionIndex + transitionIndexDelta;
                OffsetInterval offsetInterval = OffsetInterval.create(zoneInfo, currentTransitionIndex);
                if (offsetInterval == null) {
                    clampTop |= transitionIndexDelta > 0;
                    clampBottom |= transitionIndexDelta < 0;
                    continue;
                }
                if (mustMatchDst) {
                    if (offsetInterval.containsWallTime(wallTimeSeconds) && (this.isDst == -1 || offsetInterval.getIsDst() == this.isDst)) {
                        int totalOffsetSeconds = offsetInterval.getTotalOffsetSeconds();
                        int returnValue2 = ZoneInfo.checked32BitSubtract(wallTimeSeconds, totalOffsetSeconds);
                        this.copyFieldsFromCalendar();
                        this.isDst = offsetInterval.getIsDst();
                        this.gmtOffsetSeconds = totalOffsetSeconds;
                        return returnValue2;
                    }
                } else if (this.isDst != offsetInterval.getIsDst() && (returnValue = this.tryOffsetAdjustments(zoneInfo, wallTimeSeconds, offsetInterval, currentTransitionIndex, isDstToFind = this.isDst)) != null) {
                    return returnValue;
                }
                if (transitionIndexDelta > 0) {
                    boolean bl = endSearch = offsetInterval.getEndWallTimeSeconds() - (long)wallTimeSeconds > 86400L;
                    if (!endSearch) continue;
                    clampTop = true;
                    continue;
                }
                if (transitionIndexDelta >= 0) continue;
                boolean bl = endSearch = (long)wallTimeSeconds - offsetInterval.getStartWallTimeSeconds() >= 86400L;
                if (!endSearch) continue;
                clampBottom = true;
            } while (!clampTop || !clampBottom);
            return null;
        }

        public void setYear(int year) {
            this.year = year;
        }

        public void setMonth(int month) {
            this.month = month;
        }

        public void setMonthDay(int monthDay) {
            this.monthDay = monthDay;
        }

        public void setHour(int hour) {
            this.hour = hour;
        }

        public void setMinute(int minute) {
            this.minute = minute;
        }

        public void setSecond(int second) {
            this.second = second;
        }

        public void setWeekDay(int weekDay) {
            this.weekDay = weekDay;
        }

        public void setYearDay(int yearDay) {
            this.yearDay = yearDay;
        }

        public void setIsDst(int isDst) {
            this.isDst = isDst;
        }

        public void setGmtOffset(int gmtoff) {
            this.gmtOffsetSeconds = gmtoff;
        }

        public int getYear() {
            return this.year;
        }

        public int getMonth() {
            return this.month;
        }

        public int getMonthDay() {
            return this.monthDay;
        }

        public int getHour() {
            return this.hour;
        }

        public int getMinute() {
            return this.minute;
        }

        public int getSecond() {
            return this.second;
        }

        public int getWeekDay() {
            return this.weekDay;
        }

        public int getYearDay() {
            return this.yearDay;
        }

        public int getGmtOffset() {
            return this.gmtOffsetSeconds;
        }

        public int getIsDst() {
            return this.isDst;
        }

        private void copyFieldsToCalendar() {
            this.calendar.set(1, this.year);
            this.calendar.set(2, this.month);
            this.calendar.set(5, this.monthDay);
            this.calendar.set(11, this.hour);
            this.calendar.set(12, this.minute);
            this.calendar.set(13, this.second);
            this.calendar.set(14, 0);
        }

        private void copyFieldsFromCalendar() {
            this.year = this.calendar.get(1);
            this.month = this.calendar.get(2);
            this.monthDay = this.calendar.get(5);
            this.hour = this.calendar.get(11);
            this.minute = this.calendar.get(12);
            this.second = this.calendar.get(13);
            this.weekDay = this.calendar.get(7) - 1;
            this.yearDay = this.calendar.get(6) - 1;
        }
    }
}

