/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res.android;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.res.android.ResTable_config;
import org.robolectric.res.android.Util;

public class ResourceTypes {
    public static final String ANDROID_NS = "http://schemas.android.com/apk/res/android";
    public static final String AUTO_NS = "http://schemas.android.com/apk/res-auto";
    static final int kIdmapMagic = 1347241033;
    static final int kIdmapCurrentVersion = 1;
    public static final int RES_NULL_TYPE = 0;
    public static final int RES_STRING_POOL_TYPE = 1;
    public static final int RES_TABLE_TYPE = 2;
    public static final int RES_XML_TYPE = 3;
    public static final int RES_XML_FIRST_CHUNK_TYPE = 256;
    public static final int RES_XML_START_NAMESPACE_TYPE = 256;
    public static final int RES_XML_END_NAMESPACE_TYPE = 257;
    public static final int RES_XML_START_ELEMENT_TYPE = 258;
    public static final int RES_XML_END_ELEMENT_TYPE = 259;
    public static final int RES_XML_CDATA_TYPE = 260;
    public static final int RES_XML_LAST_CHUNK_TYPE = 383;
    public static final int RES_XML_RESOURCE_MAP_TYPE = 384;
    public static final int RES_TABLE_PACKAGE_TYPE = 512;
    public static final int RES_TABLE_TYPE_TYPE = 513;
    public static final int RES_TABLE_TYPE_SPEC_TYPE = 514;
    public static final int RES_TABLE_LIBRARY_TYPE = 515;
    public static final int RES_TABLE_STAGED_ALIAS_TYPE = 518;
    public static final int RESTABLE_MAX_LOCALE_LEN = 40;
    static final int kResTableTypeMinSize = ResTable_type.SIZEOF_WITHOUT_CONFIG - 52 + 4;

    static int validate_chunk(ResChunk_header chunk, int minSize, int dataLen, String name) {
        short headerSize = Util.dtohs(chunk.headerSize);
        int size = Util.dtohl(chunk.size);
        if (headerSize >= minSize) {
            if (headerSize <= size) {
                if (((headerSize | size) & 3) == 0) {
                    if (size <= dataLen) {
                        return 0;
                    }
                    Util.ALOGW("%s data size 0x%x extends beyond resource end.", name, size);
                    return -2147483646;
                }
                Util.ALOGW("%s size 0x%x or headerSize 0x%x is not on an integer boundary.", name, size, headerSize);
                return -2147483646;
            }
            Util.ALOGW("%s size 0x%x is smaller than header size 0x%x.", name, size, headerSize);
            return -2147483646;
        }
        Util.ALOGW("%s header size 0x%04x is too small.", name, headerSize);
        return -2147483646;
    }

    private static int Res_MAKEINTERNAL(int entry) {
        return 0x1000000 | entry & 0xFFFF;
    }

    static /* synthetic */ int access$000(int x0) {
        return ResourceTypes.Res_MAKEINTERNAL(x0);
    }

    public static class ResChunk_header
    extends WithOffset {
        static int SIZEOF = 8;
        final short type;
        final short headerSize;
        final int size;

        public ResChunk_header(ByteBuffer buf, int offset) {
            super(buf, offset);
            this.type = buf.getShort(offset);
            this.headerSize = buf.getShort(offset + 2);
            this.size = buf.getInt(offset + 4);
        }

        public static void write(ByteBuffer buf, short type, Runnable header, Runnable contents) {
            int startPos = buf.position();
            buf.putShort(type);
            ShortWriter headerSize = new ShortWriter(buf);
            IntWriter size = new IntWriter(buf);
            header.run();
            headerSize.write((short)(buf.position() - startPos));
            contents.run();
            int len = buf.position() - startPos;
            while ((len & 3) != 0) {
                buf.put((byte)0);
                ++len;
            }
            size.write(len);
        }
    }

    static class ResTable_type
    extends WithOffset {
        public static final int SIZEOF_WITHOUT_CONFIG = ResChunk_header.SIZEOF + 12;
        final ResChunk_header header;
        public static final int NO_ENTRY = -1;
        final byte id;
        public static final int FLAG_SPARSE = 1;
        public static final int FLAG_OFFSET16 = 2;
        final byte flags;
        final short reserved;
        final int entryCount;
        final int entriesStart;
        final ResTable_config config;

        ResTable_type(ByteBuffer buf, int offset) {
            super(buf, offset);
            this.header = new ResChunk_header(buf, offset);
            this.id = buf.get(offset + ResChunk_header.SIZEOF);
            this.flags = buf.get(offset + ResChunk_header.SIZEOF + 1);
            this.reserved = buf.getShort(offset + ResChunk_header.SIZEOF + 2);
            this.entryCount = buf.getInt(offset + ResChunk_header.SIZEOF + 4);
            this.entriesStart = buf.getInt(offset + ResChunk_header.SIZEOF + 8);
            ((Buffer)buf).position(offset + ResChunk_header.SIZEOF + 12);
            this.config = ResTable_config.createConfig(buf);
        }

        public int findEntryByResName(int stringId) {
            for (int i = 0; i < this.entryCount; ++i) {
                if (this.entryNameIndex(i) != stringId) continue;
                if (Util.isTruthy(this.flags & 1)) {
                    ResTable_sparseTypeEntry sparseEntry = this.getSparseEntry(i);
                    return sparseEntry.idx;
                }
                return i;
            }
            return -1;
        }

        int entryOffset(int entryIndex) {
            ByteBuffer byteBuffer = this.myBuf();
            int offset = this.myOffset();
            if (Util.isTruthy(this.flags & 2)) {
                short off16 = byteBuffer.getShort(offset + this.header.headerSize + entryIndex * 2);
                return Util.dtohs(off16) == -1 ? -1 : Util.dtohs(off16) * 4;
            }
            if (Util.isTruthy(this.flags & 1)) {
                ResTable_sparseTypeEntry sparseEntry = this.getSparseEntry(entryIndex);
                return Util.dtohs(sparseEntry.offset) * 4;
            }
            return byteBuffer.getInt(offset + this.header.headerSize + entryIndex * 4);
        }

        private ResTable_sparseTypeEntry getSparseEntry(int entryIndex) {
            return new ResTable_sparseTypeEntry(this.myBuf(), this.myOffset() + this.header.headerSize + entryIndex * 4);
        }

        private int entryNameIndex(int entryIndex) {
            ByteBuffer byteBuffer = this.myBuf();
            int offset = this.myOffset();
            int entryOffset = this.entryOffset(entryIndex);
            if (entryOffset == -1) {
                return -1;
            }
            int STRING_POOL_REF_OFFSET = 4;
            return Util.dtohl(byteBuffer.getInt(offset + this.entriesStart + entryOffset + STRING_POOL_REF_OFFSET));
        }
    }

    private static class ShortWriter
    extends FutureWriter<Short> {
        public ShortWriter(ByteBuffer buf) {
            super(buf, 2);
        }

        @Override
        protected void put(int position, Short value) {
            this.buf.putShort(position, value);
        }
    }

    private static class IntWriter
    extends FutureWriter<Integer> {
        public IntWriter(ByteBuffer buf) {
            super(buf, 4);
        }

        @Override
        protected void put(int position, Integer value) {
            this.buf.putInt(position, value);
        }
    }

    private static abstract class FutureWriter<T> {
        protected final ByteBuffer buf;
        private final int position;

        public FutureWriter(ByteBuffer buf, int size) {
            this.buf = buf;
            this.position = buf.position();
            ((Buffer)buf).position(this.position + size);
        }

        protected abstract void put(int var1, T var2);

        public void write(T value) {
            this.put(this.position, value);
        }
    }

    static class IdmapEntry_header
    extends WithOffset {
        static final int SIZEOF = 8;
        short target_type_id;
        short overlay_type_id;
        short entry_count;
        short entry_id_offset;
        int[] entries;

        IdmapEntry_header(ByteBuffer buf, int offset) {
            super(buf, offset);
            this.target_type_id = buf.getShort(offset);
            this.overlay_type_id = buf.getShort(offset + 2);
            this.entry_count = buf.getShort(offset + 4);
            this.entry_id_offset = buf.getShort(offset + 6);
            this.entries = new int[this.entry_count];
            for (int i = 0; i < this.entries.length; ++i) {
                this.entries[i] = buf.getInt(offset + 8 + i * 4);
            }
        }
    }

    static class Idmap_header
    extends WithOffset {
        int magic;
        int version;
        int target_crc32;
        int overlay_crc32;
        final byte[] target_path = new byte[256];
        final byte[] overlay_path = new byte[256];
        short target_package_id;
        short type_count;

        Idmap_header(ByteBuffer buf, int offset) {
            super(buf, offset);
            this.magic = buf.getInt(offset);
            this.version = buf.getInt(offset + 4);
            this.target_crc32 = buf.getInt(offset + 8);
            this.overlay_crc32 = buf.getInt(offset + 12);
            buf.get(this.target_path, offset + 16, 256);
            buf.get(this.overlay_path, offset + 16 + 256, 256);
            this.target_package_id = buf.getShort(offset + 16 + 256 + 256);
            this.type_count = buf.getShort(offset + 16 + 256 + 256 + 2);
        }
    }

    static class ResTableStagedAliasEntry
    extends WithOffset {
        public static final int SIZEOF = 8;
        int stagedResId;
        int finalizedResId;

        ResTableStagedAliasEntry(ByteBuffer buf, int offset) {
            super(buf, offset);
            this.stagedResId = buf.getInt(offset);
            this.finalizedResId = buf.getInt(offset + 4);
        }
    }

    static class ResTableStagedAliasHeader
    extends WithOffset {
        public static final int SIZEOF = ResChunk_header.SIZEOF + 4;
        ResChunk_header header;
        int count;

        ResTableStagedAliasHeader(ByteBuffer buf, int offset) {
            super(buf, offset);
            this.header = new ResChunk_header(buf, offset);
            this.count = buf.getInt(offset + ResChunk_header.SIZEOF);
        }
    }

    static class ResTable_lib_entry
    extends WithOffset {
        public static final int SIZEOF = 260;
        int packageId;
        char[] packageName = new char[128];

        ResTable_lib_entry(ByteBuffer buf, int offset) {
            super(buf, offset);
            this.packageId = buf.getInt(offset);
            for (int i = 0; i < this.packageName.length; ++i) {
                this.packageName[i] = buf.getChar(offset + 4 + i * 2);
            }
        }
    }

    static class ResTable_lib_header
    extends WithOffset {
        static final int SIZEOF = ResChunk_header.SIZEOF + 4;
        ResChunk_header header;
        int count;

        ResTable_lib_header(ByteBuffer buf, int offset) {
            super(buf, offset);
            this.header = new ResChunk_header(buf, offset);
            this.count = buf.getInt(offset + ResChunk_header.SIZEOF);
        }
    }

    public static class ResTable_map
    extends WithOffset {
        public static final int SIZEOF = 12;
        public final ResTable_ref name;
        public static final int ATTR_TYPE = ResourceTypes.access$000(0);
        public static final int ATTR_MIN = ResourceTypes.access$000(1);
        public static final int ATTR_MAX = ResourceTypes.access$000(2);
        public static final int ATTR_L10N = ResourceTypes.access$000(3);
        public static final int ATTR_OTHER = ResourceTypes.access$000(4);
        public static final int ATTR_ZERO = ResourceTypes.access$000(5);
        public static final int ATTR_ONE = ResourceTypes.access$000(6);
        public static final int ATTR_TWO = ResourceTypes.access$000(7);
        public static final int ATTR_FEW = ResourceTypes.access$000(8);
        public static final int ATTR_MANY = ResourceTypes.access$000(9);
        public static final int TYPE_ANY = 65535;
        public static final int TYPE_REFERENCE = 1;
        public static final int TYPE_STRING = 2;
        public static final int TYPE_INTEGER = 4;
        public static final int TYPE_BOOLEAN = 8;
        public static final int TYPE_COLOR = 16;
        public static final int TYPE_FLOAT = 32;
        public static final int TYPE_DIMENSION = 64;
        public static final int TYPE_FRACTION = 128;
        public static final int TYPE_ENUM = 65536;
        public static final int TYPE_FLAGS = 131072;
        public static final int L10N_NOT_REQUIRED = 0;
        public static final int L10N_SUGGESTED = 1;
        public Res_value value;

        public ResTable_map(ByteBuffer buf, int offset) {
            super(buf, offset);
            this.name = new ResTable_ref(buf, offset);
            this.value = new Res_value(buf, offset + 4);
        }

        public ResTable_map() {
            super(null, 0);
            this.name = new ResTable_ref();
            this.value = new Res_value();
        }

        @Override
        public String toString() {
            return "ResTable_map{name=" + this.name + ", value=" + this.value + '}';
        }
    }

    static class ResTable_map_entry
    extends ResTable_entry {
        public static final Void SIZEOF = null;
        public static final int BASE_SIZEOF = 16;
        ResTable_ref parent;
        int count;

        ResTable_map_entry(ByteBuffer buf, int offset) {
            super(buf, offset);
            this.parent = new ResTable_ref(buf, offset + 8);
            this.count = buf.getInt(offset + 8 + 4);
        }
    }

    static class ResTable_entry
    extends WithOffset {
        public static final int SIZEOF = 8;
        short size;
        public static final int FLAG_COMPLEX = 1;
        public static final int FLAG_PUBLIC = 2;
        public static final int FLAG_WEAK = 4;
        public static final int FLAG_COMPACT = 8;
        final short flags;
        ResStringPool_ref key;
        int compactData;
        short compactKey;

        ResTable_entry(ByteBuffer buf, int offset) {
            super(buf, offset);
            this.flags = buf.getShort(offset + 2);
            if (this.isCompact()) {
                this.compactKey = buf.getShort(offset);
                this.compactData = buf.getInt(offset + 4);
            } else {
                this.size = buf.getShort(offset);
                this.key = new ResStringPool_ref(buf, offset + 4);
            }
        }

        public int getKeyIndex() {
            if (this.isCompact()) {
                return Util.dtohs(this.compactKey);
            }
            return this.key.index;
        }

        public boolean isCompact() {
            return (this.flags & 8) == 8;
        }

        public Res_value getResValue() {
            if (this.isCompact()) {
                byte type = (byte)(Util.dtohs(this.flags) >> 8);
                return new Res_value(type, this.compactData);
            }
            return new Res_value(this.myBuf(), this.myOffset() + Util.dtohs(this.size));
        }
    }

    static class ResTable_sparseTypeEntry
    extends WithOffset {
        public static final int SIZEOF = 4;
        short idx;
        short offset;

        public ResTable_sparseTypeEntry(ByteBuffer buf, int offset) {
            super(buf, offset);
            this.idx = buf.getShort(offset);
            this.offset = buf.getShort(offset + 2);
        }
    }

    static class ResTable_typeSpec
    extends WithOffset {
        public static final int SIZEOF = ResChunk_header.SIZEOF + 8;
        final ResChunk_header header;
        final byte id;
        final byte res0;
        final short res1;
        final int entryCount;
        static final int SPEC_PUBLIC = 0x40000000;
        static final int SPEC_OVERLAYABLE = Integer.MIN_VALUE;

        public ResTable_typeSpec(ByteBuffer buf, int offset) {
            super(buf, offset);
            this.header = new ResChunk_header(buf, offset);
            this.id = buf.get(offset + ResChunk_header.SIZEOF);
            this.res0 = buf.get(offset + ResChunk_header.SIZEOF + 1);
            this.res1 = buf.getShort(offset + ResChunk_header.SIZEOF + 2);
            this.entryCount = buf.getInt(offset + ResChunk_header.SIZEOF + 4);
        }

        public int[] getSpecFlags() {
            int[] ints = new int[(this.header.size - this.header.headerSize) / 4];
            for (int i = 0; i < ints.length; ++i) {
                ints[i] = this.myBuf().getInt(this.myOffset() + this.header.headerSize + i * 4);
            }
            return ints;
        }
    }

    static class ResTable_package
    extends WithOffset {
        public static final int SIZEOF = ResChunk_header.SIZEOF + 4 + 128 + 20;
        final ResChunk_header header;
        public final int id;
        public final char[] name = new char[128];
        public final int typeStrings;
        public final int lastPublicType;
        public final int keyStrings;
        public final int lastPublicKey;
        public final int typeIdOffset;

        public ResTable_package(ByteBuffer buf, int offset) {
            super(buf, offset);
            this.header = new ResChunk_header(buf, offset);
            this.id = buf.getInt(offset + ResChunk_header.SIZEOF);
            for (int i = 0; i < this.name.length; ++i) {
                this.name[i] = buf.getChar(offset + ResChunk_header.SIZEOF + 4 + i * 2);
            }
            this.typeStrings = buf.getInt(offset + ResChunk_header.SIZEOF + 4 + 256);
            this.lastPublicType = buf.getInt(offset + ResChunk_header.SIZEOF + 4 + 256 + 4);
            this.keyStrings = buf.getInt(offset + ResChunk_header.SIZEOF + 4 + 256 + 8);
            this.lastPublicKey = buf.getInt(offset + ResChunk_header.SIZEOF + 4 + 256 + 12);
            this.typeIdOffset = buf.getInt(offset + ResChunk_header.SIZEOF + 4 + 256 + 16);
        }
    }

    static class ResTable_header
    extends WithOffset {
        public static final int SIZEOF = ResChunk_header.SIZEOF + 4;
        final ResChunk_header header;
        final int packageCount;

        public ResTable_header(ByteBuffer buf, int offset) {
            super(buf, offset);
            this.header = new ResChunk_header(buf, offset);
            this.packageCount = buf.getInt(offset + ResChunk_header.SIZEOF);
        }
    }

    static class ResXMLTree_attribute {
        public static final int SIZEOF = 20;
        final ResStringPool_ref ns;
        final ResStringPool_ref name;
        final ResStringPool_ref rawValue;
        final Res_value typedValue;

        public ResXMLTree_attribute(ByteBuffer buf, int offset) {
            this.ns = new ResStringPool_ref(buf, offset);
            this.name = new ResStringPool_ref(buf, offset + 4);
            this.rawValue = new ResStringPool_ref(buf, offset + 8);
            this.typedValue = new Res_value(buf, offset + 12);
        }

        public static void write(ByteBuffer buf, int ns, int name, int value, int resValueDataType, int resValueData) {
            ResStringPool_ref.write(buf, ns);
            ResStringPool_ref.write(buf, name);
            ResStringPool_ref.write(buf, value);
            Res_value.write(buf, resValueDataType, resValueData);
        }
    }

    public static class ResXMLTree_attrExt
    extends WithOffset {
        private final ByteBuffer buf;
        final ResStringPool_ref ns;
        final ResStringPool_ref name;
        final short attributeStart;
        final short attributeSize;
        final short attributeCount;
        final short idIndex;
        final short classIndex;
        final short styleIndex;

        public ResXMLTree_attrExt(ByteBuffer buf, int offset) {
            super(buf, offset);
            this.buf = buf;
            this.ns = new ResStringPool_ref(buf, offset);
            this.name = new ResStringPool_ref(buf, offset + 4);
            this.attributeStart = buf.getShort(offset + 8);
            this.attributeSize = buf.getShort(offset + 10);
            this.attributeCount = buf.getShort(offset + 12);
            this.idIndex = buf.getShort(offset + 14);
            this.classIndex = buf.getShort(offset + 16);
            this.styleIndex = buf.getShort(offset + 18);
        }

        ResXMLTree_attribute attributeAt(int idx) {
            return new ResXMLTree_attribute(this.buf, this.myOffset() + Util.dtohs(this.attributeStart) + Util.dtohs(this.attributeSize) * idx);
        }

        public static class Writer {
            private final ByteBuffer buf;
            private final int ns;
            private final int name;
            private short idIndex;
            private short classIndex;
            private short styleIndex;
            private final List<Attr> attrs = new ArrayList<Attr>();

            public Writer(ByteBuffer buf, ResStringPool_header.Writer resStringPoolWriter, String ns, String name) {
                this.buf = buf;
                this.ns = resStringPoolWriter.string(ns);
                this.name = resStringPoolWriter.string(name);
            }

            public void attr(int ns, int name, int value, Res_value resValue, String fullName) {
                this.attrs.add(new Attr(ns, name, value, resValue, fullName));
            }

            public void write() {
                int startPos = this.buf.position();
                int attributeCount = this.attrs.size();
                ResStringPool_ref.write(this.buf, this.ns);
                ResStringPool_ref.write(this.buf, this.name);
                ShortWriter attributeStartWriter = new ShortWriter(this.buf);
                this.buf.putShort((short)20);
                this.buf.putShort((short)attributeCount);
                ShortWriter idIndexWriter = new ShortWriter(this.buf);
                ShortWriter classIndexWriter = new ShortWriter(this.buf);
                ShortWriter styleIndexWriter = new ShortWriter(this.buf);
                attributeStartWriter.write((short)(this.buf.position() - startPos));
                for (int i = 0; i < attributeCount; ++i) {
                    Attr attr = this.attrs.get(i);
                    switch (attr.fullName) {
                        case ":id": {
                            this.idIndex = (short)(i + 1);
                            break;
                        }
                        case ":style": {
                            this.styleIndex = (short)(i + 1);
                            break;
                        }
                        case ":class": {
                            this.classIndex = (short)(i + 1);
                        }
                    }
                    attr.write(this.buf);
                }
                idIndexWriter.write(this.idIndex);
                classIndexWriter.write(this.classIndex);
                styleIndexWriter.write(this.styleIndex);
            }

            private static class Attr {
                final int ns;
                final int name;
                final int value;
                final int resValueDataType;
                final int resValueData;
                final String fullName;

                public Attr(int ns, int name, int value, Res_value resValue, String fullName) {
                    this.ns = ns;
                    this.name = name;
                    this.value = value;
                    this.resValueDataType = resValue.dataType;
                    this.resValueData = resValue.data;
                    this.fullName = fullName;
                }

                public void write(ByteBuffer buf) {
                    ResXMLTree_attribute.write(buf, this.ns, this.name, this.value, this.resValueDataType, this.resValueData);
                }
            }
        }
    }

    public static class ResXMLTree_endElementExt {
        static final int SIZEOF = 8;
        final ResStringPool_ref ns;
        final ResStringPool_ref name;

        public ResXMLTree_endElementExt(ByteBuffer buf, int offset) {
            this.ns = new ResStringPool_ref(buf, offset);
            this.name = new ResStringPool_ref(buf, offset + 4);
        }

        public static class Writer {
            private final ByteBuffer buf;
            private final int ns;
            private final int name;

            public Writer(ByteBuffer buf, ResStringPool_header.Writer resStringPoolWriter, String ns, String name) {
                this.buf = buf;
                this.ns = resStringPoolWriter.string(ns);
                this.name = resStringPoolWriter.string(name);
            }

            public void write() {
                ResStringPool_ref.write(this.buf, this.ns);
                ResStringPool_ref.write(this.buf, this.name);
            }
        }
    }

    static class ResXMLTree_namespaceExt {
        final ResStringPool_ref prefix;
        final ResStringPool_ref uri;

        public ResXMLTree_namespaceExt(ByteBuffer buf, int offset) {
            this.prefix = new ResStringPool_ref(buf, offset);
            this.uri = new ResStringPool_ref(buf, offset + 4);
        }
    }

    static class ResXMLTree_cdataExt {
        final ResStringPool_ref data;
        final Res_value typedData;

        public ResXMLTree_cdataExt(ByteBuffer buf, int offset) {
            this.data = new ResStringPool_ref(buf, offset);
            int dataType = buf.getInt(offset + 4);
            int data = buf.getInt(offset + 8);
            this.typedData = new Res_value((byte)dataType, data);
        }
    }

    public static class ResXMLTree_node
    extends WithOffset {
        final ResChunk_header header;
        final int lineNumber;
        final ResStringPool_ref comment;

        ResXMLTree_node(ByteBuffer buf, int offset) {
            super(buf, offset);
            this.header = new ResChunk_header(buf, offset);
            this.lineNumber = buf.getInt(offset + ResChunk_header.SIZEOF);
            this.comment = new ResStringPool_ref(buf, offset + 12);
        }

        ResXMLTree_node(ByteBuffer buf, ResChunk_header header) {
            super(buf, header.myOffset());
            this.header = header;
            this.lineNumber = buf.getInt(this.myOffset() + ResChunk_header.SIZEOF);
            this.comment = new ResStringPool_ref(buf, this.myOffset() + ResChunk_header.SIZEOF + 4);
        }

        public static void write(ByteBuffer buf, int type, Runnable contents) {
            ResChunk_header.write(buf, (short)type, () -> {
                buf.putInt(-1);
                ResStringPool_ref.write(buf, -1);
            }, contents);
        }
    }

    public static class ResXMLTree_header
    extends WithOffset {
        public final ResChunk_header header;

        ResXMLTree_header(ByteBuffer buf, int offset) {
            super(buf, offset);
            this.header = new ResChunk_header(buf, offset);
        }

        public static void write(ByteBuffer buf, ResStringPool_header.Writer resStringPoolWriter, Runnable contents) {
            ResChunk_header.write(buf, (short)3, () -> {}, () -> {
                resStringPoolWriter.write(buf);
                contents.run();
            });
        }
    }

    public static class ResStringPool_span
    extends WithOffset {
        public static final int SIZEOF = 12;
        public static final int END = -1;
        public final ResStringPool_ref name;
        final int firstChar;
        final int lastChar;

        public ResStringPool_span(ByteBuffer buf, int offset) {
            super(buf, offset);
            this.name = new ResStringPool_ref(buf, offset);
            this.firstChar = buf.getInt(offset + 4);
            this.lastChar = buf.getInt(offset + 4 + 4);
        }

        public boolean isEnd() {
            return this.name.index == -1 && this.firstChar == -1 && this.lastChar == -1;
        }
    }

    public static class ResStringPool_header
    extends WithOffset {
        public static final int SIZEOF = ResChunk_header.SIZEOF + 20;
        final ResChunk_header header;
        final int stringCount;
        final int styleCount;
        public static final int SORTED_FLAG = 1;
        public static final int UTF8_FLAG = 256;
        final int flags;
        final int stringsStart;
        final int stylesStart;

        public ResStringPool_header(ByteBuffer buf, int offset) {
            super(buf, offset);
            this.header = new ResChunk_header(buf, offset);
            this.stringCount = buf.getInt(offset + ResChunk_header.SIZEOF);
            this.styleCount = buf.getInt(offset + ResChunk_header.SIZEOF + 4);
            this.flags = buf.getInt(offset + ResChunk_header.SIZEOF + 8);
            this.stringsStart = buf.getInt(offset + ResChunk_header.SIZEOF + 12);
            this.stylesStart = buf.getInt(offset + ResChunk_header.SIZEOF + 16);
        }

        public int getByte(int i) {
            return this.myBuf().get(this.myOffset() + i);
        }

        public int getShort(int i) {
            return this.myBuf().getShort(this.myOffset() + i);
        }

        public static class Writer {
            private final List<String> strings = new ArrayList<String>();
            private final List<byte[]> stringsAsBytes = new ArrayList<byte[]>();
            private final Map<String, Integer> stringIds = new HashMap<String, Integer>();
            private boolean frozen;

            public int string(String s) {
                if (this.frozen) {
                    throw new IllegalStateException("string pool is frozen!");
                }
                if (s == null) {
                    return -1;
                }
                Integer id = this.stringIds.get(s);
                if (id == null) {
                    id = this.strings.size();
                    this.strings.add(s);
                    this.stringsAsBytes.add(s.getBytes(StandardCharsets.UTF_8));
                    this.stringIds.put(s, id);
                }
                return id;
            }

            public int uniqueString(String s) {
                if (this.frozen) {
                    throw new IllegalStateException("string pool is frozen!");
                }
                if (s == null) {
                    return -1;
                }
                int id = this.strings.size();
                this.strings.add(s);
                this.stringsAsBytes.add(s.getBytes(StandardCharsets.UTF_8));
                return id;
            }

            public void write(ByteBuffer buf) {
                this.freeze();
                ResChunk_header.write(buf, (short)1, () -> {
                    int startPos = buf.position();
                    int stringCount = this.strings.size();
                    buf.putInt(stringCount);
                    buf.putInt(0);
                    buf.putInt(256);
                    IntWriter stringStart = new IntWriter(buf);
                    buf.putInt(0);
                    stringStart.write(buf.position() - startPos);
                }, () -> {
                    int i;
                    int stringOffset = 8 + 4 * this.stringsAsBytes.size();
                    for (i = 0; i < this.stringsAsBytes.size(); ++i) {
                        String string = this.strings.get(i);
                        byte[] bytes = this.stringsAsBytes.get(i);
                        buf.putInt(stringOffset);
                        stringOffset += this.lenLen(string.length()) + this.lenLen(bytes.length) + bytes.length + 1;
                    }
                    for (i = 0; i < this.stringsAsBytes.size(); ++i) {
                        this.writeLen(buf, this.strings.get(i).length());
                        this.writeLen(buf, this.stringsAsBytes.get(i).length);
                        buf.put(this.stringsAsBytes.get(i));
                        buf.put((byte)0);
                    }
                });
            }

            private int lenLen(int length) {
                return length > 127 ? 2 : 1;
            }

            private void writeLen(ByteBuffer buf, int length) {
                if (length <= 127) {
                    buf.put((byte)length);
                } else {
                    buf.put((byte)(length >> 8 | 0x80));
                    buf.put((byte)(length & 0x7F));
                }
            }

            public void freeze() {
                this.frozen = true;
            }
        }
    }

    public static class ResStringPool_ref {
        public static final int SIZEOF = 4;
        public final int index;

        public ResStringPool_ref(ByteBuffer buf, int offset) {
            this.index = buf.getInt(offset);
        }

        public static void write(ByteBuffer buf, int value) {
            buf.putInt(value);
        }

        public String toString() {
            return "ResStringPool_ref{index=" + this.index + '}';
        }
    }

    public static class ResTable_ref {
        public static final int SIZEOF = 4;
        public int ident;

        public ResTable_ref(ByteBuffer buf, int offset) {
            this.ident = buf.getInt(offset);
        }

        public ResTable_ref() {
            this.ident = 0;
        }

        public String toString() {
            return "ResTable_ref{ident=" + this.ident + '}';
        }
    }

    public static class Res_value {
        static final int SIZEOF = 8;
        final short size;
        public static final int TYPE_NULL = 0;
        public static final int TYPE_REFERENCE = 1;
        public static final int TYPE_ATTRIBUTE = 2;
        public static final int TYPE_STRING = 3;
        public static final int TYPE_FLOAT = 4;
        public static final int TYPE_DIMENSION = 5;
        public static final int TYPE_FRACTION = 6;
        public static final int TYPE_DYNAMIC_REFERENCE = 7;
        public static final int TYPE_DYNAMIC_ATTRIBUTE = 8;
        public static final int TYPE_FIRST_INT = 16;
        public static final int TYPE_INT_DEC = 16;
        public static final int TYPE_INT_HEX = 17;
        public static final int TYPE_INT_BOOLEAN = 18;
        public static final int TYPE_FIRST_COLOR_INT = 28;
        public static final int TYPE_INT_COLOR_ARGB8 = 28;
        public static final int TYPE_INT_COLOR_RGB8 = 29;
        public static final int TYPE_INT_COLOR_ARGB4 = 30;
        public static final int TYPE_INT_COLOR_RGB4 = 31;
        public static final int TYPE_LAST_COLOR_INT = 31;
        public static final int TYPE_LAST_INT = 31;
        public final byte dataType;
        public static final int COMPLEX_UNIT_SHIFT = 0;
        public static final int COMPLEX_UNIT_MASK = 15;
        public static final int COMPLEX_UNIT_PX = 0;
        public static final int COMPLEX_UNIT_DIP = 1;
        public static final int COMPLEX_UNIT_SP = 2;
        public static final int COMPLEX_UNIT_PT = 3;
        public static final int COMPLEX_UNIT_IN = 4;
        public static final int COMPLEX_UNIT_MM = 5;
        public static final int COMPLEX_UNIT_FRACTION = 0;
        public static final int COMPLEX_UNIT_FRACTION_PARENT = 1;
        public static final int COMPLEX_RADIX_SHIFT = 4;
        public static final int COMPLEX_RADIX_MASK = 3;
        public static final int COMPLEX_RADIX_23p0 = 0;
        public static final int COMPLEX_RADIX_16p7 = 1;
        public static final int COMPLEX_RADIX_8p15 = 2;
        public static final int COMPLEX_RADIX_0p23 = 3;
        public static final int COMPLEX_MANTISSA_SHIFT = 8;
        public static final int COMPLEX_MANTISSA_MASK = 0xFFFFFF;
        public static final int DATA_NULL_UNDEFINED = 0;
        public static final int DATA_NULL_EMPTY = 1;
        public static final Res_value NULL_VALUE = new Res_value(0, 0);
        public final int data;

        public Res_value() {
            this.size = 0;
            this.dataType = 0;
            this.data = 0;
        }

        public Res_value(ByteBuffer buf, int offset) {
            this.size = buf.getShort(offset);
            byte res0 = buf.get(offset + 2);
            this.dataType = buf.get(offset + 3);
            this.data = buf.getInt(offset + 4);
            if (res0 != 0) {
                throw new IllegalStateException("res0 != 0 (" + res0 + ")");
            }
        }

        public Res_value(Res_value other) {
            this.size = other.size;
            this.dataType = other.dataType;
            this.data = other.data;
        }

        public Res_value(byte dataType, int data) {
            this.size = (short)8;
            this.dataType = dataType;
            this.data = data;
        }

        public static void write(ByteBuffer buf, int dataType, int data) {
            buf.putShort((short)8);
            buf.put((byte)0);
            buf.put((byte)dataType);
            buf.putInt(data);
        }

        public Res_value withType(byte dataType) {
            return new Res_value(dataType, this.data);
        }

        public Res_value withData(int data) {
            return new Res_value(this.dataType, data);
        }

        public Res_value copy() {
            return new Res_value(this);
        }

        public String toString() {
            return "Res_value{dataType=" + this.dataType + ", data=" + this.data + '}';
        }
    }

    static class WithOffset {
        private final ByteBuffer buf;
        private final int offset;

        WithOffset(ByteBuffer buf, int offset) {
            this.buf = buf;
            this.offset = offset;
        }

        public final ByteBuffer myBuf() {
            return this.buf;
        }

        public final int myOffset() {
            return this.offset;
        }

        public String toString() {
            return "{buf+" + this.offset + '}';
        }
    }
}

