/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.admin.DevicePolicyResourcesManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=DevicePolicyResourcesManager.class, minSdk=33, isInAndroidSdk=false)
public class ShadowDevicePolicyResourcesManager {
    @RealObject
    DevicePolicyResourcesManager realDevicePolicyResourcesManager;
    private final Map<String, String> stringMappings = new HashMap<String, String>();

    public void setString(@NonNull String stringId, String value) {
        this.stringMappings.put(stringId, value);
    }

    @Implementation
    @Nullable
    protected String getString(@NonNull String stringId, @NonNull Supplier<String> defaultStringLoader) {
        String value = this.stringMappings.get(stringId);
        if (value != null) {
            return value;
        }
        return ((DevicePolicyResourcesManagerReflector)Reflector.reflector(DevicePolicyResourcesManagerReflector.class, (Object)this.realDevicePolicyResourcesManager)).getString(stringId, defaultStringLoader);
    }

    @ForType(value=DevicePolicyResourcesManager.class)
    static interface DevicePolicyResourcesManagerReflector {
        @Direct
        public String getString(@NonNull String var1, @NonNull Supplier<String> var2);
    }
}

