/*
 * Decompiled with CFR 0.152.
 */
package org.savara.bpel.parser.rules;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import org.savara.bpel.model.TProcess;
import org.savara.bpel.model.TScope;
import org.savara.bpel.model.TVariable;
import org.savara.bpel.parser.rules.ConversionContext;
import org.savara.bpel.parser.rules.ElseParserRule;
import org.savara.bpel.parser.rules.ElseifParserRule;
import org.savara.bpel.parser.rules.FlowParserRule;
import org.savara.bpel.parser.rules.IfParserRule;
import org.savara.bpel.parser.rules.InvokeParserRule;
import org.savara.bpel.parser.rules.PickParserRule;
import org.savara.bpel.parser.rules.ProcessParserRule;
import org.savara.bpel.parser.rules.ProtocolParserRule;
import org.savara.bpel.parser.rules.ReceiveParserRule;
import org.savara.bpel.parser.rules.ReplyParserRule;
import org.savara.bpel.parser.rules.ScopeParserRule;
import org.savara.bpel.parser.rules.SequenceParserRule;
import org.savara.bpel.parser.rules.WhileParserRule;
import org.scribble.common.logging.Journal;
import org.scribble.protocol.ProtocolContext;
import org.scribble.protocol.model.Activity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConversionContext
implements ConversionContext {
    private String m_role = null;
    private TProcess m_process = null;
    private ProtocolContext m_context = null;
    private Map<String, TVariable> m_variables = new HashMap<String, TVariable>();
    private Stack<TScope> m_scopeStack = new Stack();
    private static List<ProtocolParserRule> m_rules = new Vector<ProtocolParserRule>();

    public DefaultConversionContext(String role, TProcess proc, ProtocolContext context) {
        this.m_role = role;
        this.m_process = proc;
        this.m_context = context;
    }

    @Override
    public void convert(Object component, List<Activity> activities, Journal journal) {
        ProtocolParserRule rule = null;
        for (int i = 0; rule == null && i < m_rules.size(); ++i) {
            if (!m_rules.get(i).isSupported(component)) continue;
            rule = m_rules.get(i);
        }
        if (rule != null) {
            rule.convert(this, component, activities, journal);
        }
    }

    @Override
    public ProtocolContext getProtocolContext() {
        return this.m_context;
    }

    @Override
    public TProcess getProcess() {
        return this.m_process;
    }

    @Override
    public String getRole() {
        return this.m_role;
    }

    @Override
    public TVariable getVariable(String name) {
        return this.m_variables.get(name);
    }

    @Override
    public void addVariable(TVariable var) {
        this.m_variables.put(var.getName(), var);
    }

    @Override
    public void removeVariable(TVariable var) {
        this.m_variables.remove(var.getName());
    }

    @Override
    public void pushScope(TScope scope) {
        this.m_scopeStack.push(scope);
    }

    @Override
    public void popScope() {
        this.m_scopeStack.pop();
    }

    @Override
    public TScope getScope() {
        return this.m_scopeStack.size() > 0 ? this.m_scopeStack.peek() : null;
    }

    static {
        m_rules.add(new ElseParserRule());
        m_rules.add(new ElseifParserRule());
        m_rules.add(new FlowParserRule());
        m_rules.add(new IfParserRule());
        m_rules.add(new InvokeParserRule());
        m_rules.add(new PickParserRule());
        m_rules.add(new ProcessParserRule());
        m_rules.add(new ReceiveParserRule());
        m_rules.add(new ReplyParserRule());
        m_rules.add(new ScopeParserRule());
        m_rules.add(new SequenceParserRule());
        m_rules.add(new WhileParserRule());
    }
}

