/*
 * Decompiled with CFR 0.152.
 */
package org.savara.bpel.parser.rules;

import java.util.List;
import javax.xml.namespace.QName;
import org.savara.bpel.model.TCatch;
import org.savara.bpel.model.TInvoke;
import org.savara.bpel.model.TScope;
import org.savara.bpel.model.TVariable;
import org.savara.bpel.parser.rules.ParserContext;
import org.savara.bpel.parser.rules.ProtocolParserRule;
import org.savara.bpel.util.BPELInteractionUtil;
import org.savara.bpel.util.PartnerLinkUtil;
import org.savara.bpel.util.TypeReferenceUtil;
import org.savara.common.logging.FeedbackHandler;
import org.scribble.protocol.model.Activity;
import org.scribble.protocol.model.Choice;
import org.scribble.protocol.model.Interaction;
import org.scribble.protocol.model.MessageSignature;
import org.scribble.protocol.model.Raise;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.model.TypeReference;
import org.scribble.protocol.model.When;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvokeParserRule
implements ProtocolParserRule {
    @Override
    public boolean isSupported(Object component) {
        return component instanceof TInvoke;
    }

    @Override
    public void parse(ParserContext context, Object component, List<Activity> activities, FeedbackHandler handler) {
        TInvoke invoke = (TInvoke)component;
        InvokeParserRule.convertRequest(invoke, activities, context);
        TScope scope = context.getScope();
        if (scope != null && scope.getFaultHandlers() != null && (scope.getFaultHandlers().getCatch().size() > 0 || scope.getFaultHandlers().getCatchAll() != null)) {
            Choice te = new Choice();
            activities.add((Activity)te);
            When when = new When();
            te.getWhens().add(when);
            activities = when.getBlock().getContents();
            for (int i = 0; i < scope.getFaultHandlers().getCatch().size(); ++i) {
                TCatch catchBlock = scope.getFaultHandlers().getCatch().get(i);
                When fcb = new When();
                QName mesgType = catchBlock.getFaultMessageType();
                if (mesgType == null) {
                    mesgType = catchBlock.getFaultElement();
                }
                TVariable faultVar = null;
                if (catchBlock.getFaultVariable() != null) {
                    faultVar = new TVariable();
                    faultVar.setName(catchBlock.getFaultVariable());
                    faultVar.setMessageType(catchBlock.getFaultMessageType());
                    faultVar.setElement(catchBlock.getFaultElement());
                    context.addVariable(faultVar);
                }
                InvokeParserRule.convertFaultResponse(invoke, fcb.getBlock().getContents(), catchBlock.getFaultVariable(), mesgType, context);
                Raise raise = new Raise();
                TypeReference tref = new TypeReference();
                tref.setName(catchBlock.getFaultName().getLocalPart());
                raise.setType(tref);
                fcb.getBlock().add((Activity)raise);
                te.getWhens().add(fcb);
                if (faultVar == null) continue;
                context.removeVariable(faultVar);
            }
        }
        if (invoke.getOutputVariable() != null) {
            InvokeParserRule.convertResponse(invoke, activities, context);
        }
    }

    protected static void convertRequest(TInvoke invoke, List<Activity> activities, ParserContext context) {
        Interaction interaction = new Interaction();
        TVariable var = context.getVariable(invoke.getInputVariable());
        String xmlType = BPELInteractionUtil.getXMLType(context.getProcess(), var.getMessageType(), context.getResourceLocator());
        TypeReference tref = TypeReferenceUtil.createTypeReference(xmlType, context);
        MessageSignature ms = new MessageSignature();
        ms.setOperation(invoke.getOperation());
        ms.getTypeReferences().add(tref);
        String toRole = PartnerLinkUtil.getClientPartnerRole(invoke.getPartnerLink());
        if (toRole != null) {
            interaction.getToRoles().add(new Role(toRole));
        }
        interaction.setMessageSignature(ms);
        activities.add((Activity)interaction);
    }

    protected static void convertResponse(TInvoke invoke, List<Activity> activities, ParserContext context) {
        Interaction interaction = new Interaction();
        TVariable var = context.getVariable(invoke.getOutputVariable());
        String xmlType = BPELInteractionUtil.getXMLType(context.getProcess(), var.getMessageType(), context.getResourceLocator());
        TypeReference tref = TypeReferenceUtil.createTypeReference(xmlType, context);
        MessageSignature ms = new MessageSignature();
        ms.setOperation(invoke.getOperation());
        ms.getTypeReferences().add(tref);
        String fromRole = PartnerLinkUtil.getClientPartnerRole(invoke.getPartnerLink());
        if (fromRole != null) {
            interaction.setFromRole(new Role(fromRole));
        }
        interaction.setMessageSignature(ms);
        activities.add((Activity)interaction);
    }

    protected static void convertFaultResponse(TInvoke invoke, List<Activity> activities, String faultVar, QName faultMesgType, ParserContext context) {
        Interaction interaction = new Interaction();
        TypeReference tref = null;
        TVariable var = context.getVariable(faultVar);
        if (var != null) {
            String xmlType = BPELInteractionUtil.getXMLType(context.getProcess(), var.getMessageType(), context.getResourceLocator());
            tref = TypeReferenceUtil.createTypeReference(xmlType, context);
        } else if (faultMesgType != null) {
            tref = TypeReferenceUtil.createTypeReference(faultMesgType.getLocalPart(), context);
        }
        MessageSignature ms = new MessageSignature();
        ms.setOperation(invoke.getOperation());
        ms.getTypeReferences().add(tref);
        String fromRole = PartnerLinkUtil.getClientPartnerRole(invoke.getPartnerLink());
        if (fromRole != null) {
            interaction.setFromRole(new Role(fromRole));
        }
        interaction.setMessageSignature(ms);
        activities.add((Activity)interaction);
    }
}

