/*
 * Decompiled with CFR 0.152.
 */
package org.savara.bpel.parser.rules;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import org.savara.bpel.model.TProcess;
import org.savara.bpel.model.TScope;
import org.savara.bpel.model.TVariable;
import org.savara.bpel.parser.rules.ElseParserRule;
import org.savara.bpel.parser.rules.ElseifParserRule;
import org.savara.bpel.parser.rules.FlowParserRule;
import org.savara.bpel.parser.rules.IfParserRule;
import org.savara.bpel.parser.rules.InvokeParserRule;
import org.savara.bpel.parser.rules.ParserContext;
import org.savara.bpel.parser.rules.PickParserRule;
import org.savara.bpel.parser.rules.ProcessParserRule;
import org.savara.bpel.parser.rules.ProtocolParserRule;
import org.savara.bpel.parser.rules.ReceiveParserRule;
import org.savara.bpel.parser.rules.ReplyParserRule;
import org.savara.bpel.parser.rules.ScopeParserRule;
import org.savara.bpel.parser.rules.SequenceParserRule;
import org.savara.bpel.parser.rules.WhileParserRule;
import org.savara.common.logging.FeedbackHandler;
import org.savara.common.resources.ResourceLocator;
import org.scribble.protocol.model.Activity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultParserContext
implements ParserContext {
    private String m_role = null;
    private TProcess m_process = null;
    private ResourceLocator m_resourceLocator = null;
    private Map<String, TVariable> m_variables = new HashMap<String, TVariable>();
    private Stack<TScope> m_scopeStack = new Stack();
    private static List<ProtocolParserRule> m_rules = new Vector<ProtocolParserRule>();

    public DefaultParserContext(String role, TProcess proc, ResourceLocator locator) {
        this.m_role = role;
        this.m_process = proc;
        this.m_resourceLocator = locator;
    }

    @Override
    public void parse(Object component, List<Activity> activities, FeedbackHandler handler) {
        ProtocolParserRule rule = null;
        for (int i = 0; rule == null && i < m_rules.size(); ++i) {
            if (!m_rules.get(i).isSupported(component)) continue;
            rule = m_rules.get(i);
        }
        if (rule != null) {
            rule.parse(this, component, activities, handler);
        }
    }

    @Override
    public ResourceLocator getResourceLocator() {
        return this.m_resourceLocator;
    }

    @Override
    public TProcess getProcess() {
        return this.m_process;
    }

    @Override
    public String getRole() {
        return this.m_role;
    }

    @Override
    public TVariable getVariable(String name) {
        return this.m_variables.get(name);
    }

    @Override
    public void addVariable(TVariable var) {
        this.m_variables.put(var.getName(), var);
    }

    @Override
    public void removeVariable(TVariable var) {
        this.m_variables.remove(var.getName());
    }

    @Override
    public void pushScope(TScope scope) {
        this.m_scopeStack.push(scope);
    }

    @Override
    public void popScope() {
        this.m_scopeStack.pop();
    }

    @Override
    public TScope getScope() {
        return this.m_scopeStack.size() > 0 ? this.m_scopeStack.peek() : null;
    }

    static {
        m_rules.add(new ElseParserRule());
        m_rules.add(new ElseifParserRule());
        m_rules.add(new FlowParserRule());
        m_rules.add(new IfParserRule());
        m_rules.add(new InvokeParserRule());
        m_rules.add(new PickParserRule());
        m_rules.add(new ProcessParserRule());
        m_rules.add(new ReceiveParserRule());
        m_rules.add(new ReplyParserRule());
        m_rules.add(new ScopeParserRule());
        m_rules.add(new SequenceParserRule());
        m_rules.add(new WhileParserRule());
    }
}

