/*
 * Decompiled with CFR 0.152.
 */
package org.savara.bpel.generator;

import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.List;
import org.savara.bpel.model.TProcess;
import org.savara.bpel.model.change.BPELModelChangeContext;
import org.savara.bpel.util.BPELModelUtil;
import org.savara.common.logging.DefaultFeedbackHandler;
import org.savara.common.logging.FeedbackHandler;
import org.savara.common.model.annotation.Annotation;
import org.savara.common.model.annotation.AnnotationDefinitions;
import org.savara.common.model.generator.ModelGenerator;
import org.savara.common.resources.ResourceLocator;
import org.scribble.protocol.model.ModelObject;
import org.scribble.protocol.model.ProtocolModel;

public class ProtocolToBPELModelGenerator
implements ModelGenerator {
    public boolean isSupported(Object source, String targetType) {
        return source instanceof ProtocolModel && ((ProtocolModel)source).isLocated() && targetType.equals("bpel");
    }

    public Object generate(Object source, FeedbackHandler handler, ResourceLocator locator) {
        BPELModelChangeContext context = new BPELModelChangeContext(null, (FeedbackHandler)new DefaultFeedbackHandler());
        ProtocolModel pm = (ProtocolModel)source;
        String process = "<process xmlns=\"http://docs.oasis-open.org/wsbpel/2.0/process/executable\" ";
        HashMap<String, String> prefixes = new HashMap<String, String>();
        List list = AnnotationDefinitions.getAnnotations((List)pm.getProtocol().getAnnotations(), (String)"Type");
        for (Annotation annotation : list) {
            if (!annotation.getProperties().containsKey("namespace") || !annotation.getProperties().containsKey("prefix")) continue;
            prefixes.put((String)annotation.getProperties().get("namespace"), (String)annotation.getProperties().get("prefix"));
            process = process + "xmlns:" + (String)annotation.getProperties().get("prefix") + "=\"" + (String)annotation.getProperties().get("namespace") + "\" ";
        }
        process = process + "/>";
        TProcess bpel = null;
        try {
            ByteArrayInputStream io = new ByteArrayInputStream(process.getBytes());
            bpel = BPELModelUtil.deserialize(io);
            io.close();
        }
        catch (Exception e) {
            handler.error("Failed to create initial BPEL process", null);
        }
        context.setParent(bpel);
        ProtocolModel bpelModel = new ProtocolModel();
        bpelModel.getProperties().put("bpel.model", bpel);
        context.insert(bpelModel, (ModelObject)pm, null);
        return bpel;
    }
}

