/*
 * Decompiled with CFR 0.152.
 */
package org.savara.bpel.parser.rules;

import java.util.List;
import javax.xml.namespace.QName;
import org.savara.bpel.model.TCatch;
import org.savara.bpel.model.TInvoke;
import org.savara.bpel.model.TScope;
import org.savara.bpel.model.TVariable;
import org.savara.bpel.parser.rules.ParserContext;
import org.savara.bpel.parser.rules.ProtocolParserRule;
import org.savara.bpel.util.BPELInteractionUtil;
import org.savara.bpel.util.PartnerLinkUtil;
import org.savara.bpel.util.TypeReferenceUtil;
import org.savara.common.logging.FeedbackHandler;
import org.savara.common.model.annotation.Annotation;
import org.scribble.protocol.model.Activity;
import org.scribble.protocol.model.Block;
import org.scribble.protocol.model.Choice;
import org.scribble.protocol.model.Interaction;
import org.scribble.protocol.model.MessageSignature;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.model.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvokeParserRule
implements ProtocolParserRule {
    @Override
    public boolean isSupported(Object component) {
        return component instanceof TInvoke;
    }

    @Override
    public void parse(ParserContext context, Object component, List<Activity> activities, FeedbackHandler handler) {
        TInvoke invoke = (TInvoke)component;
        InvokeParserRule.convertRequest(invoke, activities, context);
        TScope scope = context.getScope();
        if (scope != null && scope.getFaultHandlers() != null && (scope.getFaultHandlers().getCatch().size() > 0 || scope.getFaultHandlers().getCatchAll() != null)) {
            Choice te = new Choice();
            activities.add((Activity)te);
            Block when = new Block();
            te.getPaths().add(when);
            activities = when.getContents();
            for (int i = 0; i < scope.getFaultHandlers().getCatch().size(); ++i) {
                TCatch catchBlock = scope.getFaultHandlers().getCatch().get(i);
                Block fcb = new Block();
                QName mesgType = catchBlock.getFaultMessageType();
                if (mesgType == null) {
                    mesgType = catchBlock.getFaultElement();
                }
                TVariable faultVar = null;
                if (catchBlock.getFaultVariable() != null) {
                    faultVar = new TVariable();
                    faultVar.setName(catchBlock.getFaultVariable());
                    faultVar.setMessageType(catchBlock.getFaultMessageType());
                    faultVar.setElement(catchBlock.getFaultElement());
                    context.addVariable(faultVar);
                }
                InvokeParserRule.convertFaultResponse(invoke, fcb.getContents(), catchBlock.getFaultVariable(), catchBlock.getFaultName(), mesgType, context);
                te.getPaths().add(fcb);
                if (faultVar == null) continue;
                context.removeVariable(faultVar);
            }
        }
        if (invoke.getOutputVariable() != null) {
            InvokeParserRule.convertResponse(invoke, activities, context);
        }
    }

    protected static void convertRequest(TInvoke invoke, List<Activity> activities, ParserContext context) {
        Interaction interaction = new Interaction();
        TVariable var = context.getVariable(invoke.getInputVariable());
        String xmlType = BPELInteractionUtil.getXMLType(context.getProcess(), var.getMessageType(), context.getResourceLocator());
        TypeReference tref = TypeReferenceUtil.createTypeReference(xmlType, context);
        MessageSignature ms = new MessageSignature();
        ms.setOperation(invoke.getOperation());
        ms.getTypeReferences().add(tref);
        String toRole = PartnerLinkUtil.getClientPartnerRole(invoke.getPartnerLink());
        if (toRole != null) {
            interaction.getToRoles().add(new Role(toRole));
        }
        interaction.setMessageSignature(ms);
        Annotation annotation = new Annotation("Correlation");
        annotation.getProperties().put("request", invoke.getOperation());
        interaction.getAnnotations().add(annotation);
        activities.add((Activity)interaction);
    }

    protected static void convertResponse(TInvoke invoke, List<Activity> activities, ParserContext context) {
        if (invoke.getOutputVariable() == null) {
            return;
        }
        Interaction interaction = new Interaction();
        TVariable var = context.getVariable(invoke.getOutputVariable());
        String xmlType = BPELInteractionUtil.getXMLType(context.getProcess(), var.getMessageType(), context.getResourceLocator());
        TypeReference tref = TypeReferenceUtil.createTypeReference(xmlType, context);
        MessageSignature ms = new MessageSignature();
        ms.setOperation(invoke.getOperation());
        ms.getTypeReferences().add(tref);
        String fromRole = PartnerLinkUtil.getClientPartnerRole(invoke.getPartnerLink());
        if (fromRole != null) {
            interaction.setFromRole(new Role(fromRole));
        }
        interaction.setMessageSignature(ms);
        Annotation annotation = new Annotation("Correlation");
        annotation.getProperties().put("replyTo", invoke.getOperation());
        interaction.getAnnotations().add(annotation);
        activities.add((Activity)interaction);
    }

    protected static void convertFaultResponse(TInvoke invoke, List<Activity> activities, String faultVar, QName faultName, QName faultMesgType, ParserContext context) {
        Interaction interaction = new Interaction();
        TypeReference tref = null;
        TVariable var = context.getVariable(faultVar);
        if (var != null) {
            String xmlType = BPELInteractionUtil.getXMLType(context.getProcess(), var.getMessageType(), context.getResourceLocator());
            tref = TypeReferenceUtil.createTypeReference(xmlType, context);
        } else if (faultMesgType != null) {
            tref = TypeReferenceUtil.createTypeReference(faultMesgType.getLocalPart(), context);
        }
        MessageSignature ms = new MessageSignature();
        ms.setOperation(invoke.getOperation());
        ms.getTypeReferences().add(tref);
        String fromRole = PartnerLinkUtil.getClientPartnerRole(invoke.getPartnerLink());
        if (fromRole != null) {
            interaction.setFromRole(new Role(fromRole));
        }
        interaction.setMessageSignature(ms);
        Annotation annotation = new Annotation("Fault");
        annotation.getProperties().put("name", faultName.getLocalPart());
        interaction.getAnnotations().add(annotation);
        annotation = new Annotation("Correlation");
        annotation.getProperties().put("replyTo", invoke.getOperation());
        interaction.getAnnotations().add(annotation);
        activities.add((Activity)interaction);
    }
}

