/*
 * Decompiled with CFR 0.152.
 */
package org.savara.bpel.parser.rules;

import java.util.List;
import org.savara.bpel.model.TReceive;
import org.savara.bpel.model.TVariable;
import org.savara.bpel.parser.rules.ParserContext;
import org.savara.bpel.parser.rules.ProtocolParserRule;
import org.savara.bpel.util.BPELInteractionUtil;
import org.savara.bpel.util.PartnerLinkUtil;
import org.savara.bpel.util.TypeReferenceUtil;
import org.savara.common.logging.FeedbackHandler;
import org.savara.common.model.annotation.Annotation;
import org.scribble.protocol.model.Activity;
import org.scribble.protocol.model.Interaction;
import org.scribble.protocol.model.MessageSignature;
import org.scribble.protocol.model.Role;
import org.scribble.protocol.model.TypeReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReceiveParserRule
implements ProtocolParserRule {
    @Override
    public boolean isSupported(Object component) {
        return component instanceof TReceive;
    }

    @Override
    public void parse(ParserContext context, Object component, List<Activity> activities, FeedbackHandler handler) {
        TReceive elem = (TReceive)component;
        Interaction interaction = new Interaction();
        TVariable var = context.getVariable(elem.getVariable());
        String xmlType = BPELInteractionUtil.getXMLType(context.getProcess(), var.getMessageType(), context.getResourceLocator());
        TypeReference tref = TypeReferenceUtil.createTypeReference(xmlType, context);
        MessageSignature ms = new MessageSignature();
        ms.setOperation(elem.getOperation());
        ms.getTypeReferences().add(tref);
        String fromRole = PartnerLinkUtil.getServerPartnerRole(elem.getPartnerLink());
        if (fromRole != null && fromRole.equals(context.getRole())) {
            fromRole = PartnerLinkUtil.getClientPartnerRole(elem.getPartnerLink());
        }
        if (fromRole != null) {
            interaction.setFromRole(new Role(fromRole));
            if (!context.getIntroducers().containsKey(context.getRole())) {
                context.getIntroducers().put(context.getRole(), fromRole);
            }
        }
        interaction.setMessageSignature(ms);
        Annotation annotation = new Annotation("Correlation");
        annotation.getProperties().put("request", elem.getOperation());
        interaction.getAnnotations().add(annotation);
        activities.add((Activity)interaction);
    }
}

