/*
 * Decompiled with CFR 0.152.
 */
package org.savara.contract.model;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import org.savara.contract.model.ContractObject;
import org.savara.contract.model.Interface;
import org.savara.contract.model.Namespace;
import org.savara.contract.model.TypeDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Contract
extends ContractObject {
    private String m_name = null;
    private String m_namespace = null;
    private Set<Interface> m_interfaces = new HashSet<Interface>();
    private Set<Namespace> m_namespaces = new HashSet<Namespace>();
    private Set<TypeDefinition> m_typeDefinitions = new HashSet<TypeDefinition>();

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getNamespace() {
        return this.m_namespace;
    }

    public void setNamespace(String namespace) {
        this.m_namespace = namespace;
    }

    public Set<Interface> getInterfaces() {
        return this.m_interfaces;
    }

    public Set<TypeDefinition> getTypeDefinitions() {
        return this.m_typeDefinitions;
    }

    public TypeDefinition getTypeDefinition(String name) {
        TypeDefinition ret = null;
        Iterator<TypeDefinition> iter = this.getTypeDefinitions().iterator();
        while (ret == null && iter.hasNext()) {
            ret = iter.next();
            if (ret.getName().equals(name)) continue;
            ret = null;
        }
        return ret;
    }

    public Interface getInterface(String namespace, String name) {
        Interface ret = null;
        Iterator<Interface> iter = this.getInterfaces().iterator();
        while (ret == null && iter.hasNext()) {
            ret = iter.next();
            if (ret.getName().equals(name) && (namespace == null || ret.getNamespace().equals(namespace))) continue;
            ret = null;
        }
        return ret;
    }

    public Set<Namespace> getNamespaces() {
        return this.m_namespaces;
    }

    public Namespace getNamespaceForURI(String uri) {
        Namespace ret = null;
        for (Namespace ns : this.m_namespaces) {
            if (ns.getURI() == null || !ns.getURI().equals(uri)) continue;
            ret = ns;
            break;
        }
        return ret;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Contract {" + this.m_namespace + "}" + this.m_name + " {\r\n");
        Vector<Namespace> nslist = new Vector<Namespace>(this.getNamespaces());
        Collections.sort(nslist, new Comparator<Namespace>(){

            @Override
            public int compare(Namespace arg0, Namespace arg1) {
                return arg0.getURI().compareTo(arg1.getURI());
            }
        });
        for (Namespace ns : nslist) {
            buf.append(ns.toString());
        }
        Vector<TypeDefinition> tdlist = new Vector<TypeDefinition>(this.getTypeDefinitions());
        Collections.sort(tdlist, new Comparator<TypeDefinition>(){

            @Override
            public int compare(TypeDefinition arg0, TypeDefinition arg1) {
                return arg0.getName().compareTo(arg1.getName());
            }
        });
        for (TypeDefinition td : tdlist) {
            buf.append(td.toString());
        }
        Vector<Interface> intflist = new Vector<Interface>(this.getInterfaces());
        Collections.sort(intflist, new Comparator<Interface>(){

            @Override
            public int compare(Interface arg0, Interface arg1) {
                return arg0.getName().compareTo(arg1.getName());
            }
        });
        for (Interface intf : intflist) {
            buf.append(intf.toString());
        }
        buf.append("}\r\n");
        return buf.toString();
    }
}

