/*
 * Decompiled with CFR 0.152.
 */
package org.savara.scenario.simulation;

import java.util.List;
import java.util.UUID;
import org.savara.monitor.ConversationInstanceId;
import org.savara.monitor.Message;
import org.savara.monitor.Monitor;
import org.savara.scenario.model.Event;
import org.savara.scenario.model.MessageEvent;
import org.savara.scenario.model.ReceiveEvent;
import org.savara.scenario.model.Role;
import org.savara.scenario.model.Scenario;
import org.savara.scenario.model.SendEvent;
import org.savara.scenario.simulation.ScenarioSimulator;
import org.savara.scenario.simulation.SimulationHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultScenarioSimulator
implements ScenarioSimulator {
    private Monitor m_monitor = null;

    @Override
    public void setMonitor(Monitor monitor) {
        this.m_monitor = monitor;
    }

    @Override
    public void simulate(Scenario scenario, SimulationHandler handler) {
        ConversationInstanceId cid = new ConversationInstanceId(UUID.randomUUID().toString());
        this.simulateEvents(cid, scenario.getEvent(), handler);
    }

    protected void simulateEvents(ConversationInstanceId cid, List<Event> events, SimulationHandler handler) {
        for (Event event : events) {
            if (event instanceof SendEvent) {
                this.handleSendEvent(cid, (SendEvent)event, handler);
                continue;
            }
            if (event instanceof ReceiveEvent) {
                this.handleReceiveEvent(cid, (ReceiveEvent)event, handler);
                continue;
            }
            handler.unknownEvent(event);
        }
    }

    protected Message getMessageForEvent(MessageEvent event) {
        Message mesg = new Message();
        mesg.setOperator(event.getOperationName());
        mesg.getTypes().add(event.getType());
        mesg.getValues().add(event.getValue());
        return mesg;
    }

    protected void handleSendEvent(ConversationInstanceId cid, SendEvent event, SimulationHandler handler) {
        try {
            Message mesg = this.getMessageForEvent(event);
            mesg.setSourceEndpointType(((Role)event.getRole()).getName());
            this.m_monitor.process(null, cid, mesg);
        }
        catch (Exception e) {
            handler.exception("Failed when handling send event", event, e);
        }
    }

    protected void handleReceiveEvent(ConversationInstanceId cid, ReceiveEvent event, SimulationHandler handler) {
        try {
            Message mesg = this.getMessageForEvent(event);
            mesg.setDestinationEndpointType(((Role)event.getRole()).getName());
            this.m_monitor.process(null, cid, mesg);
        }
        catch (Exception e) {
            handler.exception("Failed when handling receive event", event, e);
        }
    }
}

