/*
 * Decompiled with CFR 0.152.
 */
package org.savara.scenario.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.savara.scenario.simulation.model.ObjectFactory;
import org.savara.scenario.simulation.model.Simulation;

public class SimulationModelUtil {
    public static Simulation deserialize(InputStream is) throws IOException {
        Simulation ret = null;
        try {
            JAXBContext context = JAXBContext.newInstance((String)"org.savara.scenario.simulation.model", (ClassLoader)SimulationModelUtil.class.getClassLoader());
            Unmarshaller unmarshaller = context.createUnmarshaller();
            Object xmlObject = unmarshaller.unmarshal(is);
            if (xmlObject instanceof JAXBElement) {
                ret = (Simulation)((JAXBElement)xmlObject).getValue();
            }
        }
        catch (Exception e) {
            throw new IOException("Failed to deserialize scenario simulation", e);
        }
        return ret;
    }

    public static void serialize(Simulation simulation, OutputStream os) throws IOException {
        try {
            ObjectFactory factory = new ObjectFactory();
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Simulation.class});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal(factory.createSimulation(simulation), os);
        }
        catch (Exception e) {
            throw new IOException("Failed to serialize scenario simulation", e);
        }
    }
}

