/*
 * Decompiled with CFR 0.152.
 */
package org.savara.scenario.simulation;

import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.savara.common.logging.MessageFormatter;
import org.savara.scenario.model.Event;
import org.savara.scenario.model.Role;
import org.savara.scenario.model.RoleEvent;
import org.savara.scenario.model.Scenario;
import org.savara.scenario.simulation.RoleSimulator;
import org.savara.scenario.simulation.ScenarioSimulator;
import org.savara.scenario.simulation.SimulationContext;
import org.savara.scenario.simulation.SimulationHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultScenarioSimulator
implements ScenarioSimulator {
    private static final Logger LOG = Logger.getLogger(DefaultScenarioSimulator.class.getName());

    @Override
    public void simulate(Scenario scenario, Map<Role, RoleSimulator> roleSimulators, Map<Role, SimulationContext> contexts, SimulationHandler handler) throws Exception {
        RoleSimulator rsim;
        for (Role role : contexts.keySet()) {
            rsim = roleSimulators.get(role);
            handler.roleStart(role);
            if (rsim == null) continue;
            try {
                rsim.initialize(contexts.get(role));
                handler.roleInitialized(role);
            }
            catch (Throwable t) {
                LOG.log(Level.SEVERE, "Failed to initialize role '" + role.getName() + "'", t);
                handler.roleFailed(role, "Failed to initialize role simulator");
            }
        }
        for (Event event : scenario.getEvent()) {
            handler.start(event);
            if (event instanceof RoleEvent) {
                this.simulateAtRole((Role)((RoleEvent)event).getRole(), event, roleSimulators, contexts, handler);
            } else {
                for (Role role : roleSimulators.keySet()) {
                    this.simulateAtRole(role, event, roleSimulators, contexts, handler);
                }
            }
            handler.end(event);
        }
        for (Role role : contexts.keySet()) {
            rsim = roleSimulators.get(role);
            if (rsim == null) continue;
            rsim.close(contexts.get(role));
        }
    }

    protected void simulateAtRole(Role role, Event event, Map<Role, RoleSimulator> roleSimulators, Map<Role, SimulationContext> contexts, SimulationHandler handler) {
        RoleSimulator sim = roleSimulators.get(role);
        if (sim != null) {
            SimulationContext context = contexts.get(role);
            if (context != null) {
                sim.onEvent(context, event, handler);
            } else {
                handler.error(MessageFormatter.format((ResourceBundle)PropertyResourceBundle.getBundle("org.savara.scenario.Messages"), (String)"SAVARA-SCENARIO-00001", (Object[])new Object[]{role.getName()}), event, null);
            }
        } else {
            handler.noSimulator(event);
        }
    }
}

