/*
 * Decompiled with CFR 0.152.
 */
package org.savara.switchyard.bpel.generator;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import org.savara.common.util.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwitchyardBPELGenerator {
    private static final Logger logger = Logger.getLogger(SwitchyardBPELGenerator.class.getName());

    public Element createSwitchyardDescriptor(String name, Element descriptor, Map<String, Definition> wsdls) throws Exception {
        Element ret = null;
        StringBuffer composite = new StringBuffer();
        composite.append("<switchyard xmlns=\"urn:switchyard-config:switchyard:1.0\"\r\n");
        composite.append("\t\txmlns:swyd=\"urn:switchyard-config:switchyard:1.0\"\r\n");
        composite.append("\t\txmlns:trfm=\"urn:switchyard-config:transform:1.0\"\r\n");
        composite.append("\t\txmlns:bean=\"urn:switchyard-component-bean:config:1.0\"\r\n");
        composite.append("\t\txmlns:soap=\"urn:switchyard-component-soap:config:1.0\"\r\n");
        composite.append("\t\txmlns:bpel=\"http://docs.oasis-open.org/ns/opencsa/sca/200903\"\r\n");
        composite.append("\t\txmlns:sca=\"http://docs.oasis-open.org/ns/opencsa/sca/200912\"\r\n");
        NamedNodeMap attrs = descriptor.getAttributes();
        HashMap<String, String> namespaces = new HashMap<String, String>();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (!attr.getName().startsWith("xmlns:")) continue;
            namespaces.put(attr.getName().substring(6), attr.getValue());
            composite.append("\t\t" + attr.getName() + "=\"" + attr.getValue() + "\"\r\n");
        }
        composite.append("\t\ttargetNamespace=\"" + descriptor.getAttribute("xmlns") + "\"\r\n");
        composite.append("\t\tname=\"" + name + "\">\r\n");
        composite.append("\t<sca:composite name=\"" + name + "\" targetNamespace=\"" + descriptor.getAttribute("xmlns") + "\">\r\n");
        NodeList nl = descriptor.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!(n instanceof Element) || !XMLUtils.getLocalname((String)n.getNodeName()).equals("process")) continue;
            Element process = (Element)n;
            composite.append(this.generateServices(process, wsdls, namespaces));
            composite.append(this.generateComponent(process, wsdls, namespaces));
        }
        composite.append("\t</sca:composite>\r\n");
        composite.append("</switchyard>\r\n");
        ret = (Element)XMLUtils.getNode((String)composite.toString());
        return ret;
    }

    protected String generateServices(Element process, Map<String, Definition> wsdls, Map<String, String> namespaces) {
        StringBuffer ret = new StringBuffer();
        String name = this.getComponentName(process);
        ret.append("\t\t<sca:service name=\"" + name + "\" promote=\"" + name + "\">\r\n");
        ret.append("\t\t\t<soap:binding.soap>\r\n");
        NodeList nl = process.getElementsByTagName("provide");
        Vector<String> wsdlPaths = new Vector<String>();
        for (int i = 0; i < nl.getLength(); ++i) {
            Element service;
            String wsdlInterfacePath;
            NodeList services;
            Node n = nl.item(i);
            if (!(n instanceof Element) || (services = ((Element)n).getElementsByTagName("service")).getLength() != 1 || !(services.item(0) instanceof Element) || wsdlPaths.contains(wsdlInterfacePath = this.getInterfacePath(service = (Element)services.item(0), wsdls, namespaces))) continue;
            ret.append("\t\t\t\t<soap:wsdl>" + wsdlInterfacePath + "</soap:wsdl>\r\n");
            wsdlPaths.add(wsdlInterfacePath);
        }
        ret.append("\t\t\t\t<soap:socketAddr>:18001</soap:socketAddr>\r\n");
        ret.append("\t\t\t</soap:binding.soap>\r\n");
        ret.append("\t\t</sca:service>\r\n");
        return ret.toString();
    }

    protected String generateComponent(Element process, Map<String, Definition> wsdls, Map<String, String> namespaces) {
        String wsdlInterface;
        Element service;
        NodeList services;
        Node n;
        int i;
        StringBuffer ret = new StringBuffer();
        ret.append("\t\t<sca:component name=\"" + this.getComponentName(process) + "\">\r\n");
        ret.append("\t\t\t<bpel:implementation.bpel process=\"" + process.getAttribute("name") + "\" />\r\n");
        NodeList nl = process.getElementsByTagName("provide");
        for (i = 0; i < nl.getLength(); ++i) {
            n = nl.item(i);
            if (!(n instanceof Element) || (services = ((Element)n).getElementsByTagName("service")).getLength() != 1 || !(services.item(0) instanceof Element)) continue;
            service = (Element)services.item(0);
            wsdlInterface = this.getInterfaceDetails(service, wsdls, namespaces);
            ret.append("\t\t\t<sca:service name=\"" + this.getServiceName(service) + "\" >\r\n");
            ret.append("\t\t\t\t<sca:interface.wsdl interface=\"" + wsdlInterface + "\"/>\r\n");
            ret.append("\t\t\t</sca:service>\r\n");
        }
        nl = process.getElementsByTagName("invoke");
        for (i = 0; i < nl.getLength(); ++i) {
            n = nl.item(i);
            if (!(n instanceof Element) || (services = ((Element)n).getElementsByTagName("service")).getLength() != 1 || !(services.item(0) instanceof Element)) continue;
            service = (Element)services.item(0);
            wsdlInterface = this.getInterfaceDetails(service, wsdls, namespaces);
            ret.append("\t\t\t<sca:reference name=\"" + this.getServiceName(service) + "\" >\r\n");
            ret.append("\t\t\t\t<sca:interface.wsdl interface=\"" + wsdlInterface + "\"/>\r\n");
            ret.append("\t\t\t</sca:reference>\r\n");
        }
        ret.append("\t\t</sca:component>\r\n");
        return ret.toString();
    }

    protected String getInterfaceDetails(Element service, Map<String, Definition> wsdls, Map<String, String> namespaces) {
        String ret = null;
        String namespace = null;
        String localPart = service.getAttribute("name");
        int index = localPart.indexOf(58);
        if (index != -1) {
            namespace = namespaces.get(localPart.substring(0, index));
            localPart = localPart.substring(index + 1);
        }
        QName qname = new QName(namespace, localPart);
        for (String path : wsdls.keySet()) {
            Definition wsdl = wsdls.get(path);
            Service serv = wsdl.getService(qname);
            if (serv == null) continue;
            Port port = (Port)serv.getPorts().values().iterator().next();
            if (port != null) {
                String portType = port.getBinding().getPortType().getQName().getLocalPart();
                ret = path + "#wsdl.porttype(" + portType + ")";
                break;
            }
            logger.severe("Unable to find port type associated with service '" + qname + "'");
            break;
        }
        return ret;
    }

    protected String getInterfacePath(Element service, Map<String, Definition> wsdls, Map<String, String> namespaces) {
        String ret = null;
        String namespace = null;
        String localPart = service.getAttribute("name");
        int index = localPart.indexOf(58);
        if (index != -1) {
            namespace = namespaces.get(localPart.substring(0, index));
            localPart = localPart.substring(index + 1);
        }
        QName qname = new QName(namespace, localPart);
        for (String path : wsdls.keySet()) {
            Definition wsdl = wsdls.get(path);
            Service serv = wsdl.getService(qname);
            if (serv == null) continue;
            ret = path;
            break;
        }
        return ret;
    }

    protected String getComponentName(Element process) {
        String ret = process.getAttribute("name");
        int index = ret.indexOf(58);
        if (index != -1) {
            ret = ret.substring(index + 1);
        }
        return ret;
    }

    protected String getServiceName(Element service) {
        String ret = service.getAttribute("name");
        int index = ret.indexOf(58);
        if (index != -1) {
            ret = ret.substring(index + 1);
        }
        return ret;
    }
}

