/*
 * Decompiled with CFR 0.152.
 */
package org.savara.switchyard.java.generator;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.wsdl.Definition;
import javax.wsdl.PortType;
import org.savara.common.resources.ResourceLocator;
import org.savara.java.generator.JavaBehaviourGenerator;
import org.savara.java.generator.JavaServiceGenerator;
import org.scribble.protocol.model.ProtocolModel;
import org.scribble.protocol.model.Role;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwitchyardJavaGenerator
extends JavaServiceGenerator {
    private static final Logger logger = Logger.getLogger(SwitchyardJavaGenerator.class.getName());

    public static void main(String[] args) {
        SwitchyardJavaGenerator gen = new SwitchyardJavaGenerator();
        if (args.length != 3) {
            System.err.println("Usage: SwitchyardJavaGenerator WSDLPath RelativeWSDLLocation DestinationFolder");
        }
        try {
            gen.createServiceInterfaceFromWSDL(args[0], args[1], args[2]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createServiceImplementationFromWSDL(Role role, List<Role> refRoles, ProtocolModel behaviour, String wsdlPath, String wsdlLocation, List<String> refWsdlPaths, String srcFolder, ResourceLocator locator) throws Exception {
        super.createServiceImplementationFromWSDL(role, refRoles, behaviour, wsdlPath, wsdlLocation, refWsdlPaths, srcFolder, locator);
        Definition defn = this.getWSDLReader().readWSDL(wsdlPath);
        if (defn != null) {
            String pack = JavaBehaviourGenerator.getJavaPackage((String)defn.getTargetNamespace());
            String folder = pack.replace('.', File.separatorChar);
            for (PortType portType : defn.getPortTypes().values()) {
                File f = new File(srcFolder + File.separatorChar + folder + File.separatorChar + portType.getQName().getLocalPart() + "Impl.java");
                if (f.exists()) {
                    this.makeSwitchyardService(f, portType, srcFolder);
                    this.addServiceReferencesToImplementation(f, role, refRoles, refWsdlPaths, srcFolder);
                    this.addServiceBehaviour(f, role, refRoles, behaviour, srcFolder, locator);
                    continue;
                }
                logger.severe("Service file '" + f.getAbsolutePath() + "' does not exist");
            }
        } else {
            logger.severe("Failed to retrieve WSDL definition '" + wsdlPath + "'");
        }
    }

    protected void makeSwitchyardService(File implFile, PortType portType, String srcFolder) throws Exception {
        FileInputStream fis = new FileInputStream(implFile);
        byte[] b = new byte[fis.available()];
        fis.read(b);
        StringBuffer text = new StringBuffer();
        text.append(new String(b));
        fis.close();
        int startindex = text.indexOf("import");
        int endindex = text.indexOf("public class");
        if (startindex != -1 && endindex != -1) {
            text.replace(startindex, endindex, "import java.util.logging.Logger;\r\n\r\n@org.switchyard.component.bean.Service(" + portType.getQName().getLocalPart() + ".class)\r\n");
            FileOutputStream fos = new FileOutputStream(implFile);
            fos.write(text.toString().getBytes());
            fos.close();
        } else {
            logger.severe("Service file '" + implFile.getAbsolutePath() + "' could not change to switchyard Service annotation");
        }
    }

    protected void addServiceReferencesToImplementation(File implFile, Role role, List<Role> refRoles, List<String> refWsdlPaths, String srcFolder) throws Exception {
        if (refRoles.size() != refWsdlPaths.size()) {
            throw new IllegalArgumentException("The number of reference roles and wsdl paths are not consistent");
        }
        FileInputStream fis = new FileInputStream(implFile);
        byte[] b = new byte[fis.available()];
        fis.read(b);
        StringBuffer text = new StringBuffer();
        text.append(new String(b));
        fis.close();
        int index = text.indexOf("private static final Logger");
        if (index != -1) {
            for (int i = 0; i < refRoles.size(); ++i) {
                Definition refDefn = this.getWSDLReader().readWSDL(refWsdlPaths.get(i));
                if (refDefn == null) continue;
                String refPack = JavaBehaviourGenerator.getJavaPackage((String)refDefn.getTargetNamespace());
                Iterator refPortTypes = refDefn.getPortTypes().values().iterator();
                int refPortCount = 1;
                while (refPortTypes.hasNext()) {
                    PortType refPortType = (PortType)refPortTypes.next();
                    String name = JavaBehaviourGenerator.getVariableName((String)refRoles.get(i).getName());
                    if (refDefn.getPortTypes().size() > 1) {
                        name = name + refPortCount;
                    }
                    text.insert(index, "@javax.inject.Inject @org.switchyard.component.bean.Reference\r\n    " + refPack + "." + refPortType.getQName().getLocalPart() + " _" + name + ";\r\n\r\n    ");
                }
            }
            FileOutputStream fos = new FileOutputStream(implFile);
            fos.write(text.toString().getBytes());
            fos.close();
        } else {
            logger.severe("Service implementation file '" + implFile.getAbsolutePath() + "' does not have 'private static final Logger' as location to insert references");
        }
    }

    public void createServiceComposite(Role role, List<Role> refRoles, String wsdlPath, List<String> refWsdlPaths, String resourceFolder) throws Exception {
        Definition defn = this.getWSDLReader().readWSDL(wsdlPath);
        if (defn != null) {
            StringBuffer composite = new StringBuffer();
            String targetNamespace = defn.getTargetNamespace();
            String name = role.getName();
            composite.append("<switchyard xmlns=\"urn:switchyard-config:switchyard:1.0\"\r\n");
            composite.append("\t\ttargetNamespace=\"" + targetNamespace + "\"\r\n");
            composite.append("\t\tname=\"" + name + "\">\r\n");
            composite.append("\t<composite xmlns=\"http://docs.oasis-open.org/ns/opencsa/sca/200912\"\r\n");
            composite.append("\t\t\ttargetNamespace=\"");
            composite.append(targetNamespace);
            composite.append("\"\r\n\t\t\tname=\"");
            composite.append(name);
            composite.append("\" >\r\n");
            for (PortType portType : defn.getPortTypes().values()) {
                String wsdlName = wsdlPath;
                int ind = wsdlName.lastIndexOf(47);
                if (ind != -1) {
                    wsdlName = wsdlName.substring(ind + 1);
                }
                composite.append("\t\t<service name=\"" + portType.getQName().getLocalPart() + "\" promote=\"" + portType.getQName().getLocalPart() + "\">\r\n");
                composite.append("\t\t\t<binding.soap xmlns=\"urn:switchyard-component-soap:config:1.0\">\r\n");
                composite.append("\t\t\t\t<wsdl>wsdl/" + wsdlName + "</wsdl>\r\n");
                composite.append("\t\t\t\t<socketAddr>:18001</socketAddr>\r\n");
                composite.append("\t\t\t</binding.soap>\r\n");
                composite.append("\t\t</service>\r\n");
                for (int i = 0; i < refWsdlPaths.size(); ++i) {
                    String refWsdlPath = refWsdlPaths.get(i);
                    Definition refDefn = this.getWSDLReader().readWSDL(refWsdlPath);
                    if (refDefn == null) continue;
                    for (PortType refPortType : refDefn.getPortTypes().values()) {
                        String refWsdlName = refWsdlPath;
                        ind = refWsdlName.lastIndexOf(47);
                        if (ind != -1) {
                            refWsdlName = refWsdlName.substring(ind + 1);
                        }
                        composite.append("\t\t<reference name=\"" + refPortType.getQName().getLocalPart() + "\" promote=\"" + refPortType.getQName().getLocalPart() + "\" multiplicity=\"1..1\" >\r\n");
                        composite.append("\t\t\t<binding.soap xmlns=\"urn:switchyard-component-soap:config:1.0\">\r\n");
                        composite.append("\t\t\t\t<wsdl>wsdl/" + refWsdlName + "</wsdl>\r\n");
                        composite.append("\t\t\t\t<socketAddr>:18001</socketAddr>\r\n");
                        composite.append("\t\t\t</binding.soap>\r\n");
                        composite.append("\t\t</reference>\r\n");
                    }
                }
            }
            composite.append("\t</composite>\r\n");
            composite.append("</switchyard>\r\n");
            FileOutputStream fos = new FileOutputStream(resourceFolder + File.separatorChar + "switchyard.xml");
            fos.write(composite.toString().getBytes());
            fos.close();
        }
    }

    protected void addServiceBehaviour(File implFile, Role role, List<Role> refRoles, ProtocolModel behaviour, String srcFolder, ResourceLocator locator) throws Exception {
        int ind;
        FileInputStream fis = new FileInputStream(implFile);
        byte[] b = new byte[fis.available()];
        fis.read(b);
        fis.close();
        HashMap<Role, String> roleMapping = new HashMap<Role, String>();
        for (Role r : refRoles) {
            String varName = "_" + Character.toLowerCase(r.getName().charAt(0)) + r.getName().substring(1);
            roleMapping.put(r, varName);
        }
        String str = new String(b);
        int index = 0;
        JavaBehaviourGenerator bg = new JavaBehaviourGenerator(behaviour, locator);
        do {
            if ((index = str.indexOf("    public ", index)) == -1) continue;
            int startIndex = str.indexOf("{", index);
            int endIndex = str.indexOf("\n    }", startIndex);
            if (startIndex != -1 && endIndex != -1) {
                String[] reg = str.substring(index, startIndex).split("[ \\(\\)]");
                String opbody = bg.getOperationBody(reg[6], reg[5], reg[7], reg[8], roleMapping);
                if (opbody != null) {
                    str = str.substring(0, startIndex + 1) + opbody + str.substring(endIndex);
                    index = startIndex + 1 + opbody.length();
                    continue;
                }
                index = endIndex;
                continue;
            }
            index = -1;
        } while (index != -1);
        String importStatements = bg.getImportStatements();
        if (importStatements != null && (ind = str.indexOf("import")) != -1) {
            str = str.substring(0, ind) + importStatements + "\r\n" + str.substring(ind);
        }
        FileOutputStream fos = new FileOutputStream(implFile);
        fos.write(str.getBytes());
        fos.close();
    }
}

