/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc.io;

import java.io.File;
import java.io.FileInputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.CharsetDecoder;
import scala.Array$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.internal.util.NoPosition$;
import scala.reflect.internal.util.Position;
import scala.reflect.io.AbstractFile;
import scala.reflect.io.PlainFile;
import scala.reflect.io.ZipArchive;
import scala.tools.nsc.io.SourceReader$;
import scala.tools.nsc.reporters.Reporter;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dc\u0001B\u000b\u0017\u0001}A\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!\n\u0005\t_\u0001\u0011\t\u0011)A\u0005a!)a\u0007\u0001C\u0001o!9A\b\u0001b\u0001\n\u0013i\u0004B\u0002\"\u0001A\u0003%a\bC\u0004D\u0001\u0001\u0007I\u0011\u0002#\t\u000f!\u0003\u0001\u0019!C\u0005\u0013\"1q\n\u0001Q!\n\u0015CQ\u0001\u0015\u0001\u0005\nECQA\u001b\u0001\u0005\u0002-DQA\u001b\u0001\u0005\u0002iDQA\u001b\u0001\u0005\u0012}DaA\u001b\u0001\u0005\u0012\u0005E\u0001bBA\u000b\u0001\u0011%\u0011qC\u0004\b\u000371\u0002\u0012AA\u000f\r\u0019)b\u0003#\u0001\u0002 !1a\u0007\u0005C\u0001\u0003CAq!a\t\u0011\t\u0003\t)\u0003C\u0004\u00028A!\t!!\u000f\t\u000f\u0005}\u0002\u0003\"\u0003\u0002B\ta1k\\;sG\u0016\u0014V-\u00193fe*\u0011q\u0003G\u0001\u0003S>T!!\u0007\u000e\u0002\u00079\u001c8M\u0003\u0002\u001c9\u0005)Ao\\8mg*\tQ$A\u0003tG\u0006d\u0017m\u0001\u0001\u0014\u0005\u0001\u0001\u0003CA\u0011#\u001b\u0005a\u0012BA\u0012\u001d\u0005\u0019\te.\u001f*fM\u00069A-Z2pI\u0016\u0014\bC\u0001\u0014.\u001b\u00059#B\u0001\u0015*\u0003\u001d\u0019\u0007.\u0019:tKRT!AK\u0016\u0002\u00079LwNC\u0001-\u0003\u0011Q\u0017M^1\n\u00059:#AD\"iCJ\u001cX\r\u001e#fG>$WM]\u0001\te\u0016\u0004xN\u001d;feB\u0011\u0011\u0007N\u0007\u0002e)\u00111\u0007G\u0001\ne\u0016\u0004xN\u001d;feNL!!\u000e\u001a\u0003\u0011I+\u0007o\u001c:uKJ\fa\u0001P5oSRtDc\u0001\u001d;wA\u0011\u0011\bA\u0007\u0002-!)Ae\u0001a\u0001K!)qf\u0001a\u0001a\u0005)!-\u001f;fgV\ta\b\u0005\u0002@\u00016\t\u0011&\u0003\u0002BS\tQ!)\u001f;f\u0005V4g-\u001a:\u0002\r\tLH/Z:!\u0003\u0015\u0019\u0007.\u0019:t+\u0005)\u0005CA G\u0013\t9\u0015F\u0001\u0006DQ\u0006\u0014()\u001e4gKJ\f\u0011b\u00195beN|F%Z9\u0015\u0005)k\u0005CA\u0011L\u0013\taED\u0001\u0003V]&$\bb\u0002(\b\u0003\u0003\u0005\r!R\u0001\u0004q\u0012\n\u0014AB2iCJ\u001c\b%A\nsKB|'\u000f^#oG>$\u0017N\\4FeJ|'\u000fF\u0002K%~CQaU\u0005A\u0002Q\u000b\u0001BZ5mK:\fW.\u001a\t\u0003+rs!A\u0016.\u0011\u0005]cR\"\u0001-\u000b\u0005es\u0012A\u0002\u001fs_>$h(\u0003\u0002\\9\u00051\u0001K]3eK\u001aL!!\u00180\u0003\rM#(/\u001b8h\u0015\tYF\u0004C\u0003a\u0013\u0001\u0007\u0011-A\u0001f!\t\u0011wM\u0004\u0002dK:\u0011q\u000bZ\u0005\u0002;%\u0011a\rH\u0001\ba\u0006\u001c7.Y4f\u0013\tA\u0017NA\u0005Fq\u000e,\u0007\u000f^5p]*\u0011a\rH\u0001\u0005e\u0016\fG\r\u0006\u0002meB\u0019\u0011%\\8\n\u00059d\"!B!se\u0006L\bCA\u0011q\u0013\t\tHD\u0001\u0003DQ\u0006\u0014\b\"B:\u000b\u0001\u0004!\u0018\u0001\u00024jY\u0016\u0004\"!^<\u000f\u0005e2\u0018B\u00014\u0017\u0013\tA\u0018PA\u0003K\r&dWM\u0003\u0002g-Q\u0011An\u001f\u0005\u0006g.\u0001\r\u0001 \t\u0003kvL!A`=\u0003\u0019\u0005\u00137\u000f\u001e:bGR4\u0015\u000e\\3\u0015\u00071\f\t\u0001C\u0004\u0002\u00041\u0001\r!!\u0002\u0002\u000b%t\u0007/\u001e;\u0011\t\u0005\u001d\u0011QB\u0007\u0003\u0003\u0013Q1!a\u0003*\u0003!\u0019\u0007.\u00198oK2\u001c\u0018\u0002BA\b\u0003\u0013\u00111CU3bI\u0006\u0014G.\u001a\"zi\u0016\u001c\u0005.\u00198oK2$2\u0001\\A\n\u0011\u0015aT\u00021\u0001?\u0003%!XM]7j]\u0006$X\rF\u0002m\u00033AQa\u0011\bA\u0002\u0015\u000bAbU8ve\u000e,'+Z1eKJ\u0004\"!\u000f\t\u0014\u0005A\u0001CCAA\u000f\u0003\u0019!WmY8eKRIQ)a\n\u0002*\u0005-\u0012Q\u0006\u0005\u0006II\u0001\r!\n\u0005\u0006yI\u0001\rA\u0010\u0005\u0006\u0007J\u0001\r!\u0012\u0005\b\u0003_\u0011\u0002\u0019AA\u0019\u0003))g\u000eZ(g\u0013:\u0004X\u000f\u001e\t\u0004C\u0005M\u0012bAA\u001b9\t9!i\\8mK\u0006t\u0017!\u00024mkNDG#B#\u0002<\u0005u\u0002\"\u0002\u0013\u0014\u0001\u0004)\u0003\"B\"\u0014\u0001\u0004)\u0015\u0001E5oGJ,\u0017m]3DCB\f7-\u001b;z)\r)\u00151\t\u0005\u0007\u0003\u000b\"\u0002\u0019A#\u0002\r\t,hMZ3s\u0001")
public class SourceReader {
    private final CharsetDecoder decoder;
    private final Reporter reporter;
    private final ByteBuffer bytes;
    private CharBuffer chars;

    public static CharBuffer flush(CharsetDecoder charsetDecoder, CharBuffer charBuffer) {
        return SourceReader$.MODULE$.flush(charsetDecoder, charBuffer);
    }

    public static CharBuffer decode(CharsetDecoder charsetDecoder, ByteBuffer byteBuffer, CharBuffer charBuffer, boolean bl) {
        return SourceReader$.MODULE$.decode(charsetDecoder, byteBuffer, charBuffer, bl);
    }

    private ByteBuffer bytes() {
        return this.bytes;
    }

    private CharBuffer chars() {
        return this.chars;
    }

    private void chars_$eq(CharBuffer x$1) {
        this.chars = x$1;
    }

    private void reportEncodingError(String filename, Exception e) {
        String advice = "Please try specifying another one using the -encoding option";
        this.reporter.error((Position)NoPosition$.MODULE$, new StringBuilder(33).append("IO error while decoding ").append(filename).append(" with ").append(this.decoder.charset()).append(": ").append(e.getMessage()).append("\n").append(advice).toString());
    }

    public char[] read(File file) {
        char[] cArray;
        try (FileChannel c = new FileInputStream(file).getChannel();){
            try {
                cArray = this.read(c);
            }
            catch (InterruptedException interruptedException) {
                throw interruptedException;
            }
            catch (ClosedByInterruptException closedByInterruptException) {
                throw new InterruptedException();
            }
            catch (Exception e) {
                this.reportEncodingError(String.valueOf(file), e);
                cArray = (char[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Char());
            }
        }
        return cArray;
    }

    public char[] read(AbstractFile file) {
        try {
            char[] cArray;
            if (file instanceof PlainFile) {
                PlainFile plainFile = (PlainFile)file;
                cArray = this.read(plainFile.file());
            } else if (file instanceof ZipArchive.Entry) {
                ZipArchive.Entry entry = (ZipArchive.Entry)file;
                cArray = this.read(Channels.newChannel(entry.input()));
            } else {
                cArray = this.read(ByteBuffer.wrap(file.unsafeToByteArray()));
            }
            return cArray;
        }
        catch (InterruptedException interruptedException) {
            throw interruptedException;
        }
        catch (ClosedByInterruptException closedByInterruptException) {
            throw new InterruptedException();
        }
        catch (Exception e) {
            this.reportEncodingError(String.valueOf(file), e);
            return (char[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Char());
        }
    }

    public char[] read(ReadableByteChannel input) {
        CharsetDecoder decoder = this.decoder.reset();
        ByteBuffer bytes = this.bytes();
        bytes.clear();
        CharBuffer chars = this.chars();
        chars.clear();
        boolean endOfInput = false;
        while (!endOfInput) {
            endOfInput = input.read(bytes) < 0;
            bytes.flip();
            chars = SourceReader$.MODULE$.decode(decoder, bytes, chars, endOfInput);
        }
        return this.terminate(SourceReader$.MODULE$.flush(decoder, chars));
    }

    public char[] read(ByteBuffer bytes) {
        CharsetDecoder decoder = this.decoder.reset();
        CharBuffer chars = this.chars();
        chars.clear();
        return this.terminate(SourceReader$.MODULE$.flush(decoder, SourceReader$.MODULE$.decode(decoder, bytes, chars, true)));
    }

    /*
     * WARNING - void declaration
     */
    private char[] terminate(CharBuffer chars) {
        void var2_2;
        char[] result = new char[chars.length()];
        chars.get(result);
        this.chars_$eq(chars);
        return var2_2;
    }

    public SourceReader(CharsetDecoder decoder, Reporter reporter) {
        this.decoder = decoder;
        this.reporter = reporter;
        this.bytes = ByteBuffer.allocate(16384);
        this.chars = CharBuffer.allocate(16384);
    }
}

